/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntersectionTypeImpl
extends JSCompositeTypeBaseImpl
implements JSUnionOrIntersectionType {
    public static final String SEPARATOR = "&";

    @NotNull
    public static JSType getIntersectionType(@NotNull Collection<JSType> types, @NotNull JSTypeSource source) {
        if (types == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(1);
        }
        JSType jSType = JSIntersectionTypeImpl.getIntersectionType(types, source, false);
        if (jSType == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(2);
        }
        return jSType;
    }

    @NotNull
    private static JSType getIntersectionType(@NotNull Collection<? extends JSType> types, @NotNull JSTypeSource source, boolean allowResolve) {
        if (types == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(3);
        }
        if (source == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(4);
        }
        LinkedHashSet plainTypes = ContainerUtil.newLinkedHashSet();
        JSIntersectionTypeImpl.addTypesOverIntersection(types, plainTypes);
        JSType simplifiedType = JSIntersectionTypeImpl.getSimplifiedTypeIfPossible(plainTypes, source, allowResolve, true);
        if (simplifiedType != null) {
            JSType jSType = simplifiedType;
            if (jSType == null) {
                JSIntersectionTypeImpl.$$$reportNull$$$0(5);
            }
            return jSType;
        }
        JSIntersectionTypeImpl jSIntersectionTypeImpl = new JSIntersectionTypeImpl(source, plainTypes);
        if (jSIntersectionTypeImpl == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(6);
        }
        return jSIntersectionTypeImpl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected static JSType getSimplifiedTypeIfPossible(@NotNull Collection<? extends JSType> plainTypes, JSTypeSource source, boolean allowResolve, boolean intersection) {
        if (plainTypes == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(7);
        }
        ProgressManager.checkCanceled();
        int i = -1;
        if (plainTypes.size() == 0) {
            return JSAnyType.get(null, false);
        }
        if (plainTypes.size() == 1) {
            return (JSType)ContainerUtil.getFirstItem(plainTypes);
        }
        if (intersection && JSIntersectionTypeImpl.hasAnyType(plainTypes)) {
            JSType item = (JSType)ContainerUtil.getFirstItem(plainTypes);
            assert (item != null);
            return JSAnyType.get(null, true);
        }
        if (!intersection) {
            return null;
        }
        for (JSType jSType : plainTypes) {
            void var6_7;
            ++i;
            if (allowResolve) {
                JSType jSType2 = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(jSType);
            }
            if (!(var6_7 instanceof JSCompositeTypeImpl)) continue;
            List<JSType> parts = ((JSCompositeTypeImpl)var6_7).getTypes();
            ArrayList newParts = ContainerUtil.newArrayListWithCapacity((int)parts.size());
            ArrayList typesCopy = ContainerUtil.newArrayList(plainTypes);
            for (JSType part : parts) {
                ProgressManager.checkCanceled();
                typesCopy.set(i, part);
                newParts.add(JSIntersectionTypeImpl.getIntersectionType(typesCopy, source, allowResolve));
            }
            return new JSCompositeTypeImpl(source, newParts);
        }
        return null;
    }

    public static boolean hasAnyType(@NotNull Collection<? extends JSType> types) {
        if (types == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(8);
        }
        for (JSType jSType : types) {
            if (!(jSType instanceof JSAnyType)) continue;
            return true;
        }
        return false;
    }

    protected static void addTypesOverIntersection(@Nullable Collection<? extends JSType> typesToAdd, @NotNull Collection<JSType> types) {
        if (types == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(9);
        }
        if (typesToAdd == null) {
            return;
        }
        ProgressManager.checkCanceled();
        for (JSType jSType : typesToAdd) {
            if (jSType instanceof JSIntersectionTypeImpl) {
                JSIntersectionTypeImpl.addTypesOverIntersection(((JSIntersectionTypeImpl)jSType).getTypes(), types);
                continue;
            }
            types.add(jSType);
        }
    }

    public JSIntersectionTypeImpl(@NotNull JSTypeSource source, @NotNull Collection<JSType> _types) {
        if (source == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(10);
        }
        if (_types == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(11);
        }
        super(source, _types);
    }

    protected JSIntersectionTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(12);
        }
        if (inputStream == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(13);
        }
        super(source, inputStream);
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(14);
        }
        if (!JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext) && this.isEquivalentTo(elementType, processingContext)) {
            return true;
        }
        boolean allAssignable = true;
        boolean hadAssignable = false;
        List<JSType> types = this.getTypes();
        for (JSType type : types) {
            if (!type.isDirectlyAssignableType(elementType, processingContext)) {
                allAssignable = false;
                break;
            }
            hadAssignable = true;
        }
        if (allAssignable) {
            return true;
        }
        if (types.stream().allMatch(t -> (t = TypeScriptTypeRelations.expandTypeRecursive(t, false)) instanceof JSRecordType && (((JSRecordType)t).isWeak() || !((JSRecordType)t).hasProperties()))) {
            if (hadAssignable) {
                return true;
            }
            return this.substitute().isDirectlyAssignableType(elementType, processingContext);
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected String getTypeSeparator() {
        if (SEPARATOR == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(15);
        }
        return SEPARATOR;
    }

    @Override
    @NotNull
    protected JSType createType(@NotNull List<JSType> transformedTypes, @NotNull JSTypeSource newSource) {
        if (transformedTypes == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(16);
        }
        if (newSource == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(17);
        }
        JSType jSType = JSIntersectionTypeImpl.getIntersectionType(transformedTypes, newSource);
        if (jSType == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(18);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSType substituteCompositeImpl() {
        JSType result2 = this.getSimpleCompositeTypeResult();
        if (result2 != null) {
            JSType jSType = result2;
            if (jSType == null) {
                JSIntersectionTypeImpl.$$$reportNull$$$0(19);
            }
            return jSType;
        }
        Collection<JSRecordType> resolvedTypes = this.getNestedTypesAsRecordType();
        if (resolvedTypes.isEmpty()) {
            JSAnyType jSAnyType = JSAnyType.get(this.getSource().getSourceElement(), this.getSource().isStrict());
            if (jSAnyType == null) {
                JSIntersectionTypeImpl.$$$reportNull$$$0(20);
            }
            return jSAnyType;
        }
        ArrayList resultMembers = ContainerUtil.newArrayList();
        LinkedMultiMap map = new LinkedMultiMap();
        for (JSRecordType resolvedType : resolvedTypes) {
            for (JSRecordType.TypeMember member : resolvedType.getTypeMembers()) {
                ProgressManager.checkCanceled();
                if (member instanceof JSRecordType.PropertySignature) {
                    Object signatures;
                    JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)member;
                    String name = propertySignature.getMemberName();
                    if (map.containsKey((Object)name) && (signatures = map.get((Object)name)).stream().anyMatch(s -> JSIntersectionTypeImpl.signaturesAreSkippablyEquivalent(propertySignature, s))) continue;
                    map.putValue((Object)name, (Object)propertySignature);
                    continue;
                }
                resultMembers.add(member);
            }
        }
        if (map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                ProgressManager.checkCanceled();
                Collection value = (Collection)entry.getValue();
                boolean isOptional = true;
                ArrayList types = ContainerUtil.newArrayList();
                ArrayList propertySources = ContainerUtil.newArrayListWithCapacity((int)value.size());
                for (JSRecordType.PropertySignature signature : value) {
                    if (!signature.isOptional()) {
                        isOptional = false;
                    }
                    if (signature.getType() != null) {
                        types.add(signature.getType());
                    }
                    JSRecordType.MemberSource source = signature.getMemberSource();
                    propertySources.addAll(source.getAllSourceElements());
                }
                JSType resultType = JSIntersectionTypeImpl.getIntersectionType(types, this.getSource());
                resultMembers.add(new JSRecordTypeImpl.PropertySignatureImpl((String)entry.getKey(), resultType, isOptional, JSRecordMemberSourceFactory.createSource(propertySources, JSRecordType.MemberSourceKind.Intersection)));
            }
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.getSource(), resultMembers);
        if (jSRecordTypeImpl == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(21);
        }
        return jSRecordTypeImpl;
    }

    private static boolean signaturesAreSkippablyEquivalent(JSRecordType.PropertySignature propertySignature, JSRecordType.PropertySignature s) {
        if (!s.isEquivalentTo((JSRecordType.TypeMember)propertySignature, true)) {
            return false;
        }
        JSRecordType.MemberSource memberSource = s.getMemberSource();
        JSRecordType.MemberSource otherSource = propertySignature.getMemberSource();
        if (memberSource.getMemberSourceKind() != JSRecordType.MemberSourceKind.Identity || otherSource.getMemberSourceKind() != JSRecordType.MemberSourceKind.Identity) {
            return false;
        }
        return memberSource.getSingleElement() == otherSource.getSingleElement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSIntersectionTypeImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plainTypes";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_types";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformedTypes";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSIntersectionTypeImpl";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntersectionType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSeparator";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteCompositeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIntersectionType";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSimplifiedTypeIfPossible";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasAnyType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addTypesOverIntersection";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

