/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.ecmascript6.types.JSTypeResolvedHashCodeUtil;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeUtil;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Getter;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGenericTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure {
    @NotNull
    private final JSType myType;
    @NotNull
    private final List<JSType> myArguments;
    @NotNull
    private final Map<String, JSType> myOuterArguments;

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @Nullable Map<String, JSType> outer) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(0);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(1);
        }
        super(source);
        this.myType = type;
        this.myArguments = ContainerUtil.immutableList((Object[])new JSType[0]);
        this.myOuterArguments = outer == null ? Collections.emptyMap() : outer;
    }

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @NotNull JSType argument) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(2);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(3);
        }
        if (argument == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(4);
        }
        super(source);
        this.myType = type;
        this.myArguments = ContainerUtil.immutableList((Object[])new JSType[]{argument});
        this.myOuterArguments = Collections.emptyMap();
    }

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @NotNull List<JSType> arguments, @NotNull Map<String, JSType> outer) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(5);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(6);
        }
        if (arguments == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(7);
        }
        if (outer == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(8);
        }
        super(source);
        this.myType = type;
        this.myArguments = ContainerUtil.immutableList(arguments);
        this.myOuterArguments = outer;
    }

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, List<JSType> arguments) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(9);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(10);
        }
        this(source, type, arguments, Collections.emptyMap());
    }

    protected JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(11);
        }
        if (inputStream == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(12);
        }
        super(source);
        this.myType = JSTypeSerializer.TYPE_SERIALIZER.read(source, inputStream);
        this.myArguments = JSTypeSerializer.TYPES_SERIALIZER.read(source, inputStream);
        this.myOuterArguments = Collections.emptyMap();
    }

    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(13);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myType, outputStream);
        JSTypeSerializer.TYPES_SERIALIZER.write(this.myArguments, outputStream);
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSGenericType((JSType)this);
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        this.myType.accept(visitor);
        for (JSType argument : this.myArguments) {
            argument.accept(visitor);
        }
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        StringBuilder builder = new StringBuilder();
        if (!this.isTypeScript()) {
            boolean wrapInBraces = JSTypeUtils.isNeedWrapTypeForSerialization(this.myType);
            if (wrapInBraces) {
                builder.append("(");
            }
            builder.append(this.myType.getTypeText(format));
            if (wrapInBraces) {
                builder.append(")");
            }
            if (this.getSource().getLanguage() == JSTypeSource.SourceLanguage.AS) {
                builder.append('.');
            }
            this.appendArgumentTypeText(format, builder);
        } else {
            boolean isNestedFunctionType = this.myType instanceof JSFunctionTypeImpl;
            if (isNestedFunctionType) {
                this.appendArgumentTypeText(format, builder);
                builder.append(this.myType.getTypeText(format));
            } else {
                builder.append(this.myType.getTypeText(format));
                this.appendArgumentTypeText(format, builder);
            }
        }
        String string = builder.toString();
        if (string == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    protected int resolvedHashCodeImpl() {
        int arguments = JSTypeResolvedHashCodeUtil.getResolvedHashCode(this.getArguments());
        int desc = Objects.hash(((Object)((Object)this)).getClass(), this.getType().resolvedHashCode(), arguments);
        Map<String, JSType> outer = this.getOuterArguments();
        if (outer.isEmpty()) {
            return desc;
        }
        int outerKeys = JSTypeResolvedHashCodeUtil.getHashCode(outer.keySet());
        int outerValues = JSTypeResolvedHashCodeUtil.getResolvedHashCode(outer.values());
        return Objects.hash(desc, outerKeys, outerValues);
    }

    private void appendArgumentTypeText(@NotNull JSType.TypeTextFormat format, @NotNull StringBuilder builder) {
        if (format == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(15);
        }
        if (builder == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(16);
        }
        builder.append("<");
        String prefix = "";
        for (JSType argument : this.myArguments) {
            JSType constraint;
            builder.append(prefix);
            builder.append(argument.getTypeText(format));
            if (argument instanceof JSGenericParameterImpl && !((JSGenericParameterImpl)argument).isCallEnvironment() && (constraint = ((JSGenericParameterImpl)argument).getConstraintType()) != null) {
                builder.append(" extends ");
                builder.append(constraint.getTypeText(format));
            }
            prefix = ", ";
        }
        builder.append(">");
    }

    @Override
    @Nullable
    public JSClass resolveClass() {
        return this.myType.resolveClass();
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(17);
        }
        if (this.isTypeScript()) {
            return this.isDirectAssignableTypeInTypeScript(elementType, processingContext);
        }
        if (elementType instanceof JSGenericTypeImpl) {
            if (!this.myType.isDirectlyAssignableType(((JSGenericTypeImpl)elementType).myType, processingContext)) {
                return false;
            }
            List<JSType> elementTypeArgs = ((JSGenericTypeImpl)elementType).myArguments;
            ListIterator<JSType> iterator = elementTypeArgs.listIterator();
            boolean allArgumentsEquivalent = true;
            for (JSType argument : this.myArguments) {
                allArgumentsEquivalent &= iterator.hasNext() && JSTypeUtils.areTypesCompatible(argument, iterator.next(), processingContext, null);
            }
            return this.getSource().getLanguage() == JSTypeSource.SourceLanguage.JS || allArgumentsEquivalent && !iterator.hasNext();
        }
        if (JSGenericTypeImpl.isGenericActionScriptVectorType(this) && !(elementType instanceof JSNullType) && !(elementType instanceof JSAnyType)) {
            return false;
        }
        if (elementType instanceof JSArrayTypeImpl) {
            return this.isDirectlyAssignableType(((JSArrayTypeImpl)elementType).asGenericType(), processingContext);
        }
        if (elementType instanceof JSTypeofTypeImpl) {
            return this.isDirectlyAssignableType(elementType.substitute(), processingContext);
        }
        return this.myType.isDirectlyAssignableType(elementType, processingContext);
    }

    private boolean isDirectAssignableTypeInTypeScript(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult type;
        JSType typedef;
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(18);
        }
        if (processingContext == null) {
            processingContext = new ProcessingContext();
        }
        if (elementType instanceof JSTypeImpl && (typedef = ((JSTypeImpl)elementType).getTypedef(null, processingContext)) != null) {
            elementType = typedef;
        }
        if (elementType instanceof JSTupleTypeImpl) {
            return this.isDirectlyAssignableType(((JSTupleTypeImpl)elementType).toArrayType(true), processingContext);
        }
        if (elementType instanceof JSArrayType) {
            elementType = ((JSArrayType)elementType).asGenericType();
        } else {
            JSType resolved;
            if (elementType instanceof JSCompositeTypeImpl) {
                JSCompositeTypeImpl composite = (JSCompositeTypeImpl)elementType;
                boolean isAssignable = true;
                for (JSType type2 : composite.getTypes()) {
                    if (this.isDirectlyAssignableType(type2, processingContext)) continue;
                    isAssignable = false;
                    break;
                }
                return isAssignable;
            }
            if (elementType instanceof JSRecordType && this != (resolved = this.substitute())) {
                return resolved.isDirectlyAssignableType(elementType, processingContext);
            }
        }
        if (elementType instanceof JSGenericTypeImpl && (type = this.isDirectlyAssignableGenericType((JSGenericTypeImpl)elementType, processingContext)).isStrict()) {
            return type.isAssignable();
        }
        JSType elemType = elementType;
        JSType resolved = this.substitute();
        if (resolved != this) {
            JSResolvedTypeId rTypeNestedId = (elementType instanceof JSGenericTypeImpl ? ((JSGenericTypeImpl)elementType).getType() : elementType).getResolvedTypeId();
            JSResolvedTypeId lTypeNestedId = this.getType().getResolvedTypeId();
            ProcessingContext finalProcessingContext = processingContext;
            return JSRecursiveTypeUtil.computeWithRecursiveTypes(lTypeNestedId, rTypeNestedId, JSRecursiveTypeUtil.GENERICS_SUBSTITUTION, processingContext, (Getter<Boolean>)((Getter)() -> resolved.isDirectlyAssignableType(elemType, finalProcessingContext)));
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult result2;
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(19);
        }
        if ((result2 = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult = result2;
            if (assignableResult == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(20);
            }
            return assignableResult;
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(this.myType.isDirectlyAssignableType(elementType, processingContext));
        if (assignableResult == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(21);
        }
        return assignableResult;
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(22);
        }
        if (type instanceof JSGenericTypeImpl) {
            if (!this.myType.isEquivalentTo(((JSGenericTypeImpl)type).myType, processingContext, allowResolve)) {
                return false;
            }
            return JSGenericTypeImpl.areGenericArgumentsAssignable(this, (JSGenericTypeImpl)type, processingContext, true, allowResolve) == JSTypeCastUtil.AssignableResult.ASSIGNABLE;
        }
        return false;
    }

    public JSTypeCastUtil.AssignableResult isDirectlyAssignableGenericType(@NotNull JSGenericTypeImpl elementType, @NotNull ProcessingContext processingContext) {
        JSType rMainType;
        boolean isSameMainType;
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(23);
        }
        if (processingContext == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(24);
        }
        if (isSameMainType = this.myType.isEquivalentTo(rMainType = elementType.myType, processingContext)) {
            JSTypeCastUtil.AssignableResult assignableResult = JSGenericTypeImpl.areGenericArgumentsAssignable(this, elementType, processingContext, false, true);
            if (assignableResult.isAssignable() || !assignableResult.isStrict()) {
                return JSTypeCastUtil.AssignableResult.ASSIGNABLE;
            }
            if (this.myType instanceof JSPrimitiveArrayType && rMainType instanceof JSPrimitiveArrayType) {
                return JSTypeCastUtil.AssignableResult.NOT_ASSIGNABLE;
            }
        } else if (rMainType instanceof JSNamedType && this.myType instanceof JSNamedType) {
            Collection<? extends PsiElement> lOpElements = TypeScriptTypeParser.resolveElementsByType(this.myType);
            Collection<? extends PsiElement> rOpElements = TypeScriptTypeParser.resolveElementsByType(rMainType);
            for (PsiElement psiElement : lOpElements) {
                for (PsiElement psiElement2 : rOpElements) {
                    JSClass parentClass;
                    JSClass childClass;
                    if (!(psiElement instanceof JSClass) || !(psiElement2 instanceof JSClass) || !JSInheritanceUtil.isParentClass(childClass = (JSClass)psiElement, parentClass = (JSClass)psiElement2, false)) continue;
                    JSResolvedTypeId thisText = this.getResolvedTypeId();
                    JSResolvedTypeId elementText = elementType.getResolvedTypeId();
                    TypeScriptTypeParameterList list = ((TypeScriptTypeParameterListOwner)parentClass).getTypeParameterList();
                    JSTypeCastUtil.AssignableResult result2 = JSTypeCastUtil.AssignableResult.NOT_SURE;
                    if (list != null) {
                        JSTypeSource source = rMainType.getSource();
                        ArrayList rawGenerics = ContainerUtil.newArrayList();
                        for (TypeScriptTypeParameter parameter : list.getTypeParameters()) {
                            String name = parameter.getName();
                            if (name == null) continue;
                            rawGenerics.add(JSNamedType.createType(name, source, JSContext.INSTANCE));
                        }
                        JSGenericTypeImpl guessedType = new JSGenericTypeImpl(rMainType.getSource(), rMainType, rawGenerics);
                        JSType type = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(childClass, elementType.getArguments(), parentClass, guessedType);
                        if (type instanceof JSGenericTypeImpl) {
                            result2 = JSGenericTypeImpl.areGenericArgumentsAssignable(this, (JSGenericTypeImpl)type, processingContext, false, true);
                        }
                    }
                    return result2;
                }
            }
        }
        return JSTypeCastUtil.AssignableResult.NOT_SURE;
    }

    public static JSTypeCastUtil.AssignableResult areGenericArgumentsAssignable(@NotNull JSGenericTypeImpl lType, @NotNull JSGenericTypeImpl rType, @Nullable ProcessingContext processingContext, boolean checkEquivalent, boolean allowResolve) {
        if (lType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(25);
        }
        if (rType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(26);
        }
        Iterator<JSType> iterator = rType.myArguments.iterator();
        for (JSType argument : lType.myArguments) {
            boolean result2;
            if (!iterator.hasNext()) {
                return JSTypeCastUtil.AssignableResult.NOT_SURE;
            }
            JSType next = iterator.next();
            if (!(checkEquivalent ? !argument.isEquivalentTo(next, processingContext, allowResolve) : !(result2 = argument.isDirectlyAssignableType(next, processingContext)))) continue;
            return JSTypeCastUtil.AssignableResult.NOT_ASSIGNABLE;
        }
        return iterator.hasNext() ? JSTypeCastUtil.AssignableResult.NOT_SURE : JSTypeCastUtil.AssignableResult.ASSIGNABLE;
    }

    public static boolean isGenericActionScriptVectorType(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof JSGenericTypeImpl && type.getSource().isEcma()) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)type;
            String typeText = genericType.myType.getResolvedTypeText();
            return "Vector".equals(typeText) && genericType.myArguments.size() == 1;
        }
        return false;
    }

    @NotNull
    public JSType getType() {
        JSType jSType = this.myType;
        if (jSType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(27);
        }
        return jSType;
    }

    @NotNull
    public List<JSType> getArguments() {
        List<JSType> list = this.myArguments;
        if (list == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(28);
        }
        return list;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(29);
        }
        JSType oldType = this.getType();
        JSType newType = JSTypeUtils.transformTypeHierarchySafe(oldType, childTransform);
        List<JSType> oldArgs = this.getArguments();
        List newArgs = ContainerUtil.map(oldArgs, type -> {
            if (childTransform == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(37);
            }
            return JSTypeUtils.transformTypeHierarchySafe(type, childTransform);
        });
        Map<String, JSType> oldOuterArgs = this.getOuterArguments();
        Map<String, JSType> newOuterArgs = null;
        boolean hasNewOuters = false;
        if (!oldOuterArgs.isEmpty()) {
            newOuterArgs = ContainerUtil.newLinkedHashMap();
            for (Map.Entry<String, JSType> entry : oldOuterArgs.entrySet()) {
                JSType oldOuterArgType = entry.getValue();
                JSType newOuterArgType = JSTypeUtils.transformTypeHierarchySafe(oldOuterArgType, childTransform);
                if (newOuterArgType != oldOuterArgType) {
                    hasNewOuters = true;
                }
                newOuterArgs.put(entry.getKey(), newOuterArgType);
            }
        }
        if (!hasNewOuters && ContainerUtil.equalsIdentity(oldArgs, (List)newArgs) && oldType == newType) {
            JSGenericTypeImpl jSGenericTypeImpl = this;
            if (jSGenericTypeImpl == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(30);
            }
            return jSGenericTypeImpl;
        }
        if (newOuterArgs == null) {
            newOuterArgs = Collections.emptyMap();
        }
        if (newType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl newGenericType = (JSGenericTypeImpl)newType;
            JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(this.getSource(), newGenericType.getType(), newGenericType.getArguments(), newOuterArgs);
            if (jSGenericTypeImpl == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(31);
            }
            return jSGenericTypeImpl;
        }
        JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(this.getSource(), newType, newArgs, newOuterArgs);
        if (jSGenericTypeImpl == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(32);
        }
        return jSGenericTypeImpl;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(33);
        }
        JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(source, this.getType(), this.getArguments(), this.getOuterArguments());
        if (jSGenericTypeImpl == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(34);
        }
        return jSGenericTypeImpl;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType jSType = JSTypeImpl.expandTypeOrBuildRecordTypeWithCache(this);
        if (jSType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(35);
        }
        return jSType;
    }

    @NotNull
    public Map<String, JSType> getOuterArguments() {
        Map<String, JSType> map = this.myOuterArguments;
        if (map == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(36);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 14: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 29: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getOuterArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 14: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "appendArgumentTypeText";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isDirectAssignableTypeInTypeScript";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableGenericType";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "areGenericArgumentsAssignable";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$copyTypeHierarchy$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

