/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecursiveTypeTransformer;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSRecursiveExpandTransformer;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSEvaluableTypeBase
extends JSSimpleTypeBaseImpl
implements JSEvaluableType,
JSCodeBasedType {
    @NotNull
    protected final Segment myRange;

    protected JSEvaluableTypeBase(@NotNull JSTypeSource source, @NotNull Segment range) {
        if (source == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(0);
        }
        if (range == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(1);
        }
        super(source);
        this.myRange = range;
    }

    protected JSEvaluableTypeBase(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(3);
        }
        super(source);
        this.myRange = JSTypeSerializer.readSegment(inputStream);
    }

    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(4);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeSegment(this.myRange, outputStream);
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.SIMPLE) {
            Segment range = this.getSegment();
            String string = this.getPrefix() + "(" + range.getStartOffset() + "," + range.getEndOffset() + ")" + this.getPostfix();
            if (string == null) {
                JSEvaluableTypeBase.$$$reportNull$$$0(5);
            }
            return string;
        }
        JSType evaluatedType = this.evaluateTypeRecursive();
        String string = evaluatedType.getTypeText(format);
        if (string == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private JSType evaluateTypeRecursive() {
        JSType eval = this.evaluateType();
        JSType jSType = eval.transformTypeHierarchy((JSRecursiveTypeTransformer)new JSRecursiveExpandTransformer());
        if (jSType == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(7);
        }
        return jSType;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(8);
        }
        JSType type = this.evaluateType();
        return type.isDirectlyAssignableType(elementType, processingContext);
    }

    @Nullable
    protected PsiElement findElementToProcess(@Nullable Segment range) {
        PsiElement element;
        JSTypeSource source = this.getSource();
        PsiElement sourceElement = source.getSourceElement();
        if (sourceElement == null || !sourceElement.isValid()) {
            return null;
        }
        PsiFile scope = source.getScope();
        if (scope == null) {
            return null;
        }
        PsiElement psiElement = element = range != null ? scope.findElementAt(range.getStartOffset()) : null;
        while (element != null && !(element instanceof PsiFile) && element.getTextRange().getStartOffset() == range.getStartOffset() && element.getTextRange().getEndOffset() <= range.getEndOffset()) {
            if (element.getTextRange().getEndOffset() == range.getEndOffset() && this.isElementAcceptable(element)) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    protected abstract boolean isElementAcceptable(@NotNull PsiElement var1);

    @NotNull
    protected abstract JSType processElement(@NotNull PsiElement var1, @NotNull JSType var2, @Nullable Set<PsiElement> var3);

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        Segment otherTypeSegment;
        if (type == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(9);
        }
        if (this.getClass() != type.getClass()) {
            return false;
        }
        JSEvaluableTypeBase otherType = (JSEvaluableTypeBase)type;
        Segment segment = this.getSegment();
        if (!segment.equals(otherTypeSegment = otherType.getSegment())) {
            return false;
        }
        PsiFile lScope = this.getScope();
        if (lScope == null || !lScope.isValid()) {
            return false;
        }
        PsiFile rScope = type.getSource().getScope();
        if (rScope == null || !rScope.isValid()) {
            return false;
        }
        return lScope.getManager().areElementsEquivalent((PsiElement)lScope, (PsiElement)rScope);
    }

    public abstract JSType evaluateType();

    protected abstract String getPrefix();

    protected abstract String getPostfix();

    @NotNull
    public Segment getSegment() {
        Segment segment = this.myRange;
        if (segment == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(10);
        }
        return segment;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType jSType = this.evaluateType();
        if (jSType == null) {
            JSEvaluableTypeBase.$$$reportNull$$$0(11);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSEvaluableTypeBase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSEvaluableTypeBase";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateTypeRecursive";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSegment";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

