/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDecoratedTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure {
    @NotNull
    private final JSType myType;
    @NotNull
    private final Set<TypeDecoration> myDecorations;

    public JSDecoratedTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @NotNull Set<TypeDecoration> decorations) {
        if (source == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(0);
        }
        if (type == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(1);
        }
        if (decorations == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(2);
        }
        super(source);
        this.myType = type;
        this.myDecorations = Collections.unmodifiableSet(decorations);
    }

    protected JSDecoratedTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(3);
        }
        if (inputStream == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(4);
        }
        super(source);
        this.myType = JSTypeSerializer.TYPE_SERIALIZER.read(source, inputStream);
        String s = JSTypeSerializer.readString(inputStream);
        EnumSet<TypeDecoration> decorations = EnumSet.noneOf(TypeDecoration.class);
        if (s.contains("?")) {
            decorations.add(TypeDecoration.NULLABLE);
        }
        if (s.contains("!")) {
            decorations.add(TypeDecoration.NOTNULL);
        }
        this.myDecorations = decorations;
    }

    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(5);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myType, outputStream);
        String s = "";
        if (this.myDecorations.contains((Object)TypeDecoration.NULLABLE)) {
            s = s + "?";
        }
        if (this.myDecorations.contains((Object)TypeDecoration.NOTNULL)) {
            s = s + "!";
        }
        JSTypeSerializer.writeString(s, outputStream);
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        boolean wrapInBrackets;
        if (format == JSType.TypeTextFormat.CODE && !this.isJavaScript()) {
            String string = this.myType.getTypeText(format);
            if (string == null) {
                JSDecoratedTypeImpl.$$$reportNull$$$0(6);
            }
            return string;
        }
        StringBuilder builder = new StringBuilder();
        if (this.myDecorations.contains((Object)TypeDecoration.NOTNULL)) {
            builder.append("!");
        }
        if (this.myDecorations.contains((Object)TypeDecoration.NULLABLE)) {
            builder.append("?");
        }
        boolean bl = wrapInBrackets = (this.myDecorations.contains((Object)TypeDecoration.NOTNULL) || this.myDecorations.contains((Object)TypeDecoration.NULLABLE)) && JSTypeUtils.isNeedWrapTypeForSerialization(this.myType);
        if (wrapInBrackets) {
            builder.append("(");
        }
        builder.append(this.myType.getTypeText(format));
        if (wrapInBrackets) {
            builder.append(")");
        }
        String string = builder.toString();
        if (string == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.myType.resolvedHashCode(), this.myDecorations.hashCode());
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(8);
        }
        if (this.myDecorations.contains((Object)TypeDecoration.NOTNULL)) {
            if (elementType instanceof JSNullType || elementType instanceof JSDecoratedTypeImpl && ((JSDecoratedTypeImpl)elementType).myDecorations.contains((Object)TypeDecoration.NULLABLE)) {
                return false;
            }
        } else if (this.myDecorations.contains((Object)TypeDecoration.NULLABLE) && elementType instanceof JSNullType) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult assignableResult;
        if (elementType == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(9);
        }
        if ((assignableResult = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult2 = assignableResult;
            if (assignableResult2 == null) {
                JSDecoratedTypeImpl.$$$reportNull$$$0(10);
            }
            return assignableResult2;
        }
        JSTypeCastUtil.AssignableResult assignableResult3 = JSTypeCastUtil.toStrictAssignable(this.myType.isDirectlyAssignableType(elementType, processingContext));
        if (assignableResult3 == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(11);
        }
        return assignableResult3;
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(12);
        }
        if (type instanceof JSDecoratedTypeImpl) {
            JSDecoratedTypeImpl decoratedType = (JSDecoratedTypeImpl)type;
            return this.myDecorations.equals(decoratedType.getDecorations()) && this.myType.isEquivalentTo(decoratedType.getType(), processingContext, allowResolve);
        }
        return false;
    }

    @NotNull
    public Set<TypeDecoration> getDecorations() {
        Set<TypeDecoration> set = this.myDecorations;
        if (set == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    public JSType getType() {
        JSType jSType = this.myType;
        if (jSType == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(14);
        }
        return jSType;
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSDecoratedType((JSType)this);
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        this.myType.accept(visitor);
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        JSType newType;
        JSType oldType;
        if (childTransform == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(15);
        }
        if ((oldType = this.getType()) == (newType = JSTypeUtils.transformTypeHierarchySafe(oldType, childTransform))) {
            JSDecoratedTypeImpl jSDecoratedTypeImpl = this;
            if (jSDecoratedTypeImpl == null) {
                JSDecoratedTypeImpl.$$$reportNull$$$0(16);
            }
            return jSDecoratedTypeImpl;
        }
        JSDecoratedTypeImpl jSDecoratedTypeImpl = new JSDecoratedTypeImpl(this.getSource(), newType, this.getDecorations());
        if (jSDecoratedTypeImpl == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(17);
        }
        return jSDecoratedTypeImpl;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(18);
        }
        JSDecoratedTypeImpl jSDecoratedTypeImpl = new JSDecoratedTypeImpl(source, this.getType(), this.getDecorations());
        if (jSDecoratedTypeImpl == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(19);
        }
        return jSDecoratedTypeImpl;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType jSType = this.myType;
        if (jSType == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(20);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorations";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSDecoratedTypeImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSDecoratedTypeImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecorations";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum TypeDecoration {
        NULLABLE,
        NOTNULL;

    }
}

