/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBooleanLiteralTypeImpl
extends JSBooleanType
implements JSPrimitiveLiteralType<Boolean> {
    private final boolean myLiteral;
    private final boolean myCanBeWidened;

    public JSBooleanLiteralTypeImpl(boolean literal, boolean canBeWidened, @NotNull JSTypeSource source) {
        if (source == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(0);
        }
        super(true, source, JSTypeContext.INSTANCE);
        this.myLiteral = literal;
        this.myCanBeWidened = canBeWidened;
    }

    protected JSBooleanLiteralTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator serialized) {
        if (source == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(1);
        }
        if (serialized == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(2);
        }
        super(source, serialized);
        this.myLiteral = JSTypeSerializer.readBoolean(serialized);
        this.myCanBeWidened = JSTypeSerializer.readBoolean(serialized);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(3);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeBoolean(this.myLiteral, outputStream);
        JSTypeSerializer.writeBoolean(this.myCanBeWidened, outputStream);
    }

    @Override
    @NotNull
    public Boolean getLiteral() {
        Boolean bl = this.myLiteral;
        if (bl == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(4);
        }
        return bl;
    }

    @Override
    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.RESOLVED) {
            if ("Boolean" == null) {
                JSBooleanLiteralTypeImpl.$$$reportNull$$$0(5);
            }
            return "Boolean";
        }
        String stringVal = Boolean.toString(this.myLiteral).toLowerCase(Locale.getDefault());
        if (format == JSType.TypeTextFormat.PRESENTABLE || format == JSType.TypeTextFormat.CODE) {
            String string = this.isTypeScript() && (!this.canBeWidened() || format != JSType.TypeTextFormat.CODE) ? stringVal : "boolean";
            if (string == null) {
                JSBooleanLiteralTypeImpl.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = "Boolean(" + stringVal + ")";
        if (string == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(8);
        }
        if (elementType instanceof JSBooleanLiteralTypeImpl && this.getSource().isStrict() && !this.myCanBeWidened) {
            return this.myLiteral == ((JSBooleanLiteralTypeImpl)elementType).myLiteral;
        }
        if (!this.myCanBeWidened && elementType instanceof JSBooleanType) {
            return false;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(9);
        }
        return type instanceof JSBooleanLiteralTypeImpl && this.myLiteral == ((JSBooleanLiteralTypeImpl)type).myLiteral;
    }

    @Override
    @NotNull
    protected JSBooleanLiteralTypeImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(10);
        }
        JSBooleanLiteralTypeImpl jSBooleanLiteralTypeImpl = new JSBooleanLiteralTypeImpl((boolean)this.getLiteral(), this.myCanBeWidened, source);
        if (jSBooleanLiteralTypeImpl == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(11);
        }
        return jSBooleanLiteralTypeImpl;
    }

    @Override
    @NotNull
    public JSType asPrimitiveType() {
        JSType jSType = JSNamedType.createType("boolean", this.getSource(), this.getTypeContext());
        if (jSType == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(12);
        }
        return jSType;
    }

    @Override
    public boolean canBeWidened() {
        return this.myCanBeWidened;
    }

    @Override
    @NotNull
    public JSLiteralType copyWithCanBeWidened(boolean canBeWidened) {
        JSBooleanLiteralTypeImpl jSBooleanLiteralTypeImpl = new JSBooleanLiteralTypeImpl(this.myLiteral, canBeWidened, this.getSource());
        if (jSBooleanLiteralTypeImpl == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(13);
        }
        return jSBooleanLiteralTypeImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serialized";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSBooleanLiteralTypeImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSBooleanLiteralTypeImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteral";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "asPrimitiveType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithCanBeWidened";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

