/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.stubs.TypeScriptModuleStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubImpl;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubTreeUtil {
    @Nullable
    public static StubElement getNextSibling(StubElement<?> stub) {
        return StubTreeUtil.getNextSibling(stub, null);
    }

    @Nullable
    public static StubElement getNextSibling(StubElement<?> stub, @Nullable TokenSet filter) {
        StubElement parentStub = stub.getParentStub();
        List children = parentStub.getChildrenStubs();
        if (StubTreeUtil.areTooManyChildren(children)) {
            StubElement lastChild = StubTreeUtil.getLastChild(children);
            return stub == lastChild ? null : StubTreeUtil.iterateNextSiblingsByPlainList(stub, filter, parentStub, lastChild);
        }
        boolean stubFound = false;
        for (StubElement child : children) {
            if (stubFound && StubTreeUtil.isAcceptable(filter, child)) {
                return child;
            }
            if (stub != child) continue;
            stubFound = true;
        }
        return null;
    }

    private static StubElement getLastChild(List<StubElement> children) {
        return children.get(children.size() - 1);
    }

    @Nullable
    private static StubElement iterateNextSiblingsByPlainList(@NotNull StubElement<?> stub, @Nullable TokenSet filter, @NotNull StubElement<?> parentStub, @NotNull StubElement lastChild) {
        if (stub == null) {
            StubTreeUtil.$$$reportNull$$$0(0);
        }
        if (parentStub == null) {
            StubTreeUtil.$$$reportNull$$$0(1);
        }
        if (lastChild == null) {
            StubTreeUtil.$$$reportNull$$$0(2);
        }
        List<StubElement<?>> plainList = StubTreeUtil.getStubPlainList(parentStub);
        assert (stub == plainList.get(((ObjectStubBase)stub).id));
        while (stub != lastChild) {
            stub = StubTreeUtil.skipSubTree(stub, plainList);
            assert (stub.getParentStub() == parentStub);
            if (!StubTreeUtil.isAcceptable(filter, stub)) continue;
            return stub;
        }
        return null;
    }

    private static StubElement<?> skipSubTree(@NotNull StubElement<?> stub, List<StubElement<?>> plainList) {
        if (stub == null) {
            StubTreeUtil.$$$reportNull$$$0(3);
        }
        return plainList.get(((ObjectStubBase)StubTreeUtil.getLastLeaf(stub)).id + 1);
    }

    private static StubElement<?> getLastLeaf(StubElement<?> stub) {
        List children = stub.getChildrenStubs();
        return children.isEmpty() ? stub : StubTreeUtil.getLastLeaf(StubTreeUtil.getLastChild(children));
    }

    private static boolean areTooManyChildren(List<StubElement> children) {
        return children.size() > 10;
    }

    @NotNull
    private static List<StubElement<?>> getStubPlainList(StubElement<?> stub) {
        StubTree tree = (StubTree)ObjectStubTree.getStubTree((ObjectStubBase)((StubBase)StubTreeUtil.walkUp(null, stub)));
        assert (tree != null);
        List list = tree.getPlainList();
        if (list == null) {
            StubTreeUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static boolean isAcceptable(@Nullable TokenSet filter, @NotNull StubElement child) {
        if (child == null) {
            StubTreeUtil.$$$reportNull$$$0(5);
        }
        return filter == null || filter.contains((IElementType)child.getStubType());
    }

    @Nullable
    public static StubElement getPrevSibling(StubElement<?> stub) {
        StubElement parentStub = stub.getParentStub();
        List children = parentStub.getChildrenStubs();
        if (StubTreeUtil.areTooManyChildren(children)) {
            return children.get(0) == stub ? null : StubTreeUtil.findPrevSiblingByPlainList(stub, parentStub);
        }
        StubElement prevSibling = null;
        for (StubElement child : children) {
            if (stub == child) {
                return prevSibling;
            }
            prevSibling = child;
        }
        return null;
    }

    @NotNull
    private static StubElement findPrevSiblingByPlainList(StubElement<?> stub, StubElement<?> parentStub) {
        List<StubElement<?>> plainList = StubTreeUtil.getStubPlainList(parentStub);
        int index = ((ObjectStubBase)stub).id;
        assert (stub == plainList.get(index));
        assert (index > ((ObjectStubBase)parentStub).id + 1);
        StubElement stubElement = StubTreeUtil.walkUp(parentStub, plainList.get(index - 1));
        if (stubElement == null) {
            StubTreeUtil.$$$reportNull$$$0(6);
        }
        return stubElement;
    }

    @NotNull
    private static StubElement walkUp(@Nullable StubElement<?> expectedParent, @NotNull StubElement start) {
        if (start == null) {
            StubTreeUtil.$$$reportNull$$$0(7);
        }
        StubElement candidate = start;
        while (true) {
            StubElement candidateParent;
            if ((candidateParent = candidate.getParentStub()) == expectedParent) {
                StubElement stubElement = candidate;
                if (stubElement == null) {
                    StubTreeUtil.$$$reportNull$$$0(8);
                }
                return stubElement;
            }
            candidate = candidateParent;
        }
    }

    @Nullable
    public static Language getJSLanguage(@NotNull StubElement<?> stub) {
        if (stub == null) {
            StubTreeUtil.$$$reportNull$$$0(9);
        }
        for (StubElement parent = stub; parent != null; parent = parent.getParentStub()) {
            stub = parent;
        }
        return stub instanceof JSFileStubImpl ? ((JSFileStubImpl)stub).getLanguage() : null;
    }

    @Nullable
    public static StubElement findChildStubByType(@NotNull StubElement<?> parent, @NotNull TokenSet types) {
        if (parent == null) {
            StubTreeUtil.$$$reportNull$$$0(10);
        }
        if (types == null) {
            StubTreeUtil.$$$reportNull$$$0(11);
        }
        List children = parent.getChildrenStubs();
        for (StubElement child : children) {
            if (!types.contains((IElementType)child.getStubType())) continue;
            return child;
        }
        return null;
    }

    public static boolean isFromGlobalNamespace(StubElement startElement) {
        for (StubElement parentStub = startElement.getParentStub(); parentStub != null; parentStub = parentStub.getParentStub()) {
            StubElement possibleFileElement;
            if (parentStub instanceof PsiFileStub) {
                if (parentStub instanceof JSFileStubImpl) {
                    JSFileStubImpl fileStub = (JSFileStubImpl)parentStub;
                    JSFileCachedData data = fileStub.getCachedData();
                    return data == null || data.getModuleStatus() != JSFile.ModuleStatus.ES6;
                }
                return true;
            }
            if (!(parentStub instanceof TypeScriptModuleStub) || !((possibleFileElement = parentStub.getParentStub()) instanceof JSFileStubImpl)) continue;
            String name = ((TypeScriptModuleStub)parentStub).getName();
            return TypeScriptUtil.convertToExternalModuleText(name) == null;
        }
        return true;
    }

    public static boolean checkParentStubShouldCreate(@NotNull ASTNode node) {
        ASTNode owner;
        if (node == null) {
            StubTreeUtil.$$$reportNull$$$0(12);
        }
        if ((owner = node.getTreeParent()) != null) {
            IElementType ownerType = owner.getElementType();
            if (ownerType instanceof IStubElementType) {
                return ((IStubElementType)ownerType).shouldCreateStub(owner);
            }
            if (ownerType instanceof JSFileElementType) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastChild";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubPlainList";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findPrevSiblingByPlainList";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "walkUp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "iterateNextSiblingsByPlainList";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "skipSubTree";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "walkUp";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getJSLanguage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findChildStubByType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkParentStubShouldCreate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

