/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSIconProvider;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSIndexableImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementStructureImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitParameterStructure;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ComparatorUtil;
import java.util.EnumSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImplicitElementImpl
extends FakePsiElement
implements JSIndexableImplicitElement {
    @NotNull
    protected final JSImplicitElementStructureImpl myStructure;
    @Nullable
    protected final PsiElement myProvider;

    public JSImplicitElementImpl(@NotNull String name, @Nullable PsiElement provider2) {
        if (name == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(0);
        }
        this(new Builder(name, provider2));
    }

    public JSImplicitElementImpl(@NotNull String name, @Nullable JSQualifiedName namespace, @Nullable PsiElement provider2) {
        if (name == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(1);
        }
        this(new Builder(name, provider2).setNamespace(namespace));
    }

    public JSImplicitElementImpl(@NotNull Builder builder) {
        if (builder == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(2);
        }
        this.myStructure = this.createStructure(builder);
        this.myProvider = builder.myProvider;
        assert (this.getType() == JSImplicitElement.Type.Function == this instanceof JSImplicitFunctionImpl);
    }

    public JSImplicitElementImpl(@NotNull JSImplicitElementStructureImpl structure, @Nullable PsiElement provider2) {
        if (structure == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(3);
        }
        this.myStructure = structure;
        this.myProvider = provider2;
    }

    protected JSImplicitElementStructureImpl createStructure(Builder builder) {
        return new JSImplicitElementStructureImpl(builder);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(4);
        }
        if (state == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(5);
        }
        if (place == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(6);
        }
        return processor.execute((PsiElement)this, state);
    }

    @NotNull
    public String getName() {
        String string = this.myStructure.getName();
        if (string == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        return this.myStructure.getNamespace();
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.myStructure.getQualifiedName();
        if (string == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return this.myStructure.isNamespaceExplicitlyDeclared();
    }

    @Nullable
    public String getUserString() {
        return this.myStructure.getUserString();
    }

    @NotNull
    public static JSImplicitElement fromQualifiedName(String qName, @Nullable PsiElement provider2) {
        JSQualifiedNameImpl qualifiedName = JSQualifiedNameImpl.fromQualifiedName(qName);
        JSImplicitElementImpl jSImplicitElementImpl = new JSImplicitElementImpl(qualifiedName.getName(), qualifiedName.getParent(), provider2);
        if (jSImplicitElementImpl == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(9);
        }
        return jSImplicitElementImpl;
    }

    @NotNull
    public JSImplicitElement.Type getType() {
        JSImplicitElement.Type type = this.myStructure.getType();
        if (type == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(10);
        }
        return type;
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = this.myStructure.getJSContext();
        if (jSContext == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(11);
        }
        return jSContext;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList.AccessType accessType = this.myStructure.getAccessType();
        if (accessType == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(12);
        }
        return accessType;
    }

    public boolean hasMinorImportance() {
        return this.myStructure.hasMinorImportance();
    }

    public boolean isDeprecated() {
        return this.myStructure.isDeprecated();
    }

    @Nullable
    public String getTypeString() {
        return this.myStructure.getTypeString();
    }

    public PsiElement getParent() {
        return this.myProvider;
    }

    @NotNull
    public Language getLanguage() {
        JSLanguageDialect dialect;
        if (this.myProvider != null && (dialect = DialectDetector.languageDialectOfElement(this.myProvider)) != null) {
            JSLanguageDialect jSLanguageDialect = dialect;
            if (jSLanguageDialect == null) {
                JSImplicitElementImpl.$$$reportNull$$$0(13);
            }
            return jSLanguageDialect;
        }
        JavascriptLanguage javascriptLanguage = JavascriptLanguage.INSTANCE;
        if (javascriptLanguage == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(14);
        }
        return javascriptLanguage;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        JSImplicitElementImpl jSImplicitElementImpl = this.myProvider != null ? this.myProvider : this;
        if (jSImplicitElementImpl == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(15);
        }
        return jSImplicitElementImpl;
    }

    public boolean isConst() {
        return this.myStructure.isConst();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(16);
        }
        if (this.myProvider instanceof JSLiteralExpression) {
            String qName = this.getQualifiedName();
            int qNameStart = this.myProvider.getText().indexOf(qName);
            if (qNameStart >= 0) {
                String oldName = this.getName();
                TextRange range = TextRange.from((int)(qNameStart + qName.length() - oldName.length()), (int)oldName.length());
                ElementManipulators.getManipulator((PsiElement)this.myProvider).handleContentChange(this.myProvider, range, name);
            } else {
                ElementManipulators.getManipulator((PsiElement)this.myProvider).handleContentChange(this.myProvider, name);
            }
        }
        for (PsiElement parent = this.myProvider; parent != null && !(parent instanceof JSFile); parent = parent.getParent()) {
            if (!(parent instanceof PsiNamedElement) || !StringUtil.equals((CharSequence)this.getName(), (CharSequence)((PsiNamedElement)parent).getName())) continue;
            ((PsiNamedElement)parent).setName(name);
            break;
        }
        return this.toBuilder().setName(name).toImplicitElement();
    }

    @NotNull
    public Builder toBuilder() {
        Builder builder = new Builder(this.getName(), this.myProvider);
        this.fillBuilder(builder);
        Builder builder2 = builder;
        if (builder2 == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(17);
        }
        return builder2;
    }

    protected void fillBuilder(@NotNull Builder builder) {
        if (builder == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(18);
        }
        this.myStructure.fillBuilder(builder);
        builder.setProvider(this.myProvider);
    }

    @Nullable
    public Icon getIcon(boolean open) {
        JSImplicitElement.Type type = this.getType();
        return JSImplicitElementImpl.getIconForType(type, (PsiElement)this);
    }

    public static Icon getIconForType(@NotNull JSImplicitElement.Type type, @NotNull PsiElement element) {
        if (type == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(19);
        }
        if (element == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(20);
        }
        switch (type) {
            case Variable: {
                return PlatformIcons.VARIABLE_ICON;
            }
            case Function: {
                return JSStubElementImpl.blendFlags(PlatformIcons.METHOD_ICON, true, false);
            }
            case Property: {
                return PlatformIcons.PROPERTY_ICON;
            }
            case Namespace: 
            case Class: 
            case Interface: {
                JSIconProvider iconProvider = JSIconProvider.getForLanguage((PsiElement)element.getContainingFile());
                return type == JSImplicitElement.Type.Interface ? iconProvider.getInterfaceIcon() : iconProvider.getClassIcon();
            }
            case Tag: {
                return JSIconProvider.HTML_TAG_ICON;
            }
        }
        throw new IllegalArgumentException("Unexpected type " + type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JSImplicitElementImpl element = (JSImplicitElementImpl)((Object)o);
        if (!this.myStructure.equals(element.myStructure)) {
            return false;
        }
        return !(this.myProvider != null ? !this.myProvider.equals(element.myProvider) : element.myProvider != null);
    }

    public int hashCode() {
        int result2 = this.myStructure.hashCode();
        result2 = 31 * result2 + (this.myProvider != null ? this.myProvider.hashCode() : 0);
        return result2;
    }

    public ItemPresentation getPresentation() {
        return new JSItemPresentation((JSPsiElementBase)this);
    }

    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        JSElementBase.ClassOrInterface classOrInterface = this.myStructure.isClassOrInterface();
        if (classOrInterface == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(21);
        }
        return classOrInterface;
    }

    @NotNull
    public JSNamespace getJSNamespace() {
        JSNamespace jSNamespace = JSNamedTypeFactory.buildJSNamespace((JSElementBase)this);
        if (jSNamespace == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(22);
        }
        return jSNamespace;
    }

    public boolean hasJSDoc() {
        return this.myStructure.hasJSDoc();
    }

    @NotNull
    public JSImplicitElementStructureImpl getStructure() {
        JSImplicitElementStructureImpl jSImplicitElementStructureImpl = this.myStructure;
        if (jSImplicitElementStructureImpl == null) {
            JSImplicitElementImpl.$$$reportNull$$$0(23);
        }
        return jSImplicitElementStructureImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "fromQualifiedName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "toBuilder";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "isClassOrInterface";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSNamespace";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fillBuilder";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getIconForType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        @NotNull
        protected String myName;
        @Nullable
        protected JSQualifiedName myNamespace;
        protected int myFlags;
        @Nullable
        protected String myTypeString;
        @Nullable
        protected PsiElement myProvider;
        @Nullable
        protected String myUserString;
        @Nullable
        List<JSImplicitParameterStructure> myParameters;
        protected int myOffset;
        protected PsiFile myFile;
        protected boolean myAllowAstAccess;

        public Builder(@NotNull JSQualifiedName qualifiedName, @Nullable PsiElement provider2) {
            if (qualifiedName == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this(qualifiedName.getName(), provider2);
            this.setNamespace(qualifiedName.getParent());
        }

        public Builder(@NotNull String name, @Nullable PsiElement provider2) {
            if (name == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myAllowAstAccess = true;
            this.myName = name;
            this.myProvider = provider2;
            this.setNamespaceExplicitlyDeclared(true);
            this.setType(JSImplicitElement.Type.Property);
            this.setAccessType(JSAttributeList.AccessType.PACKAGE_LOCAL);
            this.setContext(JSContext.UNKNOWN);
        }

        public Builder setName(@NotNull String name) {
            if (name == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myName = name;
            return this;
        }

        public Builder setNamespace(@Nullable JSQualifiedName namespace) {
            this.myNamespace = namespace;
            return this;
        }

        public Builder setNamespaceExplicitlyDeclared(boolean namespaceExplicitlyDeclared) {
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.NAMESPACE_EXPLICITLY_DECLARED_FLAG, namespaceExplicitlyDeclared);
            return this;
        }

        public Builder setProperties(JSImplicitElement.Property ... properties) {
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.PROPERTIES_FLAG, EnumSet.of(properties[0], properties));
            return this;
        }

        public Builder setProperties(@Nullable EnumSet<JSImplicitElement.Property> properties) {
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.PROPERTIES_FLAG, properties);
            return this;
        }

        public Builder setType(JSImplicitElement.Type type) {
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.TYPE_FLAG, type);
            return this;
        }

        public Builder setContext(JSContext context) {
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.JS_CONTEXT_FLAG, context);
            return this;
        }

        public Builder setAccessType(JSAttributeList.AccessType accessType) {
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.ACCESS_TYPE_FLAG, accessType);
            return this;
        }

        public Builder setTypeString(@Nullable String typeString) {
            this.myTypeString = typeString;
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.HAS_TYPE_STRING_FLAG, typeString != null);
            return this;
        }

        public Builder forbidAstAccess() {
            this.myAllowAstAccess = false;
            return this;
        }

        @Nullable
        public PsiElement getProvider() {
            return this.myProvider;
        }

        public Builder setProvider(@Nullable PsiElement provider2) {
            this.myProvider = provider2;
            return this;
        }

        public Builder setUserString(@Nullable String userString) {
            JSImplicitElement.ourUserStringsRegistry.checkRegistered(userString);
            return this.setPossiblyUnregisteredUserString(userString);
        }

        public Builder setPossiblyUnregisteredUserString(@Nullable String userString) {
            this.myUserString = userString;
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.HAS_USER_STRING_FLAG, userString != null);
            return this;
        }

        public Builder setFlags(int flags) {
            this.myFlags = flags;
            return this;
        }

        public Builder setParameters(@Nullable List<JSImplicitParameterStructure> parameters) {
            this.myParameters = parameters;
            return this;
        }

        public Builder setOffset(int offset) {
            this.myOffset = offset;
            return this;
        }

        public Builder setFile(PsiFile file2) {
            this.myFile = file2;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder builder = (Builder)o;
            return this.myFlags == builder.myFlags && this.myName.equals(builder.myName) && ComparatorUtil.equalsNullable((Object)this.myNamespace, (Object)builder.myNamespace) && ComparatorUtil.equalsNullable((Object)this.myTypeString, (Object)builder.myTypeString) && ComparatorUtil.equalsNullable((Object)this.myProvider, (Object)builder.myProvider) && ComparatorUtil.equalsNullable((Object)this.myUserString, (Object)builder.myUserString) && ComparatorUtil.equalsNullable(this.myParameters, builder.myParameters);
        }

        public int hashCode() {
            int result2 = this.myName.hashCode();
            result2 = 31 * result2 + (this.myNamespace != null ? this.myNamespace.hashCode() : 0);
            result2 = 31 * result2 + this.myFlags;
            result2 = 31 * result2 + (this.myTypeString != null ? this.myTypeString.hashCode() : 0);
            result2 = 31 * result2 + (this.myProvider != null ? this.myProvider.hashCode() : 0);
            result2 = 31 * result2 + (this.myUserString != null ? this.myUserString.hashCode() : 0);
            return result2;
        }

        @NotNull
        public JSImplicitElementImpl toImplicitElement() {
            if (this.myFile != null) {
                JSOffsetBasedImplicitElement jSOffsetBasedImplicitElement = new JSOffsetBasedImplicitElement(this, this.myOffset, this.myFile);
                if (jSOffsetBasedImplicitElement == null) {
                    Builder.$$$reportNull$$$0(3);
                }
                return jSOffsetBasedImplicitElement;
            }
            if (JSImplicitElementStructureImpl.readFlag(JSImplicitElementStructureImpl.TYPE_FLAG, this.myFlags) == JSImplicitElement.Type.Function) {
                JSImplicitFunctionImpl jSImplicitFunctionImpl = new JSImplicitFunctionImpl(this);
                if (jSImplicitFunctionImpl == null) {
                    Builder.$$$reportNull$$$0(4);
                }
                return jSImplicitFunctionImpl;
            }
            JSImplicitElementImpl jSImplicitElementImpl = new JSImplicitElementImpl(this);
            if (jSImplicitElementImpl == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return jSImplicitElementImpl;
        }

        @NotNull
        public Builder copy() {
            Builder copy = new Builder(this.myName, this.myProvider);
            this.copyFieldsTo(copy);
            Builder builder = copy;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        protected void copyFieldsTo(@NotNull Builder builder) {
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            builder.myNamespace = this.myNamespace;
            builder.myFlags = this.myFlags;
            builder.myTypeString = this.myTypeString;
            builder.myUserString = this.myUserString;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl$Builder";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl$Builder";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toImplicitElement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "copyFieldsTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

