/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.impl.JSDestructuringArrayImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubBase;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JSDestructuringArrayStubImpl
extends JSStubBase<JSDestructuringArray> {
    private static final BooleanStructureElement HAS_EMPTY_POSITIONS = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(HAS_EMPTY_POSITIONS);
    private volatile int mySize = -1;
    private volatile int[] myEmptyPositions;

    public int[] getEmptyPositions() {
        return this.myEmptyPositions;
    }

    public JSDestructuringArrayStubImpl(JSDestructuringArray psi, StubElement parent) {
        super(psi, parent, (IStubElementType)JSStubElementTypes.DESTRUCTURING_ARRAY);
        JSInitializerOwner[] elements = psi.getElements();
        ArrayList empty = ContainerUtil.newArrayList();
        for (int i = 0; i < elements.length; ++i) {
            JSInitializerOwner element = elements[i];
            if (element != null) continue;
            empty.add(i);
        }
        if (empty.size() == 0) {
            this.writeFlag(HAS_EMPTY_POSITIONS, false);
        } else {
            this.writeFlag(HAS_EMPTY_POSITIONS, true);
            this.mySize = elements.length;
            this.myEmptyPositions = empty.stream().mapToInt(el -> el).toArray();
        }
    }

    public JSDestructuringArrayStubImpl(StubInputStream dataStream, StubElement parentStub) throws IOException {
        super(dataStream, parentStub, (IStubElementType)JSStubElementTypes.DESTRUCTURING_ARRAY);
        Boolean hasEmptyPositions = this.readFlag(HAS_EMPTY_POSITIONS);
        if (hasEmptyPositions.booleanValue()) {
            this.mySize = dataStream.readVarInt();
            int arraySize = dataStream.readVarInt();
            this.myEmptyPositions = new int[arraySize];
            for (int i = 0; i < this.myEmptyPositions.length; ++i) {
                this.myEmptyPositions[i] = dataStream.readVarInt();
            }
        }
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        if (this.hasEmptyPositions()) {
            dataStream.writeVarInt(this.mySize);
            dataStream.writeVarInt(this.myEmptyPositions.length);
            for (int position : this.myEmptyPositions) {
                dataStream.writeVarInt(position);
            }
        }
    }

    public JSDestructuringArray createPsi() {
        return new JSDestructuringArrayImpl(this);
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            JSDestructuringArrayStubImpl.$$$reportNull$$$0(0);
        }
        return flagsStructure;
    }

    public void index(IndexSink sink) {
    }

    public boolean hasEmptyPositions() {
        return this.readFlag(HAS_EMPTY_POSITIONS);
    }

    public int getSize() {
        return this.mySize;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSDestructuringArrayStubImpl", "getFlagsStructure"));
    }
}

