/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSVariantRecordTypeConverter {
    @Nullable
    public static JSRecordType getTypeAsRecord(@Nullable JSType type, @Nullable PsiElement context) {
        if (type == null) {
            return null;
        }
        if (type instanceof JSRecordType) {
            return (JSRecordType)type;
        }
        if (type.getSource().isEcma()) {
            return null;
        }
        if ((type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type)) instanceof JSCompositeTypeImpl) {
            List<JSType> types = ((JSCompositeTypeImpl)type).getTypes();
            ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
            for (JSType jsType : types) {
                JSRecordType record = JSVariantRecordTypeConverter.getTypeAsRecord(jsType, context);
                if (record == null) continue;
                typeMembers.addAll(record.getTypeMembers());
            }
            if (!typeMembers.isEmpty()) {
                return new JSRecordTypeImpl(type.getSource(), typeMembers);
            }
        }
        if (context != null && (DialectDetector.isTypeScript(context) || type.isTypeScript())) {
            return type.asRecordType();
        }
        Collection<TypeScriptInterface> classTypes = JSTypeUtils.getTypeScriptInterfaceInJavaScriptContext(type);
        return JSVariantRecordTypeConverter.buildSimpleRecordType(type, classTypes);
    }

    @Nullable
    public static JSRecordType buildSimpleRecordType(@NotNull JSType type, Collection<TypeScriptInterface> types) {
        if (type == null) {
            JSVariantRecordTypeConverter.$$$reportNull$$$0(0);
        }
        if (types.isEmpty()) {
            return null;
        }
        ArrayList recordMembers = ContainerUtil.newArrayList();
        for (JSClass jSClass : types) {
            Collection<JSClass<?>> parents = TypeScriptUtil.getNonStrictParents(jSClass, true);
            for (JSClass<?> jsClass : parents) {
                Iterable members = jsClass.getMembers();
                for (JSElement member : members) {
                    String name;
                    if (!(member instanceof JSFunction) && !(member instanceof JSProperty) && !(member instanceof TypeScriptPropertySignature) || (name = member.getName()) == null) continue;
                    recordMembers.add(new JSRecordTypeImpl.PropertySignatureImpl(member.getName(), null, false));
                }
            }
        }
        return new JSRecordTypeImpl(type.getSource(), recordMembers);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSVariantRecordTypeConverter", "buildSimpleRecordType"));
    }
}

