/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSIndexBasedResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.statistics.JSResolveStatisticsCollector;
import com.intellij.lang.typescript.TypeScriptResolveHelper;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Processor;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceExpressionResolver
implements ResolveCache.PolyVariantResolver<JSReferenceExpressionImpl> {
    private static final Key<CachedValue<Map<String, ResolveResult[]>>> cachedTopResolveKey = Key.create((String)"top.level.cached.results");
    private static final int MAX_RESULTS_COUNT_TO_KEEP = Integer.valueOf(System.getProperty("js.max.results.count.to.keep", "20"));
    protected final JSReferenceExpressionImpl myRef;
    protected final PsiElement myParent;
    protected final PsiFile myContainingFile;
    @Nullable
    protected final String myReferencedName;
    protected final JSExpression myQualifier;
    protected final boolean myUnqualifiedOrLocalResolve;
    private final boolean myIgnorePerformanceLimits;

    public JSReferenceExpressionResolver(@NotNull JSReferenceExpressionImpl expression, boolean ignorePerformanceLimits) {
        if (expression == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(0);
        }
        this.myRef = expression;
        this.myContainingFile = expression.getContainingFile();
        this.myReferencedName = this.adjustReferencedName(this.myRef);
        this.myParent = this.myRef.getParent();
        this.myQualifier = this.myRef.getResolveQualifier();
        this.myUnqualifiedOrLocalResolve = JSReferenceExpressionImpl.isLocalResolveQualifier(this.myQualifier);
        this.myIgnorePerformanceLimits = ignorePerformanceLimits;
    }

    @NotNull
    public ResolveResult[] resolve(@NotNull JSReferenceExpressionImpl expression, boolean incompleteCode) {
        ResolveResult[] results;
        SinkResolveProcessor<ResolveResultSink> localProcessor;
        if (expression == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(1);
        }
        if (this.myReferencedName == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(2);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        boolean localResultFound = false;
        PsiElement currentParent = JSResolveUtil.getTopReferenceParent(this.myParent);
        if (JSResolveUtil.isSelfReference(currentParent, (PsiElement)this.myRef)) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult(currentParent)};
            if (resolveResultArray == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }
        ResolveResult[] resultsFromProviders = this.resolveFromProviders();
        if (resultsFromProviders != null) {
            if (resultsFromProviders == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(4);
            }
            return resultsFromProviders;
        }
        ResolveResultSink sink = new ResolveResultSink((PsiElement)this.myRef, this.myReferencedName);
        if (this.myUnqualifiedOrLocalResolve) {
            localProcessor = this.createLocalResolveProcessor(sink);
            localProcessor.setToProcessHierarchy(true);
            JSReferenceExpressionImpl.doProcessLocalDeclarations((PsiElement)this.myRef, this.myQualifier, localProcessor, false, false, null);
            PsiElement jsElement = localProcessor.getResult();
            if (!(jsElement == null || jsElement instanceof JSImplicitElement && ((JSImplicitElement)jsElement).hasMinorImportance())) {
                ResolveResult[] results2 = localProcessor.getResultsAsResolveResults();
                if (TypeScriptPsiUtil.isPlaceRuntimeOnly((PsiElement)this.myRef, true)) {
                    results2 = TypeScriptPsiUtil.removeCompileTimeTypes(results2);
                }
                JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.LOCAL, (Object)results2.length);
                if (results2 == null) {
                    JSReferenceExpressionResolver.$$$reportNull$$$0(5);
                }
                return results2;
            }
            if (this.myQualifier == null) {
                ResolveResultSink globalSink = incompleteCode ? sink : new ResolveResultSink((PsiElement)this.myRef, this.myReferencedName);
                QualifiedItemProcessor<ResolveResultSink> processor = this.createQualifiedItemProcessor(globalSink);
                processor.setTypeContext(true);
                TypeScriptResolveHelper.processGlobalThings(processor, ResolveState.initial(), (PsiElement)this.myRef);
                if (!incompleteCode) {
                    this.addResolveResultToSink(sink, processor);
                }
                jsElement = jsElement == null ? processor.getResult() : jsElement;
            }
            localResultFound = jsElement != null;
        } else {
            QualifiedItemProcessor<ResolveResultSink> processor = this.createQualifiedItemProcessor(sink);
            processor.setTypeContext(true);
            JSTypeEvaluator.evaluateTypes(this.myQualifier, this.myContainingFile, processor, JSEvaluateContext.JSEvaluationPlace.REFERENCE_EXPRESSION);
            ResolveResultSink resultSink = (ResolveResultSink)processor.getResultSink();
            if (processor.resolved == QualifiedItemProcessor.TypeResolveState.Resolved || processor.resolved == QualifiedItemProcessor.TypeResolveState.Undefined || resultSink.getCompleteResult() != null) {
                ResolveResult[] results3 = processor.getResultsAsResolveResults();
                JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.QUALIFIED, (Object)results3.length);
                if (results3 == null) {
                    JSReferenceExpressionResolver.$$$reportNull$$$0(6);
                }
                return results3;
            }
            localProcessor = processor;
        }
        Map<String, ResolveResult[]> cachedResultsMap = null;
        if (!(this.myQualifier != null || localResultFound || this.myParent instanceof JSDefinitionExpression && !JSResolveUtil.isEcmaScript5((PsiElement)this.myRef) || (results = (cachedResultsMap = JSReferenceExpressionResolver.getCachedTopLevelResultsMap(this.myContainingFile)).get(this.myReferencedName)) == null)) {
            if (results == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(7);
            }
            return results;
        }
        results = TypeScriptPsiUtil.removeDuplicates(this.resolveFromIndices(localProcessor, this.myQualifier == null, false), (PsiElement)this.myRef);
        if (this.undefinedResolve(results)) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult((PsiElement)this.myRef)};
            if (resolveResultArray == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(8);
            }
            return resolveResultArray;
        }
        if (results.length == 0 && localProcessor.isEncounteredXmlLiteral()) {
            ResolveResult[] resolveResultArray = this.dummyResult(this.myRef);
            if (resolveResultArray == null) {
                JSReferenceExpressionResolver.$$$reportNull$$$0(9);
            }
            return resolveResultArray;
        }
        if (cachedResultsMap != null) {
            cachedResultsMap.put(this.myReferencedName, results);
        }
        if (results == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(10);
        }
        return results;
    }

    public void addResolveResultToSink(@NotNull ResolveResultSink sink, @NotNull QualifiedItemProcessor<ResolveResultSink> processor) {
        ResolveResult[] results;
        if (sink == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(12);
        }
        for (ResolveResult result2 : results = processor.getResultsAsResolveResults()) {
            sink.addResult(result2.getElement(), ResolveState.initial(), processor);
        }
    }

    @Nullable
    protected ResolveResult[] resolveFromProviders() {
        for (PsiReference reference : ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this.myRef)) {
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
                if (results.length <= 0) continue;
                return results;
            }
            PsiElement resolve = reference.resolve();
            if (resolve == null) continue;
            return new ResolveResult[]{new JSResolveResult(resolve)};
        }
        return null;
    }

    @NotNull
    protected SinkResolveProcessor<ResolveResultSink> createLocalResolveProcessor(@NotNull ResolveResultSink sink) {
        if (sink == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(13);
        }
        SinkResolveProcessor<ResolveResultSink> sinkResolveProcessor = new SinkResolveProcessor<ResolveResultSink>(this.myReferencedName, (PsiElement)this.myRef, sink);
        if (sinkResolveProcessor == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(14);
        }
        return sinkResolveProcessor;
    }

    @NotNull
    protected QualifiedItemProcessor<ResolveResultSink> createQualifiedItemProcessor(@NotNull ResolveResultSink sink) {
        if (sink == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(15);
        }
        QualifiedItemProcessor<ResolveResultSink> qualifiedItemProcessor = JSDialectSpecificHandlersFactory.forElement((PsiElement)this.myRef).createQualifiedItemProcessor(sink, (PsiElement)this.myRef);
        if (qualifiedItemProcessor == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(16);
        }
        return qualifiedItemProcessor;
    }

    protected ResolveResult[] resolveFromIndices(@NotNull SinkResolveProcessor<ResolveResultSink> localProcessor) {
        if (localProcessor == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(17);
        }
        return this.resolveFromIndices(localProcessor, false, true);
    }

    protected ResolveResult[] resolveFromIndices(@NotNull SinkResolveProcessor<ResolveResultSink> localProcessor, boolean excludeJsLibs, boolean includeTypeOnlyContextSymbols) {
        if (localProcessor == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(18);
        }
        assert (this.myReferencedName != null);
        WalkUpResolveProcessor processor = new WalkUpResolveProcessor(this.myReferencedName, this.myContainingFile, (PsiElement)this.myRef);
        this.prepareProcessor(processor, localProcessor);
        JSResolveUtil.tryProcessXmlFileImplicitElements((PsiElement)this.myRef, processor);
        JSResolveUtil.tryProcessAllElementsInInjectedContext(this.myContainingFile, (Processor<JSPsiElementBase>)((Processor)element -> {
            if (this.myReferencedName.equals(element.getName())) {
                processor.doQualifiedCheck((JSPsiElementBase)element);
            }
            return true;
        }));
        JSIndexBasedResolveUtil.processAllSymbols(processor, this.myIgnorePerformanceLimits, excludeJsLibs &= processor.myTypeInfo.isGlobalStatusHint(), includeTypeOnlyContextSymbols);
        ResolveResult[] results = this.getResultsFromProcessor(processor);
        JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.SYMBOL, (Object)results.length);
        if (results.length == 0 && (this.myParent instanceof JSDefinitionExpression || JSDestructuringUtil.parentIsDestructuringAssignmentLHS(this.myRef))) {
            return this.getResultsForDefinition();
        }
        return this.myIgnorePerformanceLimits || results.length <= MAX_RESULTS_COUNT_TO_KEEP ? results : JSResolveResult.TOO_MANY_CANDIDATES;
    }

    protected ResolveResult[] getResultsFromProcessor(WalkUpResolveProcessor processor) {
        return processor.getResults();
    }

    public boolean undefinedResolve(ResolveResult[] resolveResults) {
        return (resolveResults == null || resolveResults.length == 0) && "undefined".equals(this.myReferencedName) && this.myQualifier == null;
    }

    @Nullable
    protected String adjustReferencedName(@NotNull JSReferenceExpression ref) {
        if (ref == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(19);
        }
        return ref.getReferenceName();
    }

    protected void prepareProcessor(WalkUpResolveProcessor processor, @NotNull SinkResolveProcessor<ResolveResultSink> localProcessor) {
        if (localProcessor == null) {
            JSReferenceExpressionResolver.$$$reportNull$$$0(20);
        }
        boolean searchForDefinitionDefinition = false;
        boolean inDefinition = false;
        if (this.myParent instanceof JSDefinitionExpression) {
            JSExpression qualifier;
            inDefinition = true;
            if (processor.myContext instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)processor.myContext).getQualifier()) != null && !(qualifier instanceof JSThisExpression)) {
                JSType _qualifierType = JSResolveUtil.getExpressionJSType(qualifier);
                searchForDefinitionDefinition = !JSTypeUtils.isNewPropertiesDefinitionAllowed(_qualifierType) || _qualifierType instanceof JSNamedType && ((JSNamedType)_qualifierType).isStaticOrInstance() == JSContext.INSTANCE;
            }
        }
        processor.setAddOnlyCompleteMatches(inDefinition);
        processor.setSkipDefinitions(inDefinition && !searchForDefinitionDefinition);
        processor.addLocalResults(localProcessor);
    }

    protected ResolveResult[] getResultsForDefinition() {
        if (this.myQualifier == null && JSResolveUtil.isEcmaScript5((PsiElement)this.myRef)) {
            return ResolveResult.EMPTY_ARRAY;
        }
        return new ResolveResult[]{new JSResolveResult(this.myParent)};
    }

    protected ResolveResult[] dummyResult(JSReferenceExpression expression) {
        return new ResolveResult[]{new JSResolveResult((PsiElement)expression)};
    }

    private static Map<String, ResolveResult[]> getCachedTopLevelResultsMap(PsiFile containingFile) {
        CachedValue cachedResultsMapCachedValue = (CachedValue)containingFile.getUserData(cachedTopResolveKey);
        if (cachedResultsMapCachedValue == null) {
            cachedResultsMapCachedValue = CachedValuesManager.getManager((Project)containingFile.getProject()).createCachedValue(() -> new CachedValueProvider.Result(Collections.synchronizedMap(new THashMap()), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
            containingFile.putUserData(cachedTopResolveKey, (Object)cachedResultsMapCachedValue);
        }
        Map cachedResultsMap = (Map)cachedResultsMapCachedValue.getValue();
        return cachedResultsMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localProcessor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocalResolveProcessor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createQualifiedItemProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addResolveResultToSink";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createLocalResolveProcessor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createQualifiedItemProcessor";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveFromIndices";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "adjustReferencedName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "prepareProcessor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

