/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSModuleElementsProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptModuleDeclarationsProcessor;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.processors.JSModuleElementsResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSQualifiedNameResolver {
    @NotNull
    protected final PsiElement myContext;

    public JSQualifiedNameResolver(@NotNull PsiElement context) {
        if (context == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(0);
        }
        this.myContext = context;
    }

    @NotNull
    protected abstract JSQualifiedNameResolver createNestedResolver(@NotNull PsiElement var1);

    @NotNull
    public final Collection<PsiElement> resolveQualifiedName(@NotNull String qName) {
        JSQualifiedNameImpl name;
        List<String> components;
        if (qName == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(1);
        }
        if ((components = (name = JSQualifiedNameImpl.fromQualifiedName(qName)).toComponents()).isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(2);
            }
            return list;
        }
        String topLevelName = (String)ContainerUtil.getFirstItem(components);
        if (topLevelName == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(3);
            }
            return list;
        }
        boolean isUnqualifiedName = components.size() == 1;
        Set<PsiElement> topLevelElements = this.resolveTopLevelElements(topLevelName, !isUnqualifiedName);
        if (isUnqualifiedName) {
            Set<PsiElement> set = topLevelElements;
            if (set == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(4);
            }
            return set;
        }
        Set<PsiElement> lastElements = topLevelElements;
        List<String> localReferences = components.subList(1, components.size());
        for (int i = 0; i < localReferences.size(); ++i) {
            ProgressManager.checkCanceled();
            String currentName = localReferences.get(i);
            boolean isQualifier = localReferences.size() - 1 != i;
            lastElements = this.resolveLocalElements(currentName, lastElements, isQualifier);
            if (!lastElements.isEmpty()) continue;
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(5);
            }
            return list;
        }
        Set<PsiElement> set = lastElements;
        if (set == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    private Set<PsiElement> resolveTopLevelElements(String topLevelName, boolean isQualifier) {
        Set<PsiElement> set = this.expandElements(this.getTopLevelElements(topLevelName, isQualifier));
        if (set == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    protected abstract Collection<PsiElement> getTopLevelElements(@NotNull String var1, boolean var2);

    protected boolean isStrictTypeContext() {
        return false;
    }

    @NotNull
    private Set<PsiElement> resolveLocalElements(@NotNull String name, @NotNull Collection<PsiElement> scopes, boolean isQualifier) {
        if (name == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(8);
        }
        if (scopes == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(9);
        }
        THashSet collectedElements = ContainerUtil.newTroveSet();
        for (PsiElement scopeElement : scopes) {
            if (!JSQualifiedNameResolver.isAcceptableScope(scopeElement)) continue;
            Collection<? extends PsiElement> localElements = this.getLocalElements(name, scopeElement, isQualifier);
            collectedElements.addAll(localElements);
        }
        Set<PsiElement> set = this.expandElements((Collection<PsiElement>)collectedElements);
        if (set == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(10);
        }
        return set;
    }

    private static boolean isAcceptableScope(@NotNull PsiElement scopeElement) {
        if (scopeElement == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(11);
        }
        return TypeScriptPsiUtil.isTopLevelContainer(scopeElement) || scopeElement instanceof TypeScriptEnum;
    }

    @NotNull
    protected final Set<PsiElement> expandElements(@NotNull Collection<PsiElement> rawTopLevelElements) {
        if (rawTopLevelElements == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(12);
        }
        Set<PsiElement> set = rawTopLevelElements.stream().distinct().map(this::expandElement).flatMap(el -> el.stream()).filter(el -> !this.isStrictTypeContext() || JSQualifiedNameResolver.isStrictTypeContextElement(el)).collect(Collectors.toSet());
        if (set == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(13);
        }
        return set;
    }

    private static boolean isStrictTypeContextElement(@NotNull PsiElement el) {
        if (el == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(14);
        }
        return TypeScriptPsiUtil.isNamedTypeContainerDefinition(el) || TypeScriptPsiUtil.isNamedTypeDefinition(el);
    }

    @NotNull
    protected final Collection<PsiElement> expandElement(@NotNull PsiElement element) {
        if (element == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(15);
        }
        ProgressManager.checkCanceled();
        Collection results = (Collection)RecursionManager.doPreventingRecursion((Object)element, (boolean)false, () -> {
            if (element == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(44);
            }
            if (element instanceof TypeScriptImportStatement) {
                List<PsiElement> rawElements;
                Collection<PsiElement> elements;
                TypeScriptExternalModuleReference externalModuleReference = ((TypeScriptImportStatement)element).getExternalModuleReference();
                TypeScriptEntityName internalModuleReference = ((TypeScriptImportStatement)element).getInternalModuleReference();
                if (externalModuleReference != null) {
                    Collection resolveResults = externalModuleReference.multiResolve();
                    return this.processExternalModules(resolveResults);
                }
                if (internalModuleReference != null && !(elements = this.processWithResolveImportReferences(rawElements = JSResolveResult.toElements(internalModuleReference.multiResolve(false)), ContainerUtil.newHashSet())).isEmpty()) {
                    return elements;
                }
            } else if (JSQualifiedNameResolver.isImport(element)) {
                Collection<PsiElement> resolvedImports = this.resolveImport(element, ContainerUtil.newHashSet());
                if (!resolvedImports.isEmpty()) {
                    return resolvedImports;
                }
            } else if (element instanceof TypeScriptGlobalModuleExportDeclaration) {
                return this.processExternalModules(((TypeScriptGlobalModuleExportDeclaration)element).getModules());
            }
            return Collections.singletonList(element);
        });
        Collection collection = results == null ? ContainerUtil.emptyList() : results;
        if (collection == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @NotNull
    private Collection<PsiElement> processWithResolveImportReferences(@NotNull Collection<? extends PsiElement> elements, @Nullable Set<PsiElement> visited) {
        if (elements == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(17);
        }
        if (elements.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(18);
            }
            return list;
        }
        List result2 = ContainerUtil.newSmartList();
        for (PsiElement psiElement : elements) {
            if (JSQualifiedNameResolver.isImport(psiElement)) {
                Collection<PsiElement> resolved = this.resolveImport(psiElement, visited);
                result2.addAll(resolved);
                continue;
            }
            result2.add(psiElement);
        }
        List list = result2;
        if (list == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(19);
        }
        return list;
    }

    private static boolean isImport(@Nullable PsiElement element) {
        return element instanceof ES6ImportExportSpecifier || element instanceof ES6ImportedBinding || element instanceof TypeScriptImportStatement || element instanceof ES6ImportExportSpecifierAlias || element instanceof JSExportAssignment;
    }

    @NotNull
    private Collection<PsiElement> processExternalModules(@NotNull Collection<PsiElement> modules) {
        if (modules == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(20);
        }
        if (modules.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(21);
            }
            return list;
        }
        List result2 = ContainerUtil.newSmartList();
        for (PsiElement element : modules) {
            TypeScriptExportAssignment exportAssignment;
            if (TypeScriptPsiUtil.isTopLevelContainer(element) && (exportAssignment = TypeScriptPsiUtil.findExportAssignment(element)) != null) {
                result2.addAll(this.processAssignExpression((JSExportAssignment)exportAssignment));
                continue;
            }
            result2.add(element);
        }
        List list = result2;
        if (list == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    private Collection<PsiElement> processAssignExpression(@NotNull JSExportAssignment assignment) {
        JSElement candidate;
        String referenceName;
        if (assignment == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(23);
        }
        if ((referenceName = assignment.getInitializerReference()) != null) {
            JSQualifiedNameResolver resolver = this.createNestedResolver((PsiElement)assignment);
            Collection<PsiElement> collection = this.processWithResolveImportReferences(resolver.resolveQualifiedName(referenceName), ContainerUtil.newHashSet());
            if (collection == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(24);
            }
            return collection;
        }
        JSElement stubElement = assignment.getStubSafeElement();
        Object object = candidate = stubElement == null ? assignment.getExpression() : stubElement;
        if (candidate instanceof JSClass) {
            List<JSElement> list = Collections.singletonList(candidate);
            if (list == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(25);
            }
            return list;
        }
        if (candidate instanceof JSReferenceExpression) {
            Collection<PsiElement> collection = this.processWithResolveImportReferences(JSResolveResult.toElements(((JSReferenceExpression)candidate).multiResolve(false)), null);
            if (collection == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(26);
            }
            return collection;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(27);
        }
        return list;
    }

    @NotNull
    protected final Collection<PsiElement> resolveImport(@NotNull PsiElement element, @Nullable Set<PsiElement> visited) {
        if (element == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(28);
        }
        if (visited != null && !visited.add(element)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(29);
            }
            return list;
        }
        if (element instanceof TypeScriptImportStatement) {
            Collection<PsiElement> collection = this.processWithResolveImportReferences(((TypeScriptImportStatement)element).findReferencedElements(), visited);
            if (collection == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(30);
            }
            return collection;
        }
        if (element instanceof ES6ImportExportSpecifier) {
            Collection<PsiElement> collection = this.processWithResolveImportReferences(JSResolveResult.toElements(((ES6ImportExportSpecifier)element).resolveOverAliases()), visited);
            if (collection == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(31);
            }
            return collection;
        }
        if (element instanceof ES6ImportedBinding) {
            Collection<PsiElement> collection = this.processWithResolveImportReferences(((ES6ImportedBinding)element).findReferencedElements(), visited);
            if (collection == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(32);
            }
            return collection;
        }
        if (element instanceof ES6ImportExportSpecifierAlias) {
            ES6ImportExportSpecifier specifier = ((ES6ImportExportSpecifierAlias)element).findSpecifierElement();
            if (specifier != null) {
                Collection<PsiElement> collection = this.processWithResolveImportReferences(JSResolveResult.toElements(specifier.resolveOverAliases()), visited);
                if (collection == null) {
                    JSQualifiedNameResolver.$$$reportNull$$$0(33);
                }
                return collection;
            }
        } else if (element instanceof JSExportAssignment) {
            Collection<PsiElement> collection = this.processAssignExpression((JSExportAssignment)element);
            if (collection == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(34);
            }
            return collection;
        }
        List<PsiElement> list = Collections.singletonList(element);
        if (list == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(35);
        }
        return list;
    }

    @NotNull
    protected Collection<? extends PsiElement> getLocalElements(@NotNull String name, @NotNull PsiElement scopeElement, boolean isQualifier) {
        if (name == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(36);
        }
        if (scopeElement == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(37);
        }
        if (scopeElement instanceof TypeScriptEnum) {
            for (JSField member : ((TypeScriptEnum)scopeElement).getFields()) {
                if (!name.equals(member.getName())) continue;
                Set<JSField> set = Collections.singleton(member);
                if (set == null) {
                    JSQualifiedNameResolver.$$$reportNull$$$0(38);
                }
                return set;
            }
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(39);
            }
            return list;
        }
        JSElement module = ES6PsiUtil.getNonStrictExportScope(scopeElement);
        if (module == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSQualifiedNameResolver.$$$reportNull$$$0(40);
            }
            return list;
        }
        TypeScriptModuleDeclarationsProcessor processor = new TypeScriptModuleDeclarationsProcessor(name, this.isStrictTypeContext(), true);
        boolean includeExportedElements = !isQualifier;
        JSQualifiedNameResolver.processES6DeclarationsInScope(module, processor, includeExportedElements);
        List<PsiElement> list = processor.getResults();
        if (list == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(41);
        }
        return list;
    }

    public static boolean processES6DeclarationsInScope(@NotNull JSElement scope, final @NotNull PsiScopeProcessor processor, final boolean exportedElements) {
        if (scope == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(42);
        }
        if (processor == null) {
            JSQualifiedNameResolver.$$$reportNull$$$0(43);
        }
        if ((scope = (JSElement)CompletionUtilCoreImpl.getOriginalElement((PsiElement)scope)) == null) {
            return true;
        }
        final Ref result2 = Ref.create((Object)true);
        JSResolveProcessorBase delegatingProcessor = new JSResolveProcessorBase(processor){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (exportedElements && element instanceof JSPsiElementBase && element.getParent() instanceof ES6ExportDefaultAssignment) {
                    return true;
                }
                if (!exportedElements && element instanceof ES6ExportSpecifier) {
                    return true;
                }
                result2.set((Object)(processor.execute(element, state) && (Boolean)result2.get() != false ? 1 : 0));
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        JSStubBasedPsiTreeUtil.processDeclarationsInScope((PsiElement)scope, delegatingProcessor, false);
        if (!((Boolean)result2.get()).booleanValue()) {
            return false;
        }
        JSModuleElementsProcessor moduleElementsProcessor = processor instanceof JSModuleElementsResolveProcessor ? (JSModuleElementsProcessor)processor : new JSModuleElementsResolveProcessor(processor);
        return !exportedElements || ES6PsiUtil.processExportAllDeclarations(scope, moduleElementsProcessor, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver";
                break;
            }
            case 8: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 11: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawTopLevelElements";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 15: 
            case 28: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSQualifiedNameResolver";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveQualifiedName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTopLevelElements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalElements";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "expandElements";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "expandElement";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "processWithResolveImportReferences";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "processExternalModules";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "processAssignExpression";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveImport";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveQualifiedName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocalElements";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableScope";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "expandElements";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isStrictTypeContextElement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "expandElement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processWithResolveImportReferences";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processExternalModules";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processAssignExpression";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolveImport";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getLocalElements";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processES6DeclarationsInScope";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$expandElement$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

