/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSContextLevel;
import com.intellij.lang.javascript.psi.resolve.JSCoreLibraryElementsCollector;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTaggedResolveResult;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSGlobalSymbolIndex;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSNonGlobalSymbolIndex;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.psi.stubs.JSSymbolQualifiedNamesIndex;
import com.intellij.lang.javascript.statistics.JSResolveStatisticsCollector;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IdIterator;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIndexBasedResolveUtil {
    private static final int MAX_FILES_TO_PROCESS = Integer.valueOf(System.getProperty("js.max.files.to.process", "10"));

    public static void processAllSymbols(WalkUpResolveProcessor processor) {
        JSIndexBasedResolveUtil.processAllSymbols(processor, false, false, true);
    }

    static void processAllSymbols(@NotNull WalkUpResolveProcessor processor, boolean ignorePerformanceLimit, boolean excludeJsLibs, boolean includeTypeOnlyContextSymbols) {
        PsiElement context;
        Object allScope;
        if (processor == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(0);
        }
        GlobalSearchScope globalSearchScope = allScope = DialectDetector.isTypeScript(context = processor.getContext()) ? TypeScriptConfigService.Provider.getConfigResolveScope(context) : JSResolveUtil.getResolveScope(context);
        if (excludeJsLibs) {
            final Set<VirtualFile> files = JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles();
            allScope = new DelegatingGlobalSearchScope((GlobalSearchScope)allScope){

                public boolean contains(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return super.contains(file2) && !files.contains(file2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/resolve/JSIndexBasedResolveUtil$1", "contains"));
                }
            };
        }
        JSIndexBasedResolveUtil.processAllSymbols(processor, allScope, ignorePerformanceLimit, includeTypeOnlyContextSymbols);
    }

    private static void processAllSymbols(final @NotNull WalkUpResolveProcessor processor, @NotNull GlobalSearchScope includeScope, boolean ignorePerformanceLimit, boolean includeTypeOnlyContextSymbols) {
        if (processor == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(1);
        }
        if (includeScope == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(2);
        }
        PsiFile file2 = processor.getBaseFile();
        Project project = file2.getProject();
        String name = processor.getRequiredName();
        Stream<PsiElement> resultsBeforeProcessingFromIndex = processor.getTaggedResolveResults().stream().map(result2 -> result2.result.getElement());
        JSSymbolCollector collector = new JSSymbolCollector(resultsBeforeProcessingFromIndex, includeTypeOnlyContextSymbols, !processor.ecmal4 && !processor.typescript);
        for (JSContextLevel level : processor.getTypeInfo().myContextLevels) {
            PsiFile fileToIncludeLocal;
            JSNamespace namespace = level.myNamespace;
            JSQualifiedName ns = namespace.getQualifiedName();
            String qName = ns != null ? ns.getQualifiedName() + "." + name : name;
            PsiFile scopeFile = level.getScopeFile();
            GlobalSearchScope scope = scopeFile != null ? GlobalSearchScope.fileScope((PsiFile)scopeFile) : includeScope;
            PsiFile psiFile = fileToIncludeLocal = scopeFile != null ? scopeFile : file2;
            if (ignorePerformanceLimit || JSIndexBasedResolveUtil.cheapEnoughToProcessByQName(includeScope, project, qName)) {
                JSClassResolver.getInstance().processElementsByQNameIncludingImplicit(qName, scope, fileToIncludeLocal, collector);
                JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.PROCESSED_BY_QNAME, (Object)collector.myCollectedElements.size());
                continue;
            }
            processor.setTooManyCandidates();
            return;
        }
        JSIndexBasedResolveUtil.checkElements(processor, collector);
        List<JSTaggedResolveResult> resultsWithCompleteMatches = processor.getTaggedResolveResults();
        boolean hasValidResult = false;
        for (JSTaggedResolveResult completeMatchResult : resultsWithCompleteMatches) {
            if (!completeMatchResult.result.isValidResult() || completeMatchResult.hasTag(JSTaggedResolveResult.ResolveResultTag.PARTIAL)) continue;
            hasValidResult = true;
            break;
        }
        if (!hasValidResult && !processor.addOnlyCompleteMatches()) {
            StubIndexKey<String, JSElement> indexKey;
            StubIndexKey<String, JSElement> stubIndexKey = processor.getTypeInfo().isGlobalStatusHint() ? JSGlobalSymbolIndex.KEY : (indexKey = processor.getTypeInfo().isNonGlobalStatusHint() ? JSNonGlobalSymbolIndex.KEY : JSSymbolIndex2.KEY);
            if (ignorePerformanceLimit || JSIndexBasedResolveUtil.cheapEnoughToProcess(includeScope, project, name, indexKey)) {
                JSClassResolver.processElementsByNameIncludingImplicit(name, includeScope, false, indexKey, collector);
                JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.PROCESSED_BY_NAME, (Object)collector.myCollectedElements.size());
                JSIndexBasedResolveUtil.checkElements(processor, collector);
            } else {
                processor.setTooManyCandidates();
                return;
            }
        }
        JSIndexBasedResolveUtil.processImplicitElementProxies(name, includeScope, project, new JSSymbolProcessor(){

            @Override
            public boolean acceptsFile(@NotNull PsiFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return processor.acceptsFile(file2);
            }

            @Override
            public boolean process(@NotNull JSPsiElementBase element) {
                if (element == null) {
                    2.$$$reportNull$$$0(1);
                }
                processor.doQualifiedCheck(element);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSIndexBasedResolveUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptsFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean cheapEnoughToProcessByQName(@NotNull GlobalSearchScope allScope, @NotNull Project project, @NotNull String name) {
        IdIterator ids;
        if (allScope == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(3);
        }
        if (project == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(4);
        }
        if (name == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(5);
        }
        return (ids = StubIndex.getInstance().getContainingIds(JSSymbolQualifiedNamesIndex.KEY, (Object)name.hashCode(), project, allScope)).size() <= MAX_FILES_TO_PROCESS * 3;
    }

    private static boolean cheapEnoughToProcess(@NotNull GlobalSearchScope allScope, @NotNull Project project, @NotNull String name, @NotNull StubIndexKey<String, JSElement> indexKey) {
        IdIterator ids;
        if (allScope == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(6);
        }
        if (project == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(7);
        }
        if (name == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(8);
        }
        if (indexKey == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(9);
        }
        return (ids = StubIndex.getInstance().getContainingIds(indexKey, (Object)name, project, allScope)).size() <= MAX_FILES_TO_PROCESS;
    }

    private static void checkElements(WalkUpResolveProcessor processor, JSSymbolCollector collector) {
        collector.checkElements(element -> {
            ProgressManager.checkCanceled();
            if (!processor.acceptsFile(element.getContainingFile())) {
                return;
            }
            if (element instanceof JSQualifiedNamedElement || element instanceof JSImplicitElement) {
                processor.doQualifiedCheck((JSPsiElementBase)element);
            } else {
                processor.doUnqualifiedCheck((PsiElement)element);
            }
        });
    }

    public static boolean processImplicitElementProxies(@Nullable String name, @NotNull GlobalSearchScope scope, @NotNull Project project, @NotNull JSSymbolProcessor processor) {
        if (scope == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(10);
        }
        if (project == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(12);
        }
        Set<String> implicitKeys = name != null ? Collections.singleton(name) : FileBasedIndex.getInstance().getAllKeys(JSImplicitElementsIndex.INDEX_ID, project);
        ArrayList implicitElementProxies = new ArrayList();
        for (String key : implicitKeys) {
            FileBasedIndex.getInstance().processValues(JSImplicitElementsIndex.INDEX_ID, (Object)key, null, (virtualFile, value) -> {
                implicitElementProxies.add(Pair.create((Object)virtualFile, (Object)value));
                return true;
            }, scope);
        }
        for (Pair pair : implicitElementProxies) {
            VirtualFile virtualFile2 = (VirtualFile)pair.first;
            Collection value2 = (Collection)pair.second;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile2);
            if (psiFile == null || !processor.acceptsFile(psiFile)) continue;
            for (JSImplicitElementsIndex.JSElementProxy proxy : value2) {
                JSOffsetBasedImplicitElement element = proxy.toOffsetBasedImplicitElement(psiFile);
                if (element.getUserString() != null || processor.process((JSPsiElementBase)element)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeScope";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allScope";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSIndexBasedResolveUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllSymbols";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "cheapEnoughToProcessByQName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "cheapEnoughToProcess";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "processImplicitElementProxies";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class JSSymbolCollector
    implements Processor<JSPsiElementBase> {
        @NotNull
        private List<PsiElement> myCollectedElements;
        @Nullable
        private Set<PsiElement> myCheckedElements;
        private Set<PsiElement> myProcessedElements;
        private final boolean myIncludeTypeOnlyContextSymbols;
        @Nullable
        private final JSCoreLibraryElementsCollector<Void> myCoreLibraryElementsCollector;

        public JSSymbolCollector(@NotNull Stream<PsiElement> alreadyProcessed, boolean includeTypeOnlyContextSymbols, boolean collectCoreLibraryFiles) {
            if (alreadyProcessed == null) {
                JSSymbolCollector.$$$reportNull$$$0(0);
            }
            this.myIncludeTypeOnlyContextSymbols = includeTypeOnlyContextSymbols;
            this.myCoreLibraryElementsCollector = collectCoreLibraryFiles ? new JSCoreLibraryElementsCollector() : null;
            this.myCollectedElements = new ArrayList<PsiElement>();
            this.myProcessedElements = alreadyProcessed.collect(Collectors.toSet());
        }

        public boolean process(JSPsiElementBase element) {
            if (this.myCoreLibraryElementsCollector != null && this.myCoreLibraryElementsCollector.isLibraryElement((PsiElement)element)) {
                this.myCoreLibraryElementsCollector.addElement((PsiElement)element, null);
                return true;
            }
            if (this.myCheckedElements != null) {
                if (this.myProcessedElements == null) {
                    this.myProcessedElements = this.myCheckedElements;
                } else {
                    this.myProcessedElements.addAll(this.myCheckedElements);
                }
                this.myCollectedElements = new ArrayList<PsiElement>();
                this.myCheckedElements = null;
            }
            if (element instanceof JSFunctionExpression || element instanceof ES6Decorator || !this.myIncludeTypeOnlyContextSymbols && element instanceof TypeScriptInterface) {
                return true;
            }
            if (this.myProcessedElements == null || !this.myProcessedElements.contains(element)) {
                this.myCollectedElements.add((PsiElement)element);
            }
            return true;
        }

        public void checkElements(@NotNull Consumer<PsiElement> consumer) {
            if (consumer == null) {
                JSSymbolCollector.$$$reportNull$$$0(1);
            }
            Set<PsiElement> coreElements = this.myCoreLibraryElementsCollector == null ? Collections.emptySet() : this.myCoreLibraryElementsCollector.getElements();
            THashSet elements = new THashSet(this.myCollectedElements.size() + coreElements.size());
            Consumer<PsiElement> elementConsumer = arg_0 -> JSSymbolCollector.lambda$checkElements$0((Set)elements, consumer, arg_0);
            this.myCollectedElements.forEach(elementConsumer);
            coreElements.forEach(elementConsumer);
            this.myCheckedElements = elements;
        }

        private static /* synthetic */ void lambda$checkElements$0(Set elements, @NotNull Consumer consumer, PsiElement e) {
            if (consumer == null) {
                JSSymbolCollector.$$$reportNull$$$0(2);
            }
            if (elements.add(e)) {
                consumer.accept(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alreadyProcessed";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSIndexBasedResolveUtil$JSSymbolCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkElements";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$checkElements$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface JSSymbolProcessor {
        public boolean acceptsFile(@NotNull PsiFile var1);

        public boolean process(@NotNull JSPsiElementBase var1);
    }
}

