/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSContextLevel {
    @NotNull
    public final JSNamespace myNamespace;
    public final int myRelativeLevel;
    @Nullable
    private final PsiElement myLocalScope;

    public JSContextLevel(@NotNull JSNamespace namespace, int relativeLevel) {
        if (namespace == null) {
            JSContextLevel.$$$reportNull$$$0(0);
        }
        this(namespace, relativeLevel, null);
    }

    public JSContextLevel(@NotNull JSNamespace namespace, int relativeLevel, @Nullable PsiElement localScope) {
        if (namespace == null) {
            JSContextLevel.$$$reportNull$$$0(1);
        }
        this.myNamespace = namespace;
        this.myRelativeLevel = relativeLevel;
        this.myLocalScope = localScope;
    }

    public String toString() {
        return this.myNamespace.toString() + " ," + String.valueOf(this.myRelativeLevel);
    }

    public boolean isElementInScope(@NotNull PsiElement element, @NotNull PsiFile currentFile) {
        boolean isElementLocal;
        if (element == null) {
            JSContextLevel.$$$reportNull$$$0(2);
        }
        if (currentFile == null) {
            JSContextLevel.$$$reportNull$$$0(3);
        }
        if (this.myLocalScope != null) {
            PsiElement scope = element;
            while (scope != null) {
                if (this.myLocalScope.equals(scope)) {
                    return true;
                }
                scope = JSPsiImplUtils.getExecutionScope(scope);
            }
            return false;
        }
        boolean bl = isElementLocal = element instanceof JSPsiElementBase && ((JSPsiElementBase)element).getJSNamespace().isLocal();
        return !isElementLocal || element.getContainingFile().isEquivalentTo((PsiElement)currentFile);
    }

    public boolean isGlobal() {
        return this.myLocalScope == null;
    }

    @Nullable
    public PsiFile getScopeFile() {
        return this.myLocalScope != null ? this.myLocalScope.getContainingFile() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSContextLevel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isElementInScope";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

