/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.controlflow;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowProcessor;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JSControlFlowUtils {
    public static void processControlFlowFor(JSExecutionScope element, final JSControlFlowProcessor controlFlowProcessor) {
        element.acceptChildren((PsiElementVisitor)new JSRecursiveElementVisitor(){
            boolean ceaseCurrentBlock;
            boolean isInsideDefinitionExpression;
            final List<JSElement> blocks = new ArrayList<JSElement>();
            private boolean mySkipWritesWhenReplay;

            public void visitJSDefinitionExpression(JSDefinitionExpression node) {
                JSExpression collectionExpression;
                boolean wasInsideDefinitionExpression = this.isInsideDefinitionExpression;
                this.isInsideDefinitionExpression = true;
                super.visitJSDefinitionExpression(node);
                this.isInsideDefinitionExpression = wasInsideDefinitionExpression;
                PsiElement parent = node.getParent();
                JSExpression expression = node.getExpression();
                if (parent instanceof JSAssignmentExpression) {
                    JSAssignmentExpression assignmentExpression = (JSAssignmentExpression)parent;
                    JSExpression rOperand = assignmentExpression.getROperand();
                    if (rOperand != null) {
                        if (assignmentExpression.getOperationSign() != JSTokenTypes.EQ) {
                            controlFlowProcessor.valueRead(expression);
                            if (!this.mySkipWritesWhenReplay) {
                                controlFlowProcessor.valueWritten((JSElement)expression, expression);
                            }
                        } else if (!this.mySkipWritesWhenReplay) {
                            controlFlowProcessor.valueWritten((JSElement)expression, rOperand);
                        }
                    }
                } else if (parent instanceof JSForInStatement && (collectionExpression = ((JSForInStatement)parent).getCollectionExpression()) != null) {
                    controlFlowProcessor.valueWritten((JSElement)expression, collectionExpression);
                }
            }

            public void visitJSTryStatement(JSTryStatement node) {
                JSStatement statement = node.getStatement();
                JSStatement finallyStatement = node.getFinallyStatement();
                if (statement != null) {
                    controlFlowProcessor.branchingStarted((JSElement)statement);
                    controlFlowProcessor.branchStarted(null, (JSElement)statement, new JSExpression[0]);
                    statement.accept((PsiElementVisitor)this);
                    controlFlowProcessor.branchingStarted(null);
                    for (JSCatchBlock c : node.getAllCatchBlocks()) {
                        controlFlowProcessor.branchStarted(null, (JSElement)c, new JSExpression[0]);
                        c.accept((PsiElementVisitor)this);
                        controlFlowProcessor.branchFinished((JSElement)c);
                    }
                    controlFlowProcessor.branchingFinished(null);
                    controlFlowProcessor.branchFinished((JSElement)statement);
                    controlFlowProcessor.branchingFinished((JSElement)statement);
                    if (finallyStatement != null) {
                        finallyStatement.accept((PsiElementVisitor)this);
                    }
                }
            }

            public void visitJSReturnStatement(JSReturnStatement node) {
                super.visitJSReturnStatement(node);
                if (node.getParent() instanceof JSBlockStatement) {
                    this.ceaseCurrentBlock = true;
                }
            }

            public void visitJSBreakStatement(JSBreakStatement node) {
                JSStatement statementToBreak = node.getStatementToBreak();
                if (statementToBreak instanceof JSLoopStatement) {
                    // empty if block
                }
                if (node.getParent() instanceof JSBlockStatement) {
                    this.ceaseCurrentBlock = true;
                }
            }

            public void visitJSContinueStatement(JSContinueStatement node) {
                JSStatement statementToContinue = node.getStatementToContinue();
                if (statementToContinue instanceof JSLoopStatement) {
                    // empty if block
                }
                if (node.getParent() instanceof JSBlockStatement) {
                    this.ceaseCurrentBlock = true;
                }
            }

            public void visitJSClass(JSClass aClass) {
            }

            public void visitJSThrowStatement(JSThrowStatement node) {
                super.visitJSThrowStatement(node);
                if (node.getParent() instanceof JSBlockStatement) {
                    this.ceaseCurrentBlock = true;
                }
            }

            public void visitJSVariable(JSVariable node) {
                PsiElement identifier = node.getNameIdentifier();
                if (!(node instanceof JSParameter)) {
                    JSExpression initializer = node.getInitializer();
                    if (initializer != null) {
                        initializer.accept((PsiElementVisitor)this);
                        if (!(identifier instanceof JSReferenceExpression)) {
                            controlFlowProcessor.valueWritten((JSElement)node, initializer);
                        } else {
                            identifier.accept((PsiElementVisitor)this);
                        }
                    } else {
                        initializer = JSDestructuringUtil.getNearestDestructuringInitializer(node);
                        if (initializer != null) {
                            controlFlowProcessor.valueWritten((JSElement)node, initializer);
                        } else {
                            JSExpression collectionExpression;
                            PsiElement varStatement;
                            PsiElement parent;
                            if (identifier != null) {
                                identifier.accept((PsiElementVisitor)this);
                            }
                            PsiElement psiElement = parent = (varStatement = JSDestructuringUtil.getParentSkippingDestructuring((JSElement)node)) != null ? varStatement.getParent() : null;
                            if (parent instanceof JSForInStatement && ((JSForInStatement)parent).getDeclarationStatement() == varStatement && (collectionExpression = ((JSForInStatement)parent).getCollectionExpression()) != null) {
                                controlFlowProcessor.valueWritten((JSElement)node, collectionExpression);
                            }
                        }
                    }
                } else {
                    if (identifier != null) {
                        identifier.accept((PsiElementVisitor)this);
                    }
                    controlFlowProcessor.valueWritten((JSElement)node, null);
                }
            }

            public void visitJSAssignmentExpression(JSAssignmentExpression node) {
                JSExpression loperand = node.getLOperand();
                JSExpression roperand = node.getROperand();
                if (roperand != null) {
                    roperand.accept((PsiElementVisitor)this);
                }
                if (loperand != null) {
                    loperand.accept((PsiElementVisitor)this);
                }
            }

            private boolean isFalse(JSExpression condition) {
                return condition instanceof JSLiteralExpression && condition.getFirstChild().getNode().getElementType() == JSTokenTypes.FALSE_KEYWORD;
            }

            private boolean isTrue(JSExpression condition) {
                return condition instanceof JSLiteralExpression && condition.getFirstChild().getNode().getElementType() == JSTokenTypes.TRUE_KEYWORD;
            }

            public void visitJSDoWhileStatement(JSDoWhileStatement node) {
                JSStatement body = node.getBody();
                if (body != null) {
                    JSExpression condition = node.getCondition();
                    controlFlowProcessor.branchingStarted((JSElement)condition);
                    if (!this.isFalse(condition) && !this.isTrue(condition)) {
                        controlFlowProcessor.branchStarted(condition, (JSElement)body, new JSExpression[0]);
                        body.accept((PsiElementVisitor)this);
                        this.replayLoopPart((JSElement)condition);
                        controlFlowProcessor.branchFinished((JSElement)body);
                    } else {
                        body.accept((PsiElementVisitor)this);
                        this.replayLoopPart((JSElement)condition);
                    }
                    controlFlowProcessor.branchingFinished((JSElement)condition);
                }
            }

            public void visitJSWhileStatement(JSWhileStatement node) {
                JSExpression condition = node.getCondition();
                if (condition != null) {
                    condition.accept((PsiElementVisitor)this);
                }
                if (this.isFalse(condition)) {
                    return;
                }
                controlFlowProcessor.branchingStarted((JSElement)condition);
                JSStatement body = node.getBody();
                if (body == null) {
                    return;
                }
                if (this.isTrue(condition)) {
                    body.accept((PsiElementVisitor)this);
                    this.replayLoopPart((JSElement)condition);
                    this.replayLoopPart((JSElement)body);
                } else {
                    controlFlowProcessor.branchStarted(condition, (JSElement)body, new JSExpression[0]);
                    body.accept((PsiElementVisitor)this);
                    this.replayLoopPart((JSElement)condition);
                    this.replayLoopPart((JSElement)body);
                    controlFlowProcessor.branchFinished((JSElement)body);
                }
                controlFlowProcessor.branchingFinished((JSElement)condition);
            }

            private void replayLoopPart(JSElement condition) {
                if (condition != null) {
                    this.mySkipWritesWhenReplay = true;
                    condition.accept((PsiElementVisitor)this);
                    this.mySkipWritesWhenReplay = false;
                }
            }

            public void visitJSForInStatement(JSForInStatement node) {
                super.visitJSForInStatement(node);
                JSStatement body = node.getBody();
                if (body != null) {
                    this.replayLoopPart((JSElement)body);
                }
            }

            public void visitJSForStatement(JSForStatement node) {
                JSVarStatement declaration = node.getVarDeclaration();
                if (declaration != null) {
                    declaration.accept((PsiElementVisitor)this);
                } else {
                    JSExpression initialization = node.getInitialization();
                    if (initialization != null) {
                        initialization.accept((PsiElementVisitor)this);
                    }
                }
                JSExpression condition = node.getCondition();
                JSStatement body = node.getBody();
                JSExpression update = node.getUpdate();
                if (condition != null) {
                    condition.accept((PsiElementVisitor)this);
                }
                if (this.isFalse(condition)) {
                    return;
                }
                controlFlowProcessor.branchingStarted((JSElement)condition);
                if (condition == null || this.isTrue(condition)) {
                    if (body != null) {
                        body.accept((PsiElementVisitor)this);
                    }
                    if (update != null) {
                        update.accept((PsiElementVisitor)this);
                    }
                    this.replayLoopPart((JSElement)condition);
                    this.replayLoopPart((JSElement)body);
                } else {
                    controlFlowProcessor.branchStarted(condition, (JSElement)body, new JSExpression[0]);
                    if (body != null) {
                        body.accept((PsiElementVisitor)this);
                    }
                    if (update != null) {
                        update.accept((PsiElementVisitor)this);
                    }
                    this.replayLoopPart((JSElement)condition);
                    this.replayLoopPart((JSElement)body);
                    controlFlowProcessor.branchFinished((JSElement)body);
                }
                controlFlowProcessor.branchingFinished((JSElement)condition);
            }

            public void visitJSConditionalExpression(JSConditionalExpression node) {
                this.processConditional(true, node.getCondition(), (JSElement)node.getThen(), (JSElement)node.getElse());
            }

            public void visitJSIfStatement(JSIfStatement node) {
                this.processConditional(!(node.getParent() instanceof JSIfStatement), node.getCondition(), (JSElement)node.getThen(), (JSElement)node.getElse());
            }

            private void processConditional(boolean separateBranch, @Nullable JSExpression condition, @Nullable JSElement then, @Nullable JSElement anElse) {
                if (condition != null) {
                    condition.accept((PsiElementVisitor)this);
                }
                if (separateBranch) {
                    controlFlowProcessor.branchingStarted((JSElement)condition);
                }
                boolean conditionIsAlwaysTrue = this.isTrue(condition);
                if (!this.isFalse(condition) && then != null) {
                    if (!conditionIsAlwaysTrue) {
                        controlFlowProcessor.branchStarted(condition, then, new JSExpression[0]);
                    }
                    then.accept((PsiElementVisitor)this);
                    if (!conditionIsAlwaysTrue) {
                        controlFlowProcessor.branchFinished(then);
                    }
                }
                if (!conditionIsAlwaysTrue && anElse != null) {
                    controlFlowProcessor.branchStarted(condition, anElse, new JSExpression[0]);
                    anElse.accept((PsiElementVisitor)this);
                    controlFlowProcessor.branchFinished(anElse);
                }
                if (separateBranch) {
                    controlFlowProcessor.branchingFinished((JSElement)condition);
                }
            }

            public void visitJSSwitchStatement(JSSwitchStatement node) {
                JSExpression expression = node.getSwitchExpression();
                controlFlowProcessor.branchingStarted((JSElement)expression);
                controlFlowProcessor.branchStarted(expression, (JSElement)node, new JSExpression[0]);
                super.visitJSSwitchStatement(node);
                controlFlowProcessor.branchFinished((JSElement)node);
                controlFlowProcessor.branchingFinished((JSElement)expression);
            }

            public void visitJSStatement(JSStatement node) {
                if (!this.ceaseCurrentBlock) {
                    if (node instanceof JSBlockStatement) {
                        this.blocks.add((JSElement)node);
                    }
                    super.visitJSStatement(node);
                    controlFlowProcessor.finishStatement((JSElement)node);
                }
                if (this.blocks.size() > 0 && this.blocks.get(this.blocks.size() - 1) == node) {
                    this.blocks.remove(this.blocks.size() - 1);
                    this.ceaseCurrentBlock = false;
                }
            }

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                PsiElement parent = node.getParent();
                if (!(parent instanceof JSDefinitionExpression)) {
                    if (parent instanceof JSVariable) {
                        if (JSResolveUtil.isSelfReference((PsiElement)node)) {
                            JSExpression initializer = ((JSVariable)parent).getInitializer();
                            if (initializer != null) {
                                controlFlowProcessor.valueWritten((JSElement)node, initializer);
                            }
                        } else {
                            controlFlowProcessor.valueRead((JSExpression)node);
                        }
                    } else if (parent instanceof JSForInStatement && ((JSForInStatement)parent).getVariableExpression() == node) {
                        JSForInStatement forInStatement = (JSForInStatement)parent;
                        controlFlowProcessor.valueWritten((JSElement)node, forInStatement.getCollectionExpression());
                    } else if (this.isInsideDefinitionExpression) {
                        JSExpression initializer = JSDestructuringUtil.getDestructuringAssignmentInitializer((JSExpression)node);
                        if (initializer != null) {
                            controlFlowProcessor.valueWritten((JSElement)node, initializer);
                        } else {
                            controlFlowProcessor.valueRead((JSExpression)node);
                        }
                    } else if (!(parent instanceof JSFunction)) {
                        controlFlowProcessor.valueRead((JSExpression)node);
                    }
                }
                super.visitJSReferenceExpression(node);
            }

            public void visitJSPrefixExpression(JSPrefixExpression node) {
                IElementType operationSign = node.getOperationSign();
                if (operationSign == JSTokenTypes.PLUSPLUS || operationSign == JSTokenTypes.MINUSMINUS) {
                    JSExpression expression = node.getExpression();
                    controlFlowProcessor.valueRead(expression);
                    controlFlowProcessor.valueWritten((JSElement)expression, expression);
                    controlFlowProcessor.valueRead(expression);
                }
                super.visitJSPrefixExpression(node);
            }

            public void visitJSPostfixExpression(JSPostfixExpression node) {
                super.visitJSPostfixExpression(node);
                IElementType operationSign = node.getOperationSign();
                if (operationSign == JSTokenTypes.PLUSPLUS || operationSign == JSTokenTypes.MINUSMINUS) {
                    JSExpression expression = node.getExpression();
                    controlFlowProcessor.valueRead(expression);
                    if (!this.mySkipWritesWhenReplay) {
                        controlFlowProcessor.valueWritten((JSElement)expression, expression);
                    }
                }
            }

            public boolean visitAsFunction(JSFunction function) {
                controlFlowProcessor.functionEncountered(function);
                return true;
            }
        });
    }
}

