/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.psi.ExpectedTypeEvaluator;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class TypeScriptExpectedTypeEvaluator
extends ExpectedTypeEvaluator {
    public TypeScriptExpectedTypeEvaluator(JSExpression parent, JSExpectedTypeKind expectedTypeKind) {
        super(parent, expectedTypeKind);
    }

    @Override
    protected TypeScriptExpectedTypeEvaluator newExpectedTypeEvaluator(JSExpression parent, JSExpectedTypeKind expectedTypeKind) {
        return new TypeScriptExpectedTypeEvaluator(parent, expectedTypeKind);
    }

    @Override
    protected JSType fixResultForOrOrRightOp(@Nullable JSType type, @Nullable JSExpression operand) {
        return type == null ? JSResolveUtil.getExpressionJSType(operand) : type;
    }

    public void visitTypeScriptLiteralType(TypeScriptLiteralType node) {
        JSExpression expression = node.getExpression();
        if (expression != this.myParent) {
            return;
        }
        TypeScriptType type = TypeScriptPsiUtil.getParentTypeViaUnionsAndIntersections((TypeScriptType)node, this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED);
        PsiElement typeParent = type.getParent();
        if (!(typeParent instanceof TypeScriptTypeArgumentList)) {
            return;
        }
        Object[] typeArguments = ((TypeScriptTypeArgumentList)typeParent).getTypeArguments();
        int index = ArrayUtil.indexOf((Object[])typeArguments, (Object)type);
        if (index < 0) {
            return;
        }
        PsiElement singleTypeUsage = typeParent.getParent();
        if (!(singleTypeUsage instanceof TypeScriptSingleType)) {
            return;
        }
        JSReferenceExpression referenceExpression = ((TypeScriptSingleType)singleTypeUsage).getReferenceExpression();
        if (referenceExpression == null) {
            return;
        }
        PsiElement element = referenceExpression.resolve();
        if (!(element instanceof TypeScriptTypeParameterListOwner)) {
            return;
        }
        TypeScriptTypeParameterList typeParams = ((TypeScriptTypeParameterListOwner)element).getTypeParameterList();
        if (typeParams == null) {
            return;
        }
        TypeScriptTypeParameter[] typeParameters = typeParams.getTypeParameters();
        if (typeParameters.length <= index) {
            return;
        }
        TypeScriptTypeParameter param = typeParameters[index];
        if (param == null) {
            return;
        }
        TypeScriptType constraint = param.getTypeConstraint();
        if (constraint == null) {
            return;
        }
        JSType cType = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)constraint);
        if (!JSTypeUtils.hasGenericParameter(cType)) {
            this.myResult = cType;
            return;
        }
        JSTypeSubstitutor subst = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameters, Arrays.stream(typeArguments).map(a -> TypeScriptTypeParser.buildTypeFromTypeScript(a)).collect(Collectors.toList()));
        this.myResult = cType = JSTypeUtils.applyGenericArguments(cType, (Map<String, JSType>)subst);
    }
}

