/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.navigation;

import com.intellij.codeInsight.navigation.actions.TypeDeclarationProvider;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptTypeDeclarationProvider
implements TypeDeclarationProvider {
    public PsiElement[] getSymbolTypeDeclarations(@NotNull PsiElement symbol) {
        PsiElement[] elements;
        if (symbol == null) {
            JavaScriptTypeDeclarationProvider.$$$reportNull$$$0(0);
        }
        if (!(symbol instanceof JSNamedElement)) {
            return null;
        }
        JSType type = null;
        if (symbol instanceof JSFunction) {
            type = ((JSFunction)symbol).getReturnType();
        } else if (symbol instanceof JSVariable) {
            PsiElement constructor = JavaScriptTypeDeclarationProvider.findReferencedModuleConstructor((JSVariable)symbol);
            if (constructor != null) {
                return new PsiElement[]{constructor};
            }
            type = ((JSVariable)symbol).getType();
        } else if (symbol instanceof JSExpression) {
            type = JSResolveUtil.getExpressionJSType((JSExpression)symbol);
        }
        if (DialectDetector.isTypeScript(symbol) && (elements = TypeScriptTypeParser.resolveElementsByType(type).toArray(PsiElement.EMPTY_ARRAY)).length > 0) {
            return elements;
        }
        if (type != null) {
            PsiFile containingFile = symbol.getContainingFile();
            String s = type.getResolvedTypeText();
            boolean ecmaL4 = DialectDetector.isActionScript((PsiElement)containingFile);
            GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)containingFile);
            PsiElement item = JSDialectSpecificHandlersFactory.forElement(symbol).getClassResolver().findClassByQName(s, symbol);
            if (item == null) {
                ArrayList result2 = new ArrayList();
                JSClassResolver.processElementsByNameIncludingImplicit(s, scope, false, (Processor<JSPsiElementBase>)((Processor)namedElement -> {
                    boolean ecmalL4File = DialectDetector.isActionScript((PsiElement)namedElement.getContainingFile());
                    if (ecmalL4File != ecmaL4) {
                        return true;
                    }
                    result2.add(0, namedElement);
                    return true;
                }));
                if (!result2.isEmpty()) {
                    item = (PsiElement)result2.get(0);
                }
            }
            if (item != null && item.isPhysical()) {
                return new PsiElement[]{item};
            }
        }
        return new PsiElement[]{symbol};
    }

    @Nullable
    private static PsiElement findReferencedModuleConstructor(JSVariable element) {
        if (element instanceof JSParameter) {
            JSLiteralExpression argument = JSSymbolUtil.getParameterInitializationIfRequireArgument((JSParameter)element);
            if (argument != null) {
                PsiReference[] references = argument.getReferences();
                Collection<PsiElement> modules = JSFileReferencesUtil.getMostPriorityModules((PsiElement)element, references);
                for (PsiElement resolve : modules) {
                    if (!(resolve instanceof JSFile)) continue;
                    JSPsiElementBase exportedElement = JSResolveUtil.getExportedElement((JSFile)resolve);
                    return exportedElement != null ? exportedElement : resolve;
                }
            }
        } else {
            JSExpression initializer = element.getInitializer();
            if (initializer instanceof JSCallExpression) {
                return JavaScriptTypeDeclarationProvider.findReferencedModuleConstructorIfRequireCall((JSCallExpression)initializer);
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement findReferencedModuleConstructorIfRequireCall(@NotNull JSCallExpression callExpression) {
        PsiElement module;
        if (callExpression == null) {
            JavaScriptTypeDeclarationProvider.$$$reportNull$$$0(1);
        }
        if ((module = CommonJSUtil.findReferencedModuleIfRequireCall(callExpression)) instanceof JSFile) {
            JSPsiElementBase exportedElement = JSResolveUtil.getExportedElement((JSFile)module);
            return exportedElement != null ? exportedElement : module;
        }
        return module;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/navigation/JavaScriptTypeDeclarationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSymbolTypeDeclarations";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findReferencedModuleConstructorIfRequireCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

