/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.modules.ES6CheckImportInspection;
import com.intellij.lang.javascript.modules.InstallNodeModuleAddToDevDependenciesQuickFix;
import com.intellij.lang.javascript.modules.InstallNodeModuleQuickFix;
import com.intellij.lang.javascript.modules.JSModuleVisitor;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.NpmUsedModulesInstalledInspection;
import com.intellij.lang.javascript.modules.TypeScriptCheckImportInspection;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.typescript.compiler.TypeScriptLanguageServiceAnnotatorCheckerProvider;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/javascript/modules/TypeScriptCheckImportInspection;", "Lcom/intellij/lang/javascript/modules/ES6CheckImportInspection;", "()V", "checkConfigIsAcceptable", "", "tsConfig", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptConfig;", "createVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "getDefaultLevel", "Lcom/intellij/codeHighlighting/HighlightDisplayLevel;", "getDisplayName", "", "getRangeForError", "Lcom/intellij/openapi/util/TextRange;", "psiElementForError", "Lcom/intellij/psi/PsiElement;", "moduleName", "isFileAcceptable", "file", "Lcom/intellij/psi/PsiFile;", "intellij.javascript.impl"})
public final class TypeScriptCheckImportInspection
extends ES6CheckImportInspection {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"javascript.validate.imports.name", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JSBundle.message(\"javasc\u2026t.validate.imports.name\")");
        return string;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        Intrinsics.checkExpressionValueIsNotNull((Object)highlightDisplayLevel, (String)"HighlightDisplayLevel.ERROR");
        return highlightDisplayLevel;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        PsiFile file2;
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        PsiFile psiFile = file2 = holder.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"file");
        boolean isServiceEnabled = this.isFileAcceptable(psiFile) && TypeScriptAnnotatorCheckerProvider.getCheckerProvider((PsiElement)file2) instanceof TypeScriptLanguageServiceAnnotatorCheckerProvider;
        return (PsiElementVisitor)new JSModuleVisitor(this, holder, isServiceEnabled){
            final /* synthetic */ TypeScriptCheckImportInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isServiceEnabled;

            protected boolean isAvailable(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                return DialectDetector.isTypeScript(element);
            }

            public void visitES6ImportedBinding(@NotNull ES6ImportedBinding importedBinding) {
                Intrinsics.checkParameterIsNotNull((Object)importedBinding, (String)"importedBinding");
                if (!this.isAvailable((PsiElement)importedBinding)) {
                    return;
                }
                this.this$0.visitES6ImportedBindingImpl(importedBinding, this.$holder, this.getProblemHighlightType());
            }

            public void visitES6ImportExportSpecifier(@NotNull ES6ImportExportSpecifier node) {
                Object elements;
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                if (!this.isAvailable((PsiElement)node)) {
                    return;
                }
                Object object = node.getDeclaration();
                if (object == null || (object = object.getFromClause()) == null || (object = object.resolveReferencedElements()) == null) {
                    object = CollectionsKt.emptyList();
                }
                Object object2 = elements = object;
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"elements");
                Sequence $receiver$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)object2)), (Function1)createVisitor.visitES6ImportExportSpecifier.1.INSTANCE);
                Iterator iterator = $receiver$iv.iterator();
                if (iterator.hasNext()) {
                    E element$iv = iterator.next();
                    PsiElement it = (PsiElement)element$iv;
                    return;
                }
                this.this$0.visitSpecifierImpl(this.$holder, node, this.getProblemHighlightType());
            }

            protected void processImport(@NotNull PsiElement literalElement, @NotNull String quotedLiteralValue, @NotNull PsiReference[] references, @NotNull JSModuleVisitor.ImportResolver importResolver, @NotNull JSModuleVisitor.ModulePointerBuilder pointerBuilder) {
                Intrinsics.checkParameterIsNotNull((Object)literalElement, (String)"literalElement");
                Intrinsics.checkParameterIsNotNull((Object)quotedLiteralValue, (String)"quotedLiteralValue");
                Intrinsics.checkParameterIsNotNull((Object)references, (String)"references");
                Intrinsics.checkParameterIsNotNull((Object)importResolver, (String)"importResolver");
                Intrinsics.checkParameterIsNotNull((Object)pointerBuilder, (String)"pointerBuilder");
                this.checkImports(literalElement, quotedLiteralValue, references, importResolver, pointerBuilder);
            }

            protected void processRequire(@NotNull JSCallExpression element, @NotNull JSLiteralExpression argument, @NotNull JSModuleVisitor.ImportResolver importResolver, @NotNull JSModuleVisitor.ModulePointerBuilder pointerBuilder) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
                Intrinsics.checkParameterIsNotNull((Object)importResolver, (String)"importResolver");
                Intrinsics.checkParameterIsNotNull((Object)pointerBuilder, (String)"pointerBuilder");
            }

            private final void checkImports(PsiElement psiElementForError, String refText, PsiReference[] references, JSModuleVisitor.ImportResolver importResolver, JSModuleVisitor.ModulePointerBuilder pointerBuilder) {
                if (!this.checkAsNodePackage(psiElementForError, refText, importResolver, pointerBuilder)) {
                    Collection<PsiElement> resolveImportModules = importResolver.resolveImportModules();
                    Collection<PsiElement> collection = resolveImportModules;
                    if (!collection.isEmpty()) {
                        return;
                    }
                    this.validateImportReferences(references);
                }
            }

            private final void validateImportReferences(PsiReference[] references) {
                Object[] objectArray;
                Object[] reference;
                boolean resolve = false;
                ArrayList unresolvedRefs = ContainerUtil.newArrayList();
                int n = references.length;
                for (int i = 0; i < n; ++i) {
                    block8: {
                        block7: {
                            block6: {
                                Object[] objectArray2;
                                reference = references[i];
                                if (!(reference instanceof PsiPolyVariantReference)) break block6;
                                ResolveResult[] resolveResultArray = ((PsiPolyVariantReference)reference).multiResolve(false);
                                Intrinsics.checkExpressionValueIsNotNull((Object)resolveResultArray, (String)"reference.multiResolve(false)");
                                Object[] objectArray3 = objectArray2 = (Object[])resolveResultArray;
                                if (!(objectArray3.length == 0)) break block7;
                            }
                            if (reference.resolve() == null) break block8;
                        }
                        if (reference instanceof FileReference && !((FileReference)reference).isLast()) continue;
                        resolve = true;
                        continue;
                    }
                    unresolvedRefs.add(reference);
                }
                if (!resolve && !((objectArray = (reference = (Object[])references)).length == 0)) {
                    Object object = ContainerUtil.getFirstItem((List)unresolvedRefs);
                    if (object == null) {
                        Intrinsics.throwNpe();
                    }
                    PsiReference element = (PsiReference)object;
                    this.$holder.registerProblem(element, XmlHighlightVisitor.getErrorDescription((PsiReference)element), this.getProblemHighlightType());
                }
            }

            private final boolean checkAsNodePackage(PsiElement psiElementForError, String refText, JSModuleVisitor.ImportResolver importResolver, JSModuleVisitor.ModulePointerBuilder pointerBuilder) {
                boolean isNodeJSCoreModule;
                String expectedTypesName;
                boolean bl;
                Collection<PsiElement> resolveImportModules;
                VirtualFile virtualFile;
                TypeScriptConfig tsConfig;
                String moduleName;
                block16: {
                    moduleName = JSFileReferencesUtil.getNodeModuleName(refText);
                    if (!JSFileReferencesUtil.isAcceptableNodeModulesPackageName(moduleName)) {
                        return false;
                    }
                    PsiFile containingFile = psiElementForError.getContainingFile();
                    tsConfig = TypeScriptConfigUtil.getConfigForPsiFile(containingFile);
                    if (!TypeScriptCheckImportInspection.access$checkConfigIsAcceptable(this.this$0, tsConfig)) {
                        return false;
                    }
                    virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)containingFile));
                    if (virtualFile == null) {
                        return false;
                    }
                    resolveImportModules = importResolver.resolveImportModules();
                    Iterable $receiver$iv = resolveImportModules;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            if (!DialectDetector.isTypeScript(it)) continue;
                            bl = true;
                            break block16;
                        }
                        bl = false;
                    }
                }
                if (bl || resolveImportModules.size() > 1) {
                    return true;
                }
                TypeScriptConfig typeScriptConfig = tsConfig;
                if (typeScriptConfig == null || (typeScriptConfig = typeScriptConfig.getConfigFile()) == null) {
                    typeScriptConfig = virtualFile;
                }
                TypeScriptConfig contextFile = typeScriptConfig;
                VirtualFile nodeModulesDirectory = NodeModuleUtil.findUpClosestNodeModulesResolveRoot((VirtualFile)contextFile);
                VirtualFile packageJson = NodeModuleUtil.findPackageJsonByNodeModules(nodeModulesDirectory);
                if (packageJson == null) {
                    TypeScriptConfig typeScriptConfig2 = contextFile;
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeScriptConfig2, (String)"contextFile");
                    packageJson = PackageJsonUtil.findChildPackageJsonFile(typeScriptConfig2.getParent());
                }
                String string = expectedTypesName = (isNodeJSCoreModule = NodeJsCoreLibraryManager.isCoreModuleName(moduleName)) ? "@types/node" : "@types" + '/' + moduleName;
                if (!isNodeJSCoreModule) {
                    if (packageJson == null) {
                        return false;
                    }
                    PackageJsonData data = PackageJsonData.getOrCreate(packageJson);
                    if (data.isDependencyOfAnyType(expectedTypesName)) {
                        return false;
                    }
                    if (!data.isDependencyOfAnyType(moduleName)) {
                        InstallNodeModuleQuickFix.ModuleElement moduleElement = pointerBuilder.createPointer();
                        boolean reportOwnError = tsConfig != null && Intrinsics.areEqual((Object)((Object)tsConfig.getEffectiveResolution()), (Object)((Object)TypeScriptConfig.ModuleResolution.CLASSIC)) ^ true;
                        String string2 = moduleName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"moduleName");
                        NpmUsedModulesInstalledInspection.Reporter errorReporter = this.createReporter(psiElementForError, string2, !reportOwnError);
                        NpmUsedModulesInstalledInspection.reportModulesIsNotInstalledErrorWithFixes(moduleElement, CollectionsKt.listOf((Object)packageJson), false, nodeModulesDirectory, errorReporter);
                        return reportOwnError;
                    }
                    NpmUsedModulesInstalledInspection.ModuleTypingsState typingsState = NpmUsedModulesInstalledInspection.modulePackageJsonHasTypings(moduleName, nodeModulesDirectory);
                    if (Intrinsics.areEqual((Object)((Object)typingsState), (Object)((Object)NpmUsedModulesInstalledInspection.ModuleTypingsState.HAS_TYPINGS))) {
                        return false;
                    }
                    if (Intrinsics.areEqual((Object)((Object)typingsState), (Object)((Object)NpmUsedModulesInstalledInspection.ModuleTypingsState.MODULE_DIRECTORY_NOT_EXIST))) {
                        InstallNodeModuleQuickFix.ModuleElement moduleElement = pointerBuilder.createPointer();
                        String string3 = moduleName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"moduleName");
                        NpmUsedModulesInstalledInspection.Reporter errorReporter = this.createReporter(psiElementForError, string3, false);
                        NpmUsedModulesInstalledInspection.reportModulesIsNotInstalledErrorWithFixes(moduleElement, CollectionsKt.listOf((Object)packageJson), true, nodeModulesDirectory, errorReporter);
                        return true;
                    }
                }
                String string4 = moduleName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"moduleName");
                if (StringsKt.startsWith$default((String)string4, (String)"@", (boolean)false, (int)2, null)) {
                    return false;
                }
                InstallNodeModuleQuickFix.ModuleElement moduleElement = pointerBuilder.createPointer();
                InstallNodeModuleQuickFix.ModuleElement moduleElementWrapper2 = new InstallNodeModuleQuickFix.ModuleElement(moduleElement, moduleName, expectedTypesName){
                    final /* synthetic */ InstallNodeModuleQuickFix.ModuleElement $moduleElement;
                    final /* synthetic */ String $moduleName;
                    final /* synthetic */ String $expectedTypesName;

                    @Nullable
                    public final String getModuleName() {
                        return Intrinsics.areEqual((Object)this.$moduleElement.getModuleName(), (Object)this.$moduleName) ? this.$expectedTypesName : null;
                    }
                    {
                        this.$moduleElement = moduleElement;
                        this.$moduleName = string;
                        this.$expectedTypesName = string2;
                    }
                };
                this.registerErrorWithFixes(packageJson, moduleElementWrapper2, psiElementForError, moduleName, resolveImportModules);
                return true;
            }

            private final NpmUsedModulesInstalledInspection.Reporter createReporter(PsiElement psiElementForError, String moduleName, boolean infoOnly) {
                return new NpmUsedModulesInstalledInspection.Reporter(this, psiElementForError, moduleName, infoOnly){
                    final /* synthetic */ createVisitor.1 this$0;
                    final /* synthetic */ PsiElement $psiElementForError;
                    final /* synthetic */ String $moduleName;
                    final /* synthetic */ boolean $infoOnly;

                    /*
                     * WARNING - void declaration
                     */
                    public final void reportError(@NotNull String text, @NotNull List<LocalQuickFix> fixes) {
                        LocalQuickFix[] localQuickFixArray;
                        void $receiver$iv;
                        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                        Intrinsics.checkParameterIsNotNull(fixes, (String)"fixes");
                        TextRange range = TypeScriptCheckImportInspection.access$getRangeForError(this.this$0.this$0, this.$psiElementForError, this.$moduleName);
                        Collection collection = fixes;
                        TextRange textRange = range;
                        ProblemHighlightType problemHighlightType = this.$infoOnly ? ProblemHighlightType.INFORMATION : createVisitor.1.access$getProblemHighlightType(this.this$0);
                        String string = text;
                        PsiElement psiElement = this.$psiElementForError;
                        ProblemsHolder problemsHolder = this.this$0.$holder;
                        void thisCollection$iv = $receiver$iv;
                        LocalQuickFix[] localQuickFixArray2 = thisCollection$iv.toArray(new LocalQuickFix[0]);
                        if (localQuickFixArray2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        LocalQuickFix[] localQuickFixArray3 = localQuickFixArray = localQuickFixArray2;
                        problemsHolder.registerProblem(psiElement, string, problemHighlightType, textRange, Arrays.copyOf(localQuickFixArray3, localQuickFixArray3.length));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$psiElementForError = psiElement;
                        this.$moduleName = string;
                        this.$infoOnly = bl;
                    }
                };
            }

            private final void registerErrorWithFixes(VirtualFile packageJson, InstallNodeModuleQuickFix.ModuleElement moduleElementWrapper2, PsiElement psiElementForError, String moduleName, Collection<? extends PsiElement> resolveImportModules) {
                InstallNodeModuleQuickFix fix = packageJson == null ? new InstallNodeModuleQuickFix(moduleElementWrapper2, CollectionsKt.emptyList()) : (InstallNodeModuleQuickFix)new InstallNodeModuleAddToDevDependenciesQuickFix(moduleElementWrapper2, CollectionsKt.listOf((Object)packageJson));
                TextRange range = TypeScriptCheckImportInspection.access$getRangeForError(this.this$0, psiElementForError, moduleName);
                Collection<? extends PsiElement> collection = resolveImportModules;
                ProblemHighlightType defaultHighlight = !collection.isEmpty() ? ProblemHighlightType.INFORMATION : this.getProblemHighlightType();
                this.$holder.registerProblem(psiElementForError, JSBundle.message((String)"typescript.types.module.not.installed.warning", (Object[])new Object[]{moduleName}), defaultHighlight, range, new LocalQuickFix[]{fix});
            }

            private final ProblemHighlightType getProblemHighlightType() {
                return this.$isServiceEnabled ? ProblemHighlightType.INFORMATION : ProblemHighlightType.ERROR;
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
                this.$isServiceEnabled = $captured_local_variable$2;
            }

            @NotNull
            public static final /* synthetic */ ProblemHighlightType access$getProblemHighlightType(createVisitor.1 $this) {
                return $this.getProblemHighlightType();
            }
        };
    }

    private final TextRange getRangeForError(PsiElement psiElementForError, String moduleName) {
        int indexOfModuleName = StringUtil.indexOf((CharSequence)psiElementForError.getText(), (CharSequence)moduleName);
        return new TextRange(indexOfModuleName, indexOfModuleName + moduleName.length());
    }

    private final boolean isFileAcceptable(PsiFile file2) {
        return DialectDetector.isTypeScript((PsiElement)file2);
    }

    private final boolean checkConfigIsAcceptable(TypeScriptConfig tsConfig) {
        if (tsConfig == null) {
            return true;
        }
        return Intrinsics.areEqual((Object)((Object)tsConfig.getEffectiveResolution()), (Object)((Object)TypeScriptConfig.ModuleResolution.CLASSIC)) ^ true;
    }

    public static final /* synthetic */ boolean access$checkConfigIsAcceptable(TypeScriptCheckImportInspection $this, @Nullable TypeScriptConfig tsConfig) {
        return $this.checkConfigIsAcceptable(tsConfig);
    }

    @NotNull
    public static final /* synthetic */ TextRange access$getRangeForError(TypeScriptCheckImportInspection $this, @NotNull PsiElement psiElementForError, @NotNull String moduleName) {
        return $this.getRangeForError(psiElementForError, moduleName);
    }
}

