/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.fixes.ES6ConvertDefaultImportToSpecifierFix;
import com.intellij.lang.javascript.validation.fixes.ES6ConvertSpecifierToDefaultFix;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\"\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0004J\"\u0010\"\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0004\u00a8\u0006#"}, d2={"Lcom/intellij/lang/javascript/modules/ES6CheckImportInspection;", "Lcom/intellij/lang/javascript/inspections/JSInspection;", "()V", "addSpecifierError", "", "node", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportExportSpecifier;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "elementForError", "Lcom/intellij/psi/PsiElement;", "name", "", "problemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "createVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "getDefaultLevel", "Lcom/intellij/codeHighlighting/HighlightDisplayLevel;", "getFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "importExportPart", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportExportDeclarationPart;", "(Lcom/intellij/lang/ecmascript6/psi/ES6ImportExportDeclarationPart;)[Lcom/intellij/codeInspection/LocalQuickFix;", "isUnresolvedFromPart", "", "fromClause", "Lcom/intellij/lang/ecmascript6/psi/ES6FromClause;", "visitES6ImportedBindingImpl", "importedBinding", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportedBinding;", "visitSpecifierImpl", "intellij.javascript.impl"})
public class ES6CheckImportInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return (PsiElementVisitor)new JSElementVisitor(this, holder){
            final /* synthetic */ ES6CheckImportInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitES6ImportedBinding(@NotNull ES6ImportedBinding importedBinding) {
                Intrinsics.checkParameterIsNotNull((Object)importedBinding, (String)"importedBinding");
                if (!DialectDetector.isES6((PsiElement)importedBinding)) {
                    return;
                }
                ES6CheckImportInspection.visitES6ImportedBindingImpl$default(this.this$0, importedBinding, this.$holder, null, 4, null);
            }

            public void visitES6ImportExportSpecifier(@NotNull ES6ImportExportSpecifier specifier) {
                Intrinsics.checkParameterIsNotNull((Object)specifier, (String)"specifier");
                if (!DialectDetector.isES6((PsiElement)specifier)) {
                    return;
                }
                ES6CheckImportInspection.visitSpecifierImpl$default(this.this$0, this.$holder, specifier, null, 4, null);
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        Intrinsics.checkExpressionValueIsNotNull((Object)highlightDisplayLevel, (String)"HighlightDisplayLevel.WEAK_WARNING");
        return highlightDisplayLevel;
    }

    protected final void visitES6ImportedBindingImpl(@NotNull ES6ImportedBinding importedBinding, @NotNull ProblemsHolder holder, @NotNull ProblemHighlightType problemHighlightType) {
        Intrinsics.checkParameterIsNotNull((Object)importedBinding, (String)"importedBinding");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)problemHighlightType, (String)"problemHighlightType");
        if (importedBinding.isNamespaceImport()) {
            return;
        }
        ES6ImportDeclaration parent = importedBinding.getDeclaration();
        if (parent != null) {
            ES6FromClause fromClause;
            Collection referencedElements = importedBinding.findReferencedElements();
            DialectOptionHolder dialectHolder = DialectDetector.dialectOfElement((PsiElement)importedBinding);
            if (dialectHolder != null && !dialectHolder.isTypeScript) {
                referencedElements = ContainerUtil.filter((Collection)referencedElements, JSAnnotatingVisitor.NOT_TYPESCRIPT_EXPORT_CONDITION);
            }
            if ((fromClause = parent.getFromClause()) != null && referencedElements.isEmpty()) {
                Collection modules = fromClause.resolveReferencedElements();
                PsiElement module = (PsiElement)ContainerUtil.getFirstItem((Collection)modules);
                if (modules.size() == 1 && module instanceof JSFile && Intrinsics.areEqual((Object)((JSFile)module).getModuleStatus(), (Object)JSFile.ModuleStatus.ES6)) {
                    PsiElement psiElement = importedBinding.getNameIdentifier();
                    if (psiElement == null) {
                        psiElement = (PsiElement)importedBinding;
                    }
                    PsiElement elementForError = psiElement;
                    LocalQuickFix[] localQuickFixArray = this.getFixes((ES6ImportExportDeclarationPart)importedBinding);
                    holder.registerProblem(elementForError, JSBundle.message((String)"es6.default.export.not.declared", (Object[])new Object[0]), problemHighlightType, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                }
            }
        }
    }

    public static /* bridge */ /* synthetic */ void visitES6ImportedBindingImpl$default(ES6CheckImportInspection eS6CheckImportInspection, ES6ImportedBinding eS6ImportedBinding, ProblemsHolder problemsHolder, ProblemHighlightType problemHighlightType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: visitES6ImportedBindingImpl");
        }
        if ((n & 4) != 0) {
            problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        }
        eS6CheckImportInspection.visitES6ImportedBindingImpl(eS6ImportedBinding, problemsHolder, problemHighlightType);
    }

    protected final void visitSpecifierImpl(@NotNull ProblemsHolder holder, @NotNull ES6ImportExportSpecifier node, @NotNull ProblemHighlightType problemHighlightType) {
        ES6FromClause fromClause;
        ES6ImportExportDeclaration declaration;
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)problemHighlightType, (String)"problemHighlightType");
        ES6ImportExportDeclaration eS6ImportExportDeclaration = declaration = node.getDeclaration();
        Object object = fromClause = eS6ImportExportDeclaration != null ? eS6ImportExportDeclaration.getFromClause() : null;
        if (fromClause == null || this.isUnresolvedFromPart(fromClause)) {
            return;
        }
        ResolveResult[] results = node.multiResolve(false);
        PsiElement psiElement = node.getReferenceNameElement();
        if (psiElement == null) {
            psiElement = (PsiElement)node;
        }
        PsiElement elementForError = psiElement;
        Intrinsics.checkExpressionValueIsNotNull((Object)results, (String)"results");
        Object[] objectArray = results;
        if (objectArray.length == 0) {
            this.addSpecifierError(node, holder, elementForError, node.getReferenceName(), problemHighlightType);
        } else {
            List<PsiElement> elements;
            List<PsiElement> list = elements = JSResolveResult.toElements(results);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"elements");
            Collection collection = list;
            if (!collection.isEmpty()) {
                return;
            }
            for (ResolveResult result2 : results) {
                String resolveProblemKey;
                if (!(result2 instanceof JSResolveResult) || (resolveProblemKey = ((JSResolveResult)result2).getResolveProblemKey()) == null) continue;
                LocalQuickFix[] localQuickFixArray = this.getFixes((ES6ImportExportDeclarationPart)node);
                holder.registerProblem(elementForError, JSBundle.message((String)resolveProblemKey, (Object[])new Object[0]), problemHighlightType, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                return;
            }
            this.addSpecifierError(node, holder, elementForError, node.getReferenceName(), problemHighlightType);
        }
    }

    public static /* bridge */ /* synthetic */ void visitSpecifierImpl$default(ES6CheckImportInspection eS6CheckImportInspection, ProblemsHolder problemsHolder, ES6ImportExportSpecifier eS6ImportExportSpecifier, ProblemHighlightType problemHighlightType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: visitSpecifierImpl");
        }
        if ((n & 4) != 0) {
            problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        }
        eS6CheckImportInspection.visitSpecifierImpl(problemsHolder, eS6ImportExportSpecifier, problemHighlightType);
    }

    private final boolean isUnresolvedFromPart(ES6FromClause fromClause) {
        String string = StringUtil.unquoteString((String)StringUtil.notNullize((String)fromClause.getReferenceText()));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"unquoteString(notNullize\u2026romClause.referenceText))");
        CharSequence charSequence = string;
        return charSequence.length() > 0 && fromClause.resolveReferencedElements().isEmpty();
    }

    private final void addSpecifierError(ES6ImportExportSpecifier node, ProblemsHolder holder, PsiElement elementForError, String name, ProblemHighlightType problemHighlightType) {
        LocalQuickFix[] localQuickFixArray = this.getFixes((ES6ImportExportDeclarationPart)node);
        holder.registerProblem(elementForError, JSBundle.message((String)"es6.validate.import.error", (Object[])new Object[]{name}), problemHighlightType, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
    }

    private final LocalQuickFix[] getFixes(ES6ImportExportDeclarationPart importExportPart) {
        LocalQuickFix[] localQuickFixArray;
        LocalQuickFixAndIntentionActionOnPsiElement fix = null;
        if (importExportPart instanceof ES6ImportSpecifier) {
            fix = new ES6ConvertSpecifierToDefaultFix((ES6ImportSpecifier)importExportPart);
        } else if (importExportPart instanceof ES6ImportedBinding) {
            fix = new ES6ConvertDefaultImportToSpecifierFix((ES6ImportedBinding)importExportPart);
        }
        if (fix == null) {
            return new LocalQuickFix[0];
        }
        if (fix.isAvailable(importExportPart.getProject(), null, importExportPart.getContainingFile())) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = (LocalQuickFix)fix;
        } else {
            localQuickFixArray = new LocalQuickFix[]{};
        }
        return localQuickFixArray;
    }
}

