/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.modules.ImportCommonJSModuleFix;
import com.intellij.lang.javascript.modules.ImportJSModuleBaseFix;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AddRequiredAmdModuleToModulesListFix
implements ImportJSModuleBaseFix,
LocalQuickFix,
HintAction,
HighPriorityAction {
    @NotNull
    private final JSAmdUtil.AmdLoaderCallOnPointers myAmdLoaderCallOnPointers;
    private final String myPath;
    private final String myReferenceName;
    private final boolean myIsSingleQuotes;

    public AddRequiredAmdModuleToModulesListFix(@NotNull JSAmdUtil.AmdLoaderCallOnPointers pointers, String path, String referenceName, boolean isSingleQuotes) {
        if (pointers == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(0);
        }
        this.myAmdLoaderCallOnPointers = pointers;
        this.myPath = path;
        this.myReferenceName = referenceName;
        this.myIsSingleQuotes = isSingleQuotes;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(1);
        }
        return false;
    }

    @Nls
    @NotNull
    public String getText() {
        if (this.myIsSingleQuotes) {
            String string = "Add '" + this.myPath + "' module dependency";
            if (string == null) {
                AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = "Add \"" + this.myPath + "\" module dependency";
        if (string == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(4);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(5);
        }
        this.invokeImpl();
    }

    @Override
    public String getVarName() {
        return this.myReferenceName;
    }

    private void invokeImpl() {
        JSAmdUtil.AmdLoaderCall amdLoaderCall = this.myAmdLoaderCallOnPointers.toCall();
        if (!amdLoaderCall.isValid()) {
            return;
        }
        JSArrayLiteralExpression modulesArray = amdLoaderCall.getModulesArray();
        JSFunctionExpression callback = amdLoaderCall.getCallBackExpression();
        Project project = callback.getProject();
        String q = this.myIsSingleQuotes ? "'" : "\"";
        PsiFile arrayFile = ImportCommonJSModuleFix.createDummyFile(project, "[" + q + this.myPath + q + "]");
        PsiElement comma = AddRequiredAmdModuleToModulesListFix.createComma(project);
        if (comma == null) {
            return;
        }
        if (modulesArray == null) {
            PsiElement added = callback.getParent().addBefore(comma, (PsiElement)callback);
            callback.getParent().addBefore(arrayFile.getFirstChild(), added);
        } else {
            JSParameterList parameterList = callback.getParameterList();
            if (parameterList != null && parameterList.getParameters().length > modulesArray.getExpressions().length) {
                return;
            }
            int previousParams = modulesArray.getExpressions().length - (parameterList == null ? 0 : parameterList.getParameters().length);
            PsiElement child = arrayFile.getFirstChild();
            JSArrayLiteralExpression arrayLiteralExpression = (JSArrayLiteralExpression)child.getFirstChild();
            JSExpression literal = arrayLiteralExpression.getExpressions()[0];
            if (literal == null) {
                return;
            }
            if (modulesArray.getExpressions().length == 0) {
                modulesArray.addAfter((PsiElement)literal, modulesArray.getFirstChild());
            } else {
                JSExpression[] expressions = modulesArray.getExpressions();
                PsiElement added = modulesArray.addAfter(comma, (PsiElement)expressions[expressions.length - 1]);
                modulesArray.addAfter((PsiElement)literal, added);
            }
            if (previousParams > 0) {
                ParameterNamesGenerator generator = new ParameterNamesGenerator(parameterList == null ? JSParameter.EMPTY_ARRAY : parameterList.getParameterVariables());
                for (int i = 0; i < previousParams; ++i) {
                    this.addNewParameter(callback, generator.generate());
                }
            }
        }
        this.addNewParameter(callback, this.myReferenceName);
        DaemonCodeAnalyzer.getInstance((Project)callback.getProject()).restart(callback.getContainingFile());
    }

    private void addNewParameter(JSFunctionExpression callback, @NotNull String name) {
        if (name == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(6);
        }
        JSParameterList list = callback.getParameterList();
        PsiFile file2 = ImportCommonJSModuleFix.createDummyFile(callback.getProject(), "function(" + name + "){}");
        JSParameter parameter = (JSParameter)PsiTreeUtil.findChildOfType((PsiElement)file2, JSParameter.class);
        if (parameter == null) {
            return;
        }
        if (list.getParameters().length == 0) {
            list.addAfter((PsiElement)parameter, list.getFirstChild());
        } else {
            PsiElement comma = AddRequiredAmdModuleToModulesListFix.createComma(callback.getProject());
            if (comma == null) {
                return;
            }
            JSParameterListElement[] parameters = list.getParameters();
            PsiElement added = list.addAfter(comma, (PsiElement)parameters[parameters.length - 1]);
            list.addAfter((PsiElement)parameter, added);
        }
    }

    private static PsiElement createComma(Project project) {
        PsiElement[] children;
        PsiFile file2 = ImportCommonJSModuleFix.createDummyFile(project, ",");
        for (PsiElement child : children = file2.getChildren()) {
            if (!(child instanceof LeafPsiElement) || !",".equals(child.getText())) continue;
            return child;
        }
        return null;
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = AddRequiredAmdModuleToModulesListFix.class.getSimpleName();
        if (string == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Node.js" == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(8);
        }
        return "Node.js";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(9);
        }
        if (descriptor2 == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(10);
        }
        this.invokeImpl();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/AddRequiredAmdModuleToModulesListFix";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/AddRequiredAmdModuleToModulesListFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addNewParameter";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ParameterNamesGenerator {
        private final Set<String> myAlreadyUsed = new HashSet<String>();
        private int myCnt = 1;

        public ParameterNamesGenerator(JSParameter[] parameters) {
            for (JSParameter parameter : parameters) {
                this.myAlreadyUsed.add(parameter.getName());
            }
        }

        public String generate() {
            String current;
            while (this.myAlreadyUsed.contains(current = "mod" + this.myCnt++)) {
            }
            return current;
        }
    }
}

