/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.importer;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.linter.eslint.importer.EslintRulesImporter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.BeforeAfter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class EslintRuleMapper {
    private static final Set<String> TURNED_ON = ContainerUtil.set((Object[])new String[]{"warn", "error"});
    @NonNls
    private static final String ALWAYS = "always";
    @NonNls
    private static final String NEVER = "never";
    protected static final String BEFORE = "before";
    protected static final String AFTER = "after";
    private final String myName;

    protected EslintRuleMapper(String name) {
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }

    protected abstract EslintRulesImporter.SettingsConvertor create(@Nullable List<JsonValue> var1);

    public EslintRulesImporter.SettingsConvertor parseSettings(@NotNull JsonValue element) {
        JsonArray asArray;
        if (element == null) {
            EslintRuleMapper.$$$reportNull$$$0(0);
        }
        JsonLiteral literal = (JsonLiteral)ObjectUtils.tryCast((Object)element, JsonLiteral.class);
        List optionsList = null;
        if (literal == null && (asArray = (JsonArray)ObjectUtils.tryCast((Object)element, JsonArray.class)) != null && !asArray.getValueList().isEmpty()) {
            List list = asArray.getValueList();
            literal = (JsonLiteral)ObjectUtils.tryCast(list.get(0), JsonLiteral.class);
            optionsList = list.subList(1, list.size());
        }
        if (literal == null) {
            return EslintRulesImporter.MISCONFIGURATION;
        }
        RuleState severity = EslintRuleMapper.parseRuleSeverity(literal);
        if (!RuleState.ok.equals((Object)severity)) {
            return new EslintRulesImporter.SettingsConvertor(severity);
        }
        return this.create(optionsList);
    }

    @Nullable
    protected Boolean getAlwaysNeverOption(@Nullable List<JsonValue> values, boolean defaultValue) {
        if (values != null && !values.isEmpty()) {
            return this.readValueAsStringWithTwoVariants(values.get(0), ALWAYS, NEVER);
        }
        return defaultValue;
    }

    @Nullable
    protected Boolean getAlwaysNeverOption(@Nullable JsonProperty value, boolean defaultValue) {
        if (value != null) {
            return this.readValueAsStringWithTwoVariants(value.getValue(), ALWAYS, NEVER);
        }
        return defaultValue;
    }

    protected Boolean readValueAsStringWithTwoVariants(@Nullable JsonValue value, @NotNull String trueStr, @NotNull String falseStr) {
        JsonStringLiteral literal;
        if (trueStr == null) {
            EslintRuleMapper.$$$reportNull$$$0(1);
        }
        if (falseStr == null) {
            EslintRuleMapper.$$$reportNull$$$0(2);
        }
        if ((literal = (JsonStringLiteral)ObjectUtils.tryCast((Object)value, JsonStringLiteral.class)) != null) {
            String text = StringUtil.unquoteString((String)literal.getValue());
            if (trueStr.equals(text)) {
                return true;
            }
            if (falseStr.equals(text)) {
                return false;
            }
        }
        return null;
    }

    @NotNull
    private static RuleState parseRuleSeverity(@NotNull JsonLiteral asLiteral) {
        if (asLiteral == null) {
            EslintRuleMapper.$$$reportNull$$$0(3);
        }
        if (asLiteral.isQuotedString()) {
            String text = StringUtil.unquoteString((String)asLiteral.getText());
            if ("off".equals(text)) {
                RuleState ruleState = RuleState.off;
                if (ruleState == null) {
                    EslintRuleMapper.$$$reportNull$$$0(4);
                }
                return ruleState;
            }
            if (TURNED_ON.contains(text)) {
                RuleState ruleState = RuleState.ok;
                if (ruleState == null) {
                    EslintRuleMapper.$$$reportNull$$$0(5);
                }
                return ruleState;
            }
            RuleState ruleState = RuleState.misconfiguration;
            if (ruleState == null) {
                EslintRuleMapper.$$$reportNull$$$0(6);
            }
            return ruleState;
        }
        Integer value = EslintRuleMapper.getInteger((JsonValue)asLiteral);
        if (value == null) {
            RuleState ruleState = RuleState.misconfiguration;
            if (ruleState == null) {
                EslintRuleMapper.$$$reportNull$$$0(7);
            }
            return ruleState;
        }
        if (value == 0) {
            RuleState ruleState = RuleState.off;
            if (ruleState == null) {
                EslintRuleMapper.$$$reportNull$$$0(8);
            }
            return ruleState;
        }
        if (value == 1 || value == 2) {
            RuleState ruleState = RuleState.ok;
            if (ruleState == null) {
                EslintRuleMapper.$$$reportNull$$$0(9);
            }
            return ruleState;
        }
        RuleState ruleState = RuleState.misconfiguration;
        if (ruleState == null) {
            EslintRuleMapper.$$$reportNull$$$0(10);
        }
        return ruleState;
    }

    protected static Integer getInteger(@NotNull JsonValue value) {
        JsonNumberLiteral number;
        if (value == null) {
            EslintRuleMapper.$$$reportNull$$$0(11);
        }
        if ((number = (JsonNumberLiteral)ObjectUtils.tryCast((Object)value, JsonNumberLiteral.class)) != null) {
            try {
                return Integer.parseInt(number.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    protected Boolean getArrayLineBreakRulesOption(@Nullable List<JsonValue> values) {
        Boolean isOn = this.getAlwaysNeverOption(values, true);
        if (isOn == null && values != null && values.size() > 0) {
            Integer num;
            JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
            if (object == null) {
                return null;
            }
            JsonProperty minItems = object.findProperty("minItems");
            if (minItems != null && minItems.getValue() != null && (num = EslintRuleMapper.getInteger(minItems.getValue())) != null && num == 0) {
                return true;
            }
        }
        return isOn;
    }

    @Nullable
    protected static Boolean getBooleanOptionValue(@NotNull JsonObject object, @NotNull String name, boolean defaultValue) {
        JsonProperty property;
        if (object == null) {
            EslintRuleMapper.$$$reportNull$$$0(12);
        }
        if (name == null) {
            EslintRuleMapper.$$$reportNull$$$0(13);
        }
        if ((property = object.findProperty(name)) == null) {
            return defaultValue;
        }
        JsonBooleanLiteral booleanValue = (JsonBooleanLiteral)ObjectUtils.tryCast((Object)property.getValue(), JsonBooleanLiteral.class);
        if (booleanValue == null) {
            return null;
        }
        return booleanValue.getValue();
    }

    @Nullable
    protected static BeforeAfter<Boolean> getBeforeAfter(@Nullable List<JsonValue> values, boolean beforeDefault, boolean afterDefault) {
        if (values != null && !values.isEmpty()) {
            JsonObject config2 = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
            if (config2 == null) {
                return null;
            }
            return EslintRuleMapper.getBeforeAfter(config2, beforeDefault, afterDefault);
        }
        return new BeforeAfter((Object)beforeDefault, (Object)afterDefault);
    }

    @Nullable
    protected static BeforeAfter<Boolean> getBeforeAfter(@NotNull JsonObject config2, boolean beforeDefault, boolean afterDefault) {
        if (config2 == null) {
            EslintRuleMapper.$$$reportNull$$$0(14);
        }
        Boolean isBefore = EslintRuleMapper.getBooleanOptionValue(config2, BEFORE, beforeDefault);
        Boolean isAfter = EslintRuleMapper.getBooleanOptionValue(config2, AFTER, afterDefault);
        if (isBefore == null || isAfter == null) {
            return null;
        }
        return new BeforeAfter((Object)isBefore, (Object)isAfter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trueStr";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "falseStr";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asLiteral";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintRuleMapper";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintRuleMapper";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRuleSeverity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseSettings";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readValueAsStringWithTwoVariants";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseRuleSeverity";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getInteger";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBooleanOptionValue";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getBeforeAfter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum RuleState {
        off,
        misconfiguration,
        skipped,
        sameSettings,
        ok;

    }
}

