/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintState
implements JSNpmLinterState<EslintState> {
    public static final EslintState DEFAULT = new Builder().build();
    private final NodeJsInterpreterRef myInterpreterRef;
    private final String myEslintPackagePath;
    private final boolean myCustomConfigFileUsed;
    private final String myCustomConfigFilePath;
    private final String myAdditionalRulesDirPath;
    private final String myExtraOptions;
    private final Set<String> myPluginsFromExtraOptions;

    public EslintState(@NotNull Builder builder) {
        if (builder == null) {
            EslintState.$$$reportNull$$$0(0);
        }
        this.myInterpreterRef = builder.myInterpreterRef;
        this.myEslintPackagePath = builder.myEslintPackagePath;
        this.myCustomConfigFileUsed = builder.myCustomConfigFileUsed;
        this.myCustomConfigFilePath = builder.myCustomConfigFilePath;
        this.myAdditionalRulesDirPath = builder.myAdditionalRulesDirPath;
        this.myExtraOptions = builder.myExtraOptions;
        this.myPluginsFromExtraOptions = EslintState.parsePlugins(this.myExtraOptions);
    }

    @Nullable
    private static HashSet<String> parsePlugins(@Nullable String extraOptions) {
        if (extraOptions == null) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        List words = StringUtil.split((String)extraOptions, (String)" ");
        boolean isPlugin = false;
        for (String word : words) {
            if ("--plugin".equals(word)) {
                isPlugin = true;
                continue;
            }
            if (!isPlugin) continue;
            set.add(word);
            isPlugin = false;
        }
        return set;
    }

    public boolean hasPluginInExtraOptions(@NotNull String plugin) {
        if (plugin == null) {
            EslintState.$$$reportNull$$$0(1);
        }
        return this.myPluginsFromExtraOptions != null && this.myPluginsFromExtraOptions.contains(plugin);
    }

    @Override
    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            EslintState.$$$reportNull$$$0(2);
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public String getEslintPackagePath() {
        String string = this.myEslintPackagePath;
        if (string == null) {
            EslintState.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isCustomConfigFileUsed() {
        return this.myCustomConfigFileUsed;
    }

    @NotNull
    public String getCustomConfigFilePath() {
        String string = this.myCustomConfigFilePath;
        if (string == null) {
            EslintState.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getAdditionalRulesDirPath() {
        String string = this.myAdditionalRulesDirPath;
        if (string == null) {
            EslintState.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getExtraOptions() {
        String string = this.myExtraOptions;
        if (string == null) {
            EslintState.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @Nullable
    public String getLinterPackagePath() {
        return this.myEslintPackagePath;
    }

    @Override
    public EslintState withLinterPackagePath(@NotNull String path) {
        if (path == null) {
            EslintState.$$$reportNull$$$0(7);
        }
        return new EslintState(new Builder(this).setEslintPackagePath(path));
    }

    @Override
    public EslintState withInterpreterRef(NodeJsInterpreterRef ref) {
        return new EslintState(new Builder(this).setInterpreterRef(ref));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EslintState state = (EslintState)o;
        return this.myCustomConfigFileUsed == state.myCustomConfigFileUsed && this.myCustomConfigFilePath.equals(state.myCustomConfigFilePath) && this.myEslintPackagePath.equals(state.myEslintPackagePath) && this.myInterpreterRef.getReferenceName().equals(state.myInterpreterRef.getReferenceName()) && this.myAdditionalRulesDirPath.equals(state.myAdditionalRulesDirPath) && this.myExtraOptions.equals(state.myExtraOptions);
    }

    public int hashCode() {
        int result2 = this.myInterpreterRef.getReferenceName().hashCode();
        result2 = 31 * result2 + this.myEslintPackagePath.hashCode();
        result2 = 31 * result2 + (this.myCustomConfigFileUsed ? 1 : 0);
        result2 = 31 * result2 + this.myCustomConfigFilePath.hashCode();
        result2 = 31 * result2 + this.myAdditionalRulesDirPath.hashCode();
        result2 = 31 * result2 + this.myExtraOptions.hashCode();
        return result2;
    }

    public String toString() {
        return "node=" + this.myInterpreterRef.getReferenceName() + ", eslint=" + this.myEslintPackagePath + ", isCustomConfig=" + this.myCustomConfigFileUsed + ", customConfig=" + this.myCustomConfigFilePath + ", rulesDir='" + this.myAdditionalRulesDirPath + ", extraOptions='" + this.myExtraOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintState";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRef";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEslintPackagePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomConfigFilePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalRulesDirPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasPluginInExtraOptions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withLinterPackagePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        private NodeJsInterpreterRef myInterpreterRef;
        private String myEslintPackagePath;
        private boolean myCustomConfigFileUsed;
        private String myCustomConfigFilePath;
        private String myAdditionalRulesDirPath;
        private String myExtraOptions;

        public Builder() {
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myEslintPackagePath = "";
            this.myCustomConfigFileUsed = false;
            this.myCustomConfigFilePath = "";
            this.myAdditionalRulesDirPath = "";
            this.myExtraOptions = "";
        }

        public Builder(@NotNull EslintState state) {
            if (state == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myEslintPackagePath = "";
            this.myCustomConfigFileUsed = false;
            this.myCustomConfigFilePath = "";
            this.myAdditionalRulesDirPath = "";
            this.myExtraOptions = "";
            this.myInterpreterRef = state.getInterpreterRef();
            this.myEslintPackagePath = state.getEslintPackagePath();
            this.myCustomConfigFileUsed = state.isCustomConfigFileUsed();
            this.myCustomConfigFilePath = state.getCustomConfigFilePath();
            this.myAdditionalRulesDirPath = state.getAdditionalRulesDirPath();
            this.myExtraOptions = state.getExtraOptions();
        }

        @NotNull
        public Builder setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
            if (interpreterRef == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myInterpreterRef = interpreterRef;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder setEslintPackagePath(@NotNull String eslintPackagePath) {
            if (eslintPackagePath == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myEslintPackagePath = eslintPackagePath;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder setCustomConfigFileUsed(boolean customConfigFileUsed) {
            this.myCustomConfigFileUsed = customConfigFileUsed;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        @NotNull
        public Builder setCustomConfigFilePath(@NotNull String customConfigFilePath) {
            if (customConfigFilePath == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myCustomConfigFilePath = customConfigFilePath;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder;
        }

        @NotNull
        public Builder setAdditionalRulesDirPath(@NotNull String additionalRulesDirPath) {
            if (additionalRulesDirPath == null) {
                Builder.$$$reportNull$$$0(8);
            }
            this.myAdditionalRulesDirPath = additionalRulesDirPath;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder;
        }

        @NotNull
        public Builder setExtraOptions(@NotNull String extraOptions) {
            if (extraOptions == null) {
                Builder.$$$reportNull$$$0(10);
            }
            this.myExtraOptions = extraOptions;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(11);
            }
            return builder;
        }

        @NotNull
        public EslintState build() {
            EslintState eslintState = new EslintState(this);
            if (eslintState == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return eslintState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreterRef";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintState$Builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintPackagePath";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "customConfigFilePath";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "additionalRulesDirPath";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extraOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintState$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setInterpreterRef";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setEslintPackagePath";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCustomConfigFileUsed";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCustomConfigFilePath";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setAdditionalRulesDirPath";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setExtraOptions";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setInterpreterRef";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 12: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setEslintPackagePath";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setCustomConfigFilePath";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setAdditionalRulesDirPath";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "setExtraOptions";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

