/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.google.common.base.Joiner;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ExternalAnnotatorInspectionVisitor;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.PairedUnfairLocalInspectionTool;
import com.intellij.ide.DataManager;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.linter.JSLinterWithInspectionExternalAnnotator;
import com.intellij.lang.javascript.linter.UntypedJSLinterConfigurable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLinterInspection
extends JSInspection
implements PairedUnfairLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(JSLinterInspection.class);

    @NotNull
    protected abstract JSLinterWithInspectionExternalAnnotator getExternalAnnotatorForBatchInspection();

    @NotNull
    public String getInspectionForBatchShortName() {
        String string = this.getShortName();
        if (string == null) {
            JSLinterInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(ProblemsHolder holder, LocalInspectionToolSession session) {
        ExternalAnnotatorInspectionVisitor externalAnnotatorInspectionVisitor = new ExternalAnnotatorInspectionVisitor(holder, (ExternalAnnotator)this.getExternalAnnotatorForBatchInspection(), this.myOnTheFly);
        if (externalAnnotatorInspectionVisitor == null) {
            JSLinterInspection.$$$reportNull$$$0(1);
        }
        return externalAnnotatorInspectionVisitor;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = JSBundle.message((String)"js.linters.inspection.group.name", (Object[])new Object[0]);
        if (string == null) {
            JSLinterInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        HyperlinkLabel settingsLink = this.createHyperLink();
        panel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        panel.add((Component)settingsLink);
        return panel;
    }

    protected void ensureServiceStopped(@NotNull Project project) {
        if (project == null) {
            JSLinterInspection.$$$reportNull$$$0(3);
        }
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    @NotNull
    private HyperlinkLabel createHyperLink() {
        List<String> path = this.getSettingsPath();
        String title = Joiner.on((String)" / ").join(path);
        final HyperlinkLabel settingsLink = new HyperlinkLabel(title);
        settingsLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            public void hyperlinkActivated(HyperlinkEvent e) {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)settingsLink);
                Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                if (project == null) {
                    LOG.warn("No project found in data context");
                    return;
                }
                UntypedJSLinterConfigurable configurable = JSLinterInspection.this.getExternalAnnotatorForBatchInspection().createSettingsConfigurable(project);
                Settings settings = (Settings)Settings.KEY.getData(dataContext);
                if (settings == null) {
                    configurable.showEditDialog();
                    return;
                }
                settings.select(settings.find(configurable.getId()));
            }
        });
        HyperlinkLabel hyperlinkLabel = settingsLink;
        if (hyperlinkLabel == null) {
            JSLinterInspection.$$$reportNull$$$0(4);
        }
        return hyperlinkLabel;
    }

    @NotNull
    protected List<String> getSettingsPath() {
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new String[]{JSBundle.message((String)"settings.javascript.root.configurable.name", (Object[])new Object[0]), JSBundle.message((String)"settings.javascript.linters.configurable.name", (Object[])new Object[0]), this.getDisplayName()});
        if (arrayList == null) {
            JSLinterInspection.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    static void ensureInspectionServiceStopped(@NotNull Project project, @NotNull Class<? extends JSLinterInspection> inspectionClass) {
        String id;
        InspectionProjectProfileManager manager;
        InspectionProfileImpl inspectionProfile;
        InspectionToolWrapper tool;
        if (project == null) {
            JSLinterInspection.$$$reportNull$$$0(6);
        }
        if (inspectionClass == null) {
            JSLinterInspection.$$$reportNull$$$0(7);
        }
        if ((tool = (inspectionProfile = (manager = InspectionProjectProfileManager.getInstance((Project)project)).getCurrentProfile()).getInspectionTool(id = JSInspection.calcShortNameFromClass(inspectionClass), project)) != null) {
            ((JSLinterInspection)tool.getTool()).ensureServiceStopped(project);
        }
    }

    public static boolean isToolEnabled(@NotNull Project project, @NotNull Class<? extends JSLinterInspection> inspectionClass, @Nullable PsiFile file2) {
        if (project == null) {
            JSLinterInspection.$$$reportNull$$$0(8);
        }
        if (inspectionClass == null) {
            JSLinterInspection.$$$reportNull$$$0(9);
        }
        InspectionProjectProfileManager manager = InspectionProjectProfileManager.getInstance((Project)project);
        InspectionProfileImpl inspectionProfile = manager.getCurrentProfile();
        HighlightDisplayKey key = JSLinterInspection.getHighlightDisplayKeyByClass(inspectionClass);
        return inspectionProfile.isToolEnabled(key, (PsiElement)file2);
    }

    public static void setToolEnabled(@NotNull Project project, @NotNull Class<? extends JSLinterInspection> inspectionClass, boolean enabled) {
        if (project == null) {
            JSLinterInspection.$$$reportNull$$$0(10);
        }
        if (inspectionClass == null) {
            JSLinterInspection.$$$reportNull$$$0(11);
        }
        HighlightDisplayKey key = JSLinterInspection.getHighlightDisplayKeyByClass(inspectionClass);
        InspectionProfileManager.getInstance((Project)project).getCurrentProfile().setToolEnabled(key.toString(), enabled);
    }

    @NotNull
    public static HighlightDisplayKey getHighlightDisplayKeyByClass(@NotNull Class<? extends JSLinterInspection> inspectionClass) {
        String id;
        HighlightDisplayKey key;
        if (inspectionClass == null) {
            JSLinterInspection.$$$reportNull$$$0(12);
        }
        if ((key = HighlightDisplayKey.find((String)(id = JSInspection.calcShortNameFromClass(inspectionClass)))) == null) {
            key = new HighlightDisplayKey(id, id);
        }
        HighlightDisplayKey highlightDisplayKey = key;
        if (highlightDisplayKey == null) {
            JSLinterInspection.$$$reportNull$$$0(13);
        }
        return highlightDisplayKey;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterInspection";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionForBatchShortName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createHyperLink";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightDisplayKeyByClass";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "ensureServiceStopped";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "ensureInspectionServiceStopped";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isToolEnabled";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setToolEnabled";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightDisplayKeyByClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

