/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.stat;

import com.intellij.internal.statistic.AbstractProjectsUsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSLibraryUsagesCollector
extends AbstractProjectsUsagesCollector {
    public static final String GROUP_ID = "javaScript Frameworks";

    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) {
        if (project == null) {
            JSLibraryUsagesCollector.$$$reportNull$$$0(0);
        }
        HashSet<String> libTypes = new HashSet<String>();
        ScriptingLibraryManager libraryManager = (ScriptingLibraryManager)ServiceManager.getService((Project)project, JSLibraryManager.class);
        if (libraryManager != null) {
            ScriptingLibraryModel[] libModels = libraryManager.getAllLibraries();
            for (ScriptingLibraryModel libModel : libModels) {
                ScriptingFrameworkDescriptor frameworkDescriptor;
                if (libModel == null || (frameworkDescriptor = libModel.getFrameworkDescriptor()) == null || !JSLibraryUsagesCollector.isInProject(libModel, project)) continue;
                libTypes.add(frameworkDescriptor.toString());
            }
        }
        HashSet<UsageDescriptor> descriptors = new HashSet<UsageDescriptor>();
        for (String libType : libTypes) {
            descriptors.add(new UsageDescriptor(libType, 1));
        }
        HashSet<UsageDescriptor> hashSet = descriptors;
        if (hashSet == null) {
            JSLibraryUsagesCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private static boolean isInProject(ScriptingLibraryModel libraryModel, Project project) {
        JSLibraryMappings mappings = (JSLibraryMappings)((Object)ServiceManager.getService((Project)project, JSLibraryMappings.class));
        return mappings != null && mappings.containsLibrary(libraryModel);
    }

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)GROUP_ID);
        if (groupDescriptor == null) {
            JSLibraryUsagesCollector.$$$reportNull$$$0(2);
        }
        return groupDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/stat/JSLibraryUsagesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/stat/JSLibraryUsagesCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectUsages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProjectUsages";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

