/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.intentions.ES6ConvertToTemplateStringHelper;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStringConcatenationToES6TemplateHelper {
    @NotNull
    static String unquoteUnescapeEscape(@NotNull JSLiteralExpression element) {
        if (element == null) {
            JSStringConcatenationToES6TemplateHelper.$$$reportNull$$$0(0);
        }
        String string = JSStringUtil.unquoteAndUnescapeStringLiteralValue(element.getText());
        StringBuilder result2 = new StringBuilder();
        JSStringUtil.escapeSimpleStringChars(string, '`', false, true, true, result2);
        String string2 = result2.toString();
        if (string2 == null) {
            JSStringConcatenationToES6TemplateHelper.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Nullable
    public static PsiElement findSuitableExpression(@NotNull PsiElement element) {
        List<JSExpression> list;
        if (element == null) {
            JSStringConcatenationToES6TemplateHelper.$$$reportNull$$$0(2);
        }
        if ((list = JSStringConcatenationToES6TemplateHelper.findExpressionsList(element)) == null) {
            PsiLanguageInjectionHost host = InjectedLanguageUtil.findInjectionHost((PsiElement)element);
            if (host != null) {
                list = JSStringConcatenationToES6TemplateHelper.findExpressionsList((PsiElement)host);
            }
            if (list == null) {
                return JSStringConcatenationToES6TemplateHelper.tryLiteralVariant(element);
            }
        }
        Collections.reverse(list);
        for (JSExpression expression : list) {
            ES6ConvertToTemplateStringHelper helper = new ES6ConvertToTemplateStringHelper(expression);
            helper.process();
            if (!helper.isValid()) continue;
            return JSStringConcatenationToES6TemplateHelper.replaceStringWithTemplate((PsiElement)expression, helper.convert());
        }
        return JSStringConcatenationToES6TemplateHelper.tryLiteralVariant(element);
    }

    @Nullable
    private static PsiElement tryLiteralVariant(@NotNull PsiElement element) {
        if (element == null) {
            JSStringConcatenationToES6TemplateHelper.$$$reportNull$$$0(3);
        }
        if (element instanceof JSLiteralExpression && ((JSLiteralExpression)element).isQuotedLiteral()) {
            return JSStringConcatenationToES6TemplateHelper.replaceStringWithTemplate((JSLiteralExpression)element);
        }
        if (element instanceof LeafPsiElement && ((LeafPsiElement)element).getElementType() == JSTokenTypes.STRING_LITERAL && element.getParent() instanceof JSLiteralExpression) {
            return JSStringConcatenationToES6TemplateHelper.replaceStringWithTemplate((JSLiteralExpression)element.getParent());
        }
        return null;
    }

    @Nullable
    public static List<JSExpression> findExpressionsList(@NotNull PsiElement element) {
        if (element == null) {
            JSStringConcatenationToES6TemplateHelper.$$$reportNull$$$0(4);
        }
        return JSStringConcatenationToES6TemplateHelper.findExpressionListImpl(element, true);
    }

    @Nullable
    private static List<JSExpression> findExpressionListImpl(@NotNull PsiElement element, boolean adjustElement) {
        if (element == null) {
            JSStringConcatenationToES6TemplateHelper.$$$reportNull$$$0(5);
        }
        ArrayList<JSExpression> list = new ArrayList<JSExpression>();
        JSExpression previous = null;
        while (true) {
            JSExpression parent;
            if ((parent = (JSExpression)PsiTreeUtil.findFirstParent((PsiElement)(previous == null ? element : previous.getParent()), JSBinaryExpression.class::isInstance)) == null) break;
            list.add(parent);
            previous = parent;
        }
        if (previous == null) {
            if (adjustElement) {
                return JSStringConcatenationToES6TemplateHelper.findExpressionListImpl(JSBaseIntroduceHandler.adjustElement(element.getTextRange().getStartOffset(), element), false);
            }
            return null;
        }
        return list;
    }

    static PsiElement replaceStringWithTemplate(@NotNull JSLiteralExpression element) {
        if (element == null) {
            JSStringConcatenationToES6TemplateHelper.$$$reportNull$$$0(6);
        }
        return JSStringConcatenationToES6TemplateHelper.replaceStringWithTemplate((PsiElement)element, "`" + JSStringConcatenationToES6TemplateHelper.unquoteUnescapeEscape(element) + "`");
    }

    static PsiElement replaceStringWithTemplate(@NotNull PsiElement element, @NotNull String text) {
        if (element == null) {
            JSStringConcatenationToES6TemplateHelper.$$$reportNull$$$0(7);
        }
        if (text == null) {
            JSStringConcatenationToES6TemplateHelper.$$$reportNull$$$0(8);
        }
        Language dialect = JSStringConcatenationToES6TemplateHelper.getLanguage(element);
        PsiFile dummy = PsiFileFactory.getInstance((Project)element.getProject()).createFileFromText(dialect, (CharSequence)text);
        return element.replace(PsiTreeUtil.findChildOfType((PsiElement)dummy, JSLiteralExpression.class));
    }

    private static Language getLanguage(@NotNull PsiElement element) {
        JSLanguageDialect dialect;
        if (element == null) {
            JSStringConcatenationToES6TemplateHelper.$$$reportNull$$$0(9);
        }
        if ((dialect = DialectDetector.getLanguageDialect(element)) != null) {
            return dialect;
        }
        return JavascriptLanguage.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateHelper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteUnescapeEscape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unquoteUnescapeEscape";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableExpression";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tryLiteralVariant";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findExpressionsList";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findExpressionListImpl";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceStringWithTemplate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

