/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.generation.JSGetterSetterGenerationMode;
import com.intellij.lang.javascript.generation.JSNamedElementNode;
import com.intellij.lang.javascript.generation.JavaScriptGenerateAccessorHandler;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSVarStatementBase;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSCreateAccessorIntentionBase
extends PsiElementBaseIntentionAction {
    public JSCreateAccessorIntentionBase() {
        this.setText(this.getDescription());
    }

    protected abstract String getDescription();

    protected abstract String getMessageKey();

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            JSCreateAccessorIntentionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        String varName;
        PsiLanguageInjectionHost context;
        PsiElement parentParent;
        PsiFile containingFile;
        if (project == null) {
            JSCreateAccessorIntentionBase.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JSCreateAccessorIntentionBase.$$$reportNull$$$0(2);
        }
        if (!((containingFile = element.getContainingFile()) instanceof JSFile)) {
            return false;
        }
        DialectOptionHolder dialectOfElement = DialectDetector.dialectOfFile(containingFile);
        if (dialectOfElement == null || dialectOfElement.isECMA4 && !this.isAvailableForECMA4()) {
            return false;
        }
        if (DialectOptionHolder.ECMA_6.equals((Object)dialectOfElement) && this.tryConstructorPropertyVariant(element) != null) {
            return true;
        }
        JSVariable variable = JSCreateAccessorIntentionBase.getVariable(element);
        if (variable != null && variable.isConst()) {
            return false;
        }
        PsiElement parent = variable == null ? null : variable.getParent();
        PsiElement psiElement = parentParent = parent instanceof JSVarStatement ? parent.getParent() : null;
        if (parentParent instanceof ES6Class && parent instanceof JSVarStatementBase) {
            return false;
        }
        if (parentParent instanceof TypeScriptEnum) {
            return false;
        }
        PsiLanguageInjectionHost psiLanguageInjectionHost = context = parentParent == null ? null : InjectedLanguageManager.getInstance((Project)parentParent.getProject()).getInjectionHost(parentParent);
        JSClass jsClass = parentParent instanceof JSClass ? (JSClass)parentParent : (parentParent instanceof JSFile && context instanceof XmlText ? XmlBackedJSClassImpl.getContainingComponent((XmlElement)((XmlText)context)) : null);
        String string = varName = variable == null ? null : variable.getName();
        if (jsClass != null && StringUtil.isNotEmpty((String)varName)) {
            this.setText(JSBundle.message((String)this.getMessageKey(), (Object[])new Object[]{varName}));
            String accessorName = JSRefactoringUtil.transformVarNameToAccessorName(varName, project);
            return this.isAvailableFor(jsClass, accessorName);
        }
        return false;
    }

    private JSDefinitionExpression tryConstructorPropertyVariant(@NotNull PsiElement element) {
        JSFunction constructor;
        JSReferenceExpression reference;
        if (element == null) {
            JSCreateAccessorIntentionBase.$$$reportNull$$$0(3);
        }
        if (element.getParent() instanceof JSReferenceExpression && (reference = (JSReferenceExpression)element.getParent()).getQualifier() != null && "this".equals(reference.getQualifier().getText()) && (constructor = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)reference, JSFunction.class)) != null && "constructor".equals(constructor.getName()) && reference.getParent() instanceof JSDefinitionExpression && constructor.getParent() instanceof ES6Class) {
            String varName = reference.getReferenceName();
            this.setText(JSBundle.message((String)this.getMessageKey(), (Object[])new Object[]{varName}));
            String accessorName = JSRefactoringUtil.transformVarNameToAccessorName(varName, element.getProject());
            return this.isAvailableFor((JSClass)((ES6Class)constructor.getParent()), accessorName) ? (JSDefinitionExpression)reference.getParent() : null;
        }
        return null;
    }

    @Nullable
    private static JSVariable getVariable(PsiElement element) {
        PsiElement var = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSVariable.class, JSVarStatement.class});
        if (var instanceof JSVariable) {
            return (JSVariable)var;
        }
        if (var instanceof JSVarStatement) {
            JSVariable[] variables = ((JSVarStatement)var).getVariables();
            return variables.length == 1 ? variables[0] : null;
        }
        return null;
    }

    protected abstract boolean isAvailableFor(JSClass var1, String var2);

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiFile file2;
        PsiElement jsClass;
        if (project == null) {
            JSCreateAccessorIntentionBase.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JSCreateAccessorIntentionBase.$$$reportNull$$$0(5);
        }
        if ((jsClass = BaseJSGenerateHandler.findClassOrObjectLiteral(file2 = element.getContainingFile(), editor, null)) == null) {
            return;
        }
        final Ref node = new Ref();
        JavaScriptGenerateAccessorHandler handler = new JavaScriptGenerateAccessorHandler(this.getGenerationMode(), true){

            @Override
            protected void collectCandidates(PsiElement clazz, Collection<JSChooserElementNode> candidates) {
                ContainerUtil.addIfNotNull(candidates, (Object)node.get());
            }
        };
        JSVariable variable = JSCreateAccessorIntentionBase.getVariable(element);
        if (variable == null) {
            JSDefinitionExpression expression;
            if (DialectOptionHolder.ECMA_6.equals((Object)DialectDetector.dialectOfFile(element.getContainingFile())) && (expression = this.tryConstructorPropertyVariant(element)) != null) {
                node.set((Object)new JSNamedElementNode((JSPsiNamedElementBase)expression));
            }
        } else {
            node.set((Object)new JSNamedElementNode((JSPsiNamedElementBase)variable));
        }
        handler.invoke(project, editor, file2);
    }

    protected boolean isAvailableForECMA4() {
        return false;
    }

    protected abstract JSGetterSetterGenerationMode getGenerationMode();

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSCreateAccessorIntentionBase";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSCreateAccessorIntentionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tryConstructorPropertyVariant";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

