/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSSharedUsageInformation;
import com.intellij.lang.javascript.inspections.JSUnusedGlobalDeclarationsCache;
import com.intellij.lang.javascript.inspections.JSUnusedLocalSymbolsInspection;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSNamedElementKind;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUnusedGlobalSymbolsInspection
extends JSInspection {
    private static final AtomicLong ourInvocationCounter = new AtomicLong(0L);
    private static final Key<ParameterizedCachedValue<Pair<Long, PsiElement>, Long>> CACHED_VALUE_KEY = Key.create((String)"JavaScript.Unused.Global>symbol.Inspection.Key");
    private static final Logger LOG = Logger.getInstance(JSUnusedGlobalSymbolsInspection.class);
    public boolean myReportUnusedDefinitions;
    public boolean myReportUnusedProperties;
    private static final ImplicitUsageProvider[] myExtensions = (ImplicitUsageProvider[])Extensions.getExtensions((ExtensionPointName)ImplicitUsageProvider.EP_NAME);
    private final HashSet<JSNamedElement> myRecheck = new HashSet();

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.unused.global.symbol.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(2);
        }
        Consumer reporter = element -> {
            if (holder == null) {
                JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(23);
            }
            JSUnusedGlobalSymbolsInspection.registerProblem(element, holder);
        };
        if (holder.isOnTheFly() && Registry.is((String)"javascript.unused.global.declarations.cached", (boolean)false)) {
            MyReadingCacheVisitor myReadingCacheVisitor = new MyReadingCacheVisitor(session.getFile(), (Consumer<PsiElement>)reporter, this.myReportUnusedDefinitions, this.myReportUnusedProperties, this.myRecheck);
            if (myReadingCacheVisitor == null) {
                JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(3);
            }
            return myReadingCacheVisitor;
        }
        MyJSElementVisitor myJSElementVisitor = new MyJSElementVisitor(session.getFile(), (Consumer<PsiElement>)reporter, this.myReportUnusedDefinitions, this.myReportUnusedProperties);
        if (myJSElementVisitor == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(4);
        }
        return myJSElementVisitor;
    }

    public void inspectionStarted(@NotNull LocalInspectionToolSession session, boolean isOnTheFly) {
        if (session == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(5);
        }
        super.inspectionStarted(session, isOnTheFly);
        if (Registry.is((String)"javascript.unused.global.declarations.cached", (boolean)false)) {
            JSUnusedGlobalDeclarationsCache.getInstance(session.getFile().getProject()).restartFile(session.getFile().getVirtualFile());
        }
        this.myRecheck.clear();
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder holder) {
        if (session == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(7);
        }
        if (Registry.is((String)"javascript.unused.global.declarations.cached", (boolean)false)) {
            JSUnusedGlobalDeclarationsCache cache = JSUnusedGlobalDeclarationsCache.getInstance(session.getFile().getProject());
            try {
                Set<PsiElement> elements = cache.getUnusedDeclarationsFuture(session.getFile().getVirtualFile()).get();
                this.myRecheck.forEach(element -> {
                    if (holder == null) {
                        JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(22);
                    }
                    if (elements.contains(element)) {
                        JSUnusedGlobalSymbolsInspection.registerProblem((PsiElement)element, holder);
                    }
                });
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        super.inspectionFinished(session, holder);
    }

    public static void registerProblem(PsiElement element, @NotNull ProblemsHolder holder) {
        PsiElement nameIdentifier;
        if (holder == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(8);
        }
        JSNamedElementKind namedElementKind = JSNamedElementKind.kind(element, false);
        String name = "";
        TextRange textRange = null;
        if (element instanceof JSNamedElement) {
            name = ((JSNamedElement)element).getName();
            nameIdentifier = ((JSNamedElement)element).getNameIdentifier();
        } else {
            nameIdentifier = element;
            if (nameIdentifier instanceof ES6ExportDefaultAssignment) {
                textRange = JSUnusedGlobalSymbolsInspection.exportDefaultHighlightRangeCorrection(element);
            }
        }
        if (nameIdentifier == null) {
            return;
        }
        FixAndIntentionAction fix = JSFixFactory.getInstance().removeElementLocalQuickFix(namedElementKind, name);
        fix.registerElementRefForFix(nameIdentifier, null);
        LocalQuickFix[] fixes = new LocalQuickFix[]{fix};
        String message = JSUnusedLocalSymbolsInspection.unusedMessage(namedElementKind);
        if (JSNamedElementKind.ES6_DEFAULT_EXPORT.equals((Object)namedElementKind) || JSNamedElementKind.ES6_EXPORT_SPECIFIER.equals((Object)namedElementKind)) {
            message = message.replace("#ref", "");
        }
        holder.registerProblem(nameIdentifier, message, ProblemHighlightType.LIKE_UNUSED_SYMBOL, textRange, fixes);
    }

    private static TextRange exportDefaultHighlightRangeCorrection(@NotNull PsiElement element) {
        if (element == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(9);
        }
        ASTNode node = element.getNode();
        ASTNode exportNode = node.findChildByType(JSTokenTypes.EXPORT_KEYWORD);
        ASTNode defaultNode = node.findChildByType(JSTokenTypes.DEFAULT_KEYWORD);
        if (exportNode != null && defaultNode != null && exportNode.getStartOffset() < defaultNode.getStartOffset()) {
            return new TextRange(exportNode.getPsi().getStartOffsetInParent(), defaultNode.getPsi().getStartOffsetInParent() + defaultNode.getTextLength());
        }
        return null;
    }

    public static boolean calcUnused(PsiElement element, SearchScope scope) {
        return JSUnusedGlobalSymbolsInspection.calcUnused(element, element, scope);
    }

    private static boolean calcUnused(@NotNull PsiElement element, @NotNull PsiElement ignoreUsagesAmongChildrenOfThisElement, @NotNull SearchScope scope) {
        if (element == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(10);
        }
        if (ignoreUsagesAmongChildrenOfThisElement == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(12);
        }
        for (ImplicitUsageProvider provider2 : myExtensions) {
            if (!provider2.isImplicitUsage(element)) continue;
            return false;
        }
        boolean isDefinition = element instanceof JSDefinitionExpression;
        return JSUnusedGlobalSymbolsInspection.calculateUnusedWithCaching(element, ignoreUsagesAmongChildrenOfThisElement, scope, isDefinition, true);
    }

    private static boolean calculateUnusedWithCaching(@NotNull PsiElement element, @NotNull PsiElement ignoreUsagesAmongChildrenOfThisElement, @NotNull SearchScope scope, boolean isDefinition, boolean calledFirstTime) {
        if (element == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(13);
        }
        if (ignoreUsagesAmongChildrenOfThisElement == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(15);
        }
        long currentCount = ourInvocationCounter.incrementAndGet();
        ParameterizedCachedValueProvider provider2 = count -> {
            if (element == null) {
                JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(19);
            }
            if (scope == null) {
                JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(20);
            }
            if (ignoreUsagesAmongChildrenOfThisElement == null) {
                JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(21);
            }
            Query psiReferenceQuery = ReferencesSearch.search((PsiElement)element, (SearchScope)scope, (boolean)true);
            MySearchProcessor processor = new MySearchProcessor(ignoreUsagesAmongChildrenOfThisElement, isDefinition);
            psiReferenceQuery.forEach((Processor)processor);
            PsiElement foundReference = processor.getFoundReference();
            if (foundReference != null) {
                return CachedValueProvider.Result.create((Object)Pair.create((Object)count, (Object)foundReference), (Object[])new Object[]{foundReference});
            }
            return CachedValueProvider.Result.create((Object)Pair.create((Object)count, null), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        };
        CachedValuesManager cachedManager = CachedValuesManager.getManager((Project)element.getProject());
        Pair pair = (Pair)cachedManager.getParameterizedCachedValue((UserDataHolder)ignoreUsagesAmongChildrenOfThisElement, CACHED_VALUE_KEY, provider2, false, (Object)currentCount);
        if (currentCount == (Long)pair.first) {
            return pair.second == null;
        }
        if (pair.second == null) {
            return true;
        }
        if (pair.second instanceof PsiReference && ((PsiReference)pair.second).isReferenceTo(element)) {
            return false;
        }
        element.putUserData(CACHED_VALUE_KEY, null);
        if (calledFirstTime) {
            return JSUnusedGlobalSymbolsInspection.calculateUnusedWithCaching(element, ignoreUsagesAmongChildrenOfThisElement, scope, isDefinition, false);
        }
        LOG.warn("This should not have happened.");
        return false;
    }

    private static boolean isSelfUsed(PsiElement psiElement, PsiElement ignoreUsagesAmongChildrenOfThisElement) {
        if (PsiTreeUtil.isAncestor((PsiElement)ignoreUsagesAmongChildrenOfThisElement, (PsiElement)psiElement, (boolean)false)) {
            if (ignoreUsagesAmongChildrenOfThisElement instanceof JSClass) {
                return true;
            }
            JSFunction callback = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)psiElement, JSFunction.class);
            return callback == null || !PsiTreeUtil.isAncestor((PsiElement)ignoreUsagesAmongChildrenOfThisElement, (PsiElement)callback, (boolean)true);
        }
        return false;
    }

    public static GlobalSearchScope skipLibraryFiles(final @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(16);
        }
        if (scope == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(17);
        }
        return new DelegatingGlobalSearchScope(scope){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!super.contains(file2)) {
                    return false;
                }
                return !JSLibraryUtil.isProbableLibraryFile(file2, project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$1", "contains"));
            }
        };
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(JSBundle.message((String)"javascript.report.unused.properties", (Object[])new Object[0]), "myReportUnusedProperties");
        optionsPanel.addCheckbox(JSBundle.message((String)"javascript.report.unused.definitions", (Object[])new Object[0]), "myReportUnusedDefinitions");
        return optionsPanel;
    }

    private static boolean isLocalFunctionExpression(@NotNull JSFunctionExpression node) {
        PsiElement parent;
        if (node == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(18);
        }
        return (parent = node.getParent()) instanceof JSProperty || parent instanceof JSVariable || parent instanceof JSAssignmentExpression || parent instanceof JSCallExpression || parent instanceof JSArgumentList || parent instanceof JSReturnStatement || parent instanceof JSParenthesizedExpression && parent.getParent() instanceof JSCallExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreUsagesAmongChildrenOfThisElement";
                break;
            }
            case 12: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inspectionStarted";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "inspectionFinished";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "exportDefaultHighlightRangeCorrection";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calcUnused";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "calculateUnusedWithCaching";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "skipLibraryFiles";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isLocalFunctionExpression";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$calculateUnusedWithCaching$2";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$inspectionFinished$1";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createVisitor$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySearchProcessor
    implements Processor<PsiReference> {
        private final PsiElement myIgnoreUsagesAmongChildrenOfThisElement;
        private final boolean myDef;
        private final AtomicReference<PsiElement> myRef = new AtomicReference();

        public MySearchProcessor(PsiElement ignoreUsagesAmongChildrenOfThisElement, boolean def) {
            this.myIgnoreUsagesAmongChildrenOfThisElement = ignoreUsagesAmongChildrenOfThisElement;
            this.myDef = def;
        }

        public boolean process(PsiReference psiReference) {
            PsiElement parent;
            PsiElement psiElement = psiReference.getElement();
            if (JSResolveUtil.isSelfReference(psiElement) || JSUnusedGlobalSymbolsInspection.isSelfUsed(psiElement, this.myIgnoreUsagesAmongChildrenOfThisElement)) {
                return true;
            }
            if (this.myDef && (parent = psiElement.getParent()) instanceof JSDefinitionExpression) {
                return true;
            }
            this.myRef.set(psiElement);
            return false;
        }

        public PsiElement getFoundReference() {
            return this.myRef.get();
        }
    }

    private static class MyReadingCacheVisitor
    extends MyJSElementVisitor {
        private final JSUnusedGlobalDeclarationsCache myCache;
        @NotNull
        private final Set<JSNamedElement> myToRecheck;

        public MyReadingCacheVisitor(@NotNull PsiFile file2, @NotNull Consumer<PsiElement> consumer, boolean reportUnusedDefintions, boolean reportUnusedProperties, @NotNull Set<JSNamedElement> toRecheck) {
            if (file2 == null) {
                MyReadingCacheVisitor.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                MyReadingCacheVisitor.$$$reportNull$$$0(1);
            }
            if (toRecheck == null) {
                MyReadingCacheVisitor.$$$reportNull$$$0(2);
            }
            super(file2, consumer, reportUnusedDefintions, reportUnusedProperties);
            this.myCache = JSUnusedGlobalDeclarationsCache.getInstance(file2.getProject());
            this.myToRecheck = toRecheck;
        }

        @Override
        protected void checkUnused(JSNamedElement namedElement) {
            PsiFile psiFile = namedElement.getContainingFile();
            try {
                Future<Set<PsiElement>> future = this.myCache.getUnusedDeclarationsFuture(psiFile.getVirtualFile());
                if (future.isDone()) {
                    Set<PsiElement> set = future.get();
                    if (set.contains(namedElement)) {
                        this.myConsumer.consume((Object)namedElement);
                    }
                } else {
                    this.myToRecheck.add(namedElement);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                this.myToRecheck.add(namedElement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "toRecheck";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$MyReadingCacheVisitor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyJSElementVisitor
    extends JSElementVisitor {
        @NotNull
        private final PsiFile myFile;
        ProgressIndicator progress;
        @NotNull
        protected final Consumer<PsiElement> myConsumer;
        private final boolean myReportUnusedDefinitions;
        private final boolean myReportUnusedProperties;

        public MyJSElementVisitor(@NotNull PsiFile file2, @NotNull Consumer<PsiElement> consumer, boolean reportUnusedDefintions, boolean reportUnusedProperties) {
            if (file2 == null) {
                MyJSElementVisitor.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                MyJSElementVisitor.$$$reportNull$$$0(1);
            }
            this.myFile = file2;
            this.myConsumer = consumer;
            this.myReportUnusedDefinitions = reportUnusedDefintions;
            this.myReportUnusedProperties = reportUnusedProperties;
            this.progress = ProgressManager.getInstance().getProgressIndicator();
        }

        public void visitJSReferenceExpression(JSReferenceExpression node) {
            if (!JSResolveUtil.isSelfReference((PsiElement)node) || !(node.getParent() instanceof JSNamedElement)) {
                return;
            }
            JSNamedElement parent = (JSNamedElement)node.getParent();
            if (parent instanceof JSFunctionExpression || parent instanceof JSClassExpression) {
                return;
            }
            this.checkUnused(parent);
        }

        public void visitES6ExportDefaultAssignment(ES6ExportDefaultAssignment node) {
            boolean unused;
            if (node.getExpression() != null && (unused = this.isExportedElementUnused((PsiElement)node, node.getExpression().getText(), (PsiElement)node))) {
                this.myConsumer.consume((Object)node);
            }
        }

        private boolean isExportedElementUnused(@NotNull PsiElement node, String text, @NotNull PsiElement ignoreUsagesInside) {
            Project project;
            GlobalSearchScope scopeForSearch;
            if (node == null) {
                MyJSElementVisitor.$$$reportNull$$$0(2);
            }
            if (ignoreUsagesInside == null) {
                MyJSElementVisitor.$$$reportNull$$$0(3);
            }
            if ((scopeForSearch = MyJSElementVisitor.getScopeForSearch(node, project = node.getProject(), true)) == null || text == null || node.getContainingFile() == null) {
                return false;
            }
            if (this.notCheap(node.getContainingFile(), text, project, scopeForSearch)) {
                return false;
            }
            return JSUnusedGlobalSymbolsInspection.calcUnused(node, ignoreUsagesInside, (SearchScope)scopeForSearch);
        }

        public void visitES6ExportDeclaration(ES6ExportDeclaration exportDeclaration) {
            ES6ExportedDefaultBinding binding = exportDeclaration.getExportedDefaultBinding();
            if (binding != null && this.isExportedElementUnused((PsiElement)exportDeclaration, binding.getText(), (PsiElement)binding)) {
                this.myConsumer.consume((Object)binding);
            }
            ES6ExportSpecifier[] specifiers = exportDeclaration.getExportSpecifiers();
            Arrays.stream(specifiers).forEach(specifier -> {
                ES6ExportSpecifierAlias alias = specifier.getAlias();
                if (alias != null) {
                    if ("default".equals(alias.getName())) {
                        if (this.isExportedElementUnused((PsiElement)specifier, "default", (PsiElement)specifier)) {
                            this.myConsumer.consume(specifier);
                        }
                    } else if (this.isExportedElementUnused((PsiElement)alias, alias.getName(), (PsiElement)specifier)) {
                        this.myConsumer.consume(specifier);
                    }
                    return;
                }
                ResolveResult[] results = specifier.multiResolve(false);
                Arrays.stream(results).filter(result2 -> result2.isValidResult() && result2.getElement() != null).forEach(result2 -> {
                    if (this.isExportedElementUnused(result2.getElement(), specifier.getReferenceName(), (PsiElement)specifier)) {
                        this.myConsumer.consume(specifier);
                    }
                });
            });
        }

        public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
            if (node == null) {
                MyJSElementVisitor.$$$reportNull$$$0(4);
            }
            if (JSUnusedGlobalSymbolsInspection.isLocalFunctionExpression(node)) {
                return;
            }
            this.checkUnused((JSNamedElement)node);
        }

        public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
            if (node == null) {
                MyJSElementVisitor.$$$reportNull$$$0(5);
            }
            this.checkUnused((JSNamedElement)node);
        }

        public void visitJSVariable(JSVariable node) {
            PsiElement nameIdentifier = node.getNameIdentifier();
            if (!(nameIdentifier instanceof JSReferenceExpression)) {
                this.checkUnused((JSNamedElement)node);
            }
        }

        public void visitJSDefinitionExpression(JSDefinitionExpression node) {
            JSExpression expression = node.getExpression();
            if (expression instanceof JSReferenceExpression) {
                JSExpression qualifier = ((JSReferenceExpression)expression).getQualifier();
                boolean doCheck = this.myReportUnusedDefinitions;
                if (qualifier instanceof JSThisExpression || qualifier instanceof JSReferenceExpression && "prototype".equals(((JSReferenceExpression)qualifier).getReferencedName())) {
                    doCheck = true;
                }
                if (!doCheck) {
                    return;
                }
                PsiElement parent = node.getParent();
                if (parent instanceof JSAssignmentExpression) {
                    PsiElement resolve;
                    JSReferenceExpression refExpr = (JSReferenceExpression)expression;
                    JSExpression rOperand = ((JSAssignmentExpression)parent).getROperand();
                    if (rOperand != null && ((resolve = refExpr.resolve()) == node || resolve == rOperand)) {
                        this.checkUnused((JSNamedElement)node);
                    }
                }
            }
        }

        public void visitJSProperty(JSProperty node) {
            Collection<JSFunctionWithSubstitutor> functions = JSPsiImplUtils.calculatePossibleFunctions((PsiElement)node, null);
            if (!this.myReportUnusedProperties && functions.isEmpty()) {
                return;
            }
            PsiElement nameIdentifier = node.getNameIdentifier();
            if (nameIdentifier == null || !StringUtil.isJavaIdentifier((String)nameIdentifier.getText())) {
                return;
            }
            PsiPolyVariantReference reference = node.getPropertyNameReference();
            if (reference != null) {
                ResolveResult[] results;
                for (ResolveResult result2 : results = reference.multiResolve(false)) {
                    if (!result2.isValidResult() || result2.getElement() == node) continue;
                    return;
                }
            }
            this.checkUnused((JSNamedElement)node);
        }

        protected void checkUnused(JSNamedElement namedElement) {
            Project project;
            GlobalSearchScope scopeForSearch;
            if (namedElement instanceof JSPackageStatement) {
                return;
            }
            if (namedElement instanceof JSFunction && !JSInheritanceUtil.iterateOverriddenMethodsUp((JSFunction)namedElement, (Processor<JSFunction>)CommonProcessors.alwaysFalse())) {
                return;
            }
            PsiElement elementParent = namedElement.getParent();
            if (JSResolveUtil.isConstructorFunction((PsiElement)namedElement) && elementParent instanceof JSFile && elementParent.getContext() != null) {
                return;
            }
            String name = namedElement.getName();
            if (name == null) {
                return;
            }
            if (JSUnusedLocalSymbolsInspection.isNotGloballyDefined(namedElement)) {
                return;
            }
            JSSharedUsageInformation sharedInfo = JSSharedUsageInformation.get(this.myFile);
            if (sharedInfo.isReferenced((PsiNamedElement)namedElement)) {
                return;
            }
            JSNamedElement elementToSearchUsages = namedElement;
            if (elementToSearchUsages instanceof JSFunction) {
                List implementedMethods;
                JSFunction topOverriddenMethod;
                JSFunction fun = (JSFunction)elementToSearchUsages;
                if ("toString".equals(name)) {
                    return;
                }
                if (name.length() < 3) {
                    return;
                }
                JSAttributeList attrList = fun.getAttributeList();
                if (attrList != null && attrList.hasModifier(JSAttributeList.ModifierType.OVERRIDE) && (topOverriddenMethod = JSInheritanceUtil.findTopOverriddenMethod(fun)) != null) {
                    elementToSearchUsages = topOverriddenMethod;
                }
                Collection<Object> collection = implementedMethods = fun.isConstructor() ? Collections.emptyList() : JSInheritanceUtil.findImplementedMembers((JSQualifiedNamedElement)elementToSearchUsages);
                if (!implementedMethods.isEmpty()) {
                    return;
                }
            }
            if ((scopeForSearch = MyJSElementVisitor.getScopeForSearch((PsiElement)elementToSearchUsages, project = namedElement.getProject(), false)) == null) {
                return;
            }
            if (this.notCheap(namedElement.getContainingFile(), name, project, scopeForSearch)) {
                return;
            }
            boolean unused = JSUnusedGlobalSymbolsInspection.calcUnused((PsiElement)elementToSearchUsages, (SearchScope)scopeForSearch);
            if (unused) {
                if (namedElement instanceof JSClass) {
                    JSFunction constructor = ((JSClass)namedElement).getConstructor();
                    if (constructor != null) {
                        unused = JSUnusedGlobalSymbolsInspection.calcUnused((PsiElement)constructor, (PsiElement)namedElement, (SearchScope)scopeForSearch);
                    }
                } else if (JSResolveUtil.isConstructorFunction((PsiElement)namedElement) && elementParent instanceof JSClass) {
                    unused = JSUnusedGlobalSymbolsInspection.calcUnused(elementParent, (SearchScope)scopeForSearch);
                }
            }
            if (unused) {
                this.myConsumer.consume((Object)namedElement);
            }
        }

        private boolean notCheap(@NotNull PsiFile psiFile, @NotNull String name, @NotNull Project project, @NotNull GlobalSearchScope scopeForSearch) {
            PsiSearchHelper.SearchCostResult cheapEnough;
            if (psiFile == null) {
                MyJSElementVisitor.$$$reportNull$$$0(6);
            }
            if (name == null) {
                MyJSElementVisitor.$$$reportNull$$$0(7);
            }
            if (project == null) {
                MyJSElementVisitor.$$$reportNull$$$0(8);
            }
            if (scopeForSearch == null) {
                MyJSElementVisitor.$$$reportNull$$$0(9);
            }
            return (cheapEnough = PsiSearchHelper.SERVICE.getInstance((Project)project).isCheapEnoughToSearch(name, scopeForSearch, psiFile, this.progress)) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
        }

        @Nullable
        private static GlobalSearchScope getScopeForSearch(PsiElement elementToSearchUsages, Project project, boolean expandToGlobalScope) {
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            VirtualFile file2 = elementToSearchUsages.getContainingFile().getVirtualFile();
            if (file2 == null || projectFileIndex.isInLibraryClasses(file2) || projectFileIndex.isInLibrarySource(file2) || JSLibraryUtil.isProbableLibraryFile(file2, project)) {
                return null;
            }
            SearchScope scope = elementToSearchUsages.getUseScope();
            if (!(scope instanceof GlobalSearchScope)) {
                if (expandToGlobalScope) {
                    scope = GlobalSearchScope.projectScope((Project)project);
                } else {
                    return null;
                }
            }
            if (!GlobalSearchScope.allScope((Project)project).contains(file2)) {
                return null;
            }
            return JSUnusedGlobalSymbolsInspection.skipLibraryFiles(project, (GlobalSearchScope)scope);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignoreUsagesInside";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scopeForSearch";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$MyJSElementVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isExportedElementUnused";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionDeclaration";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notCheap";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

