/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSMethodCanBeStaticInspection
extends JSInspection {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.method.can.be.static.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSMethodCanBeStaticInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){
            Condition<PsiElement>[] addins;

            public void visitJSFunctionDeclaration(final @NotNull JSFunction function) {
                TypeScriptFunction tsFunction;
                JSAttributeList classAttributeList;
                JSClass clazz;
                if (function == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((clazz = JSUtils.getMemberContainingClass((PsiElement)function)) == null) {
                    return;
                }
                if (clazz.isInterface()) {
                    return;
                }
                if (clazz.getName() == null) {
                    return;
                }
                PsiElement nameIdentifier = function.getNameIdentifier();
                if (nameIdentifier == null) {
                    return;
                }
                JSAttributeList attributeList = function.getAttributeList();
                if (attributeList == null || attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) || attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE)) {
                    return;
                }
                if (function.isConstructor() || "toString".equals(function.getName())) {
                    return;
                }
                if (!attributeList.hasModifier(JSAttributeList.ModifierType.FINAL) && attributeList.getAccessType() != JSAttributeList.AccessType.PRIVATE && (classAttributeList = clazz.getAttributeList()) != null && classAttributeList.findAttributeByName("Abstract") != null) {
                    return;
                }
                if (this.addins == null) {
                    this.addins = (Condition[])InspectionManager.CANT_BE_STATIC_EXTENSION.getExtensions();
                }
                for (JSAttributeList addin : this.addins) {
                    if (!addin.value((Object)function)) continue;
                    return;
                }
                if (JSMethodCanBeStaticInspection.hasEmptyBody(function)) {
                    return;
                }
                if (function instanceof TypeScriptFunction && (tsFunction = (TypeScriptFunction)function).hasOverloadDeclarations()) {
                    return;
                }
                final Ref dependsOnInstance = new Ref();
                function.acceptChildren((PsiElementVisitor)new JSRecursiveElementVisitor(){

                    public void visitJSThisExpression(JSThisExpression node) {
                        dependsOnInstance.set((Object)Boolean.TRUE);
                    }

                    public void visitJSSuperExpression(JSSuperExpression superExpression) {
                        dependsOnInstance.set((Object)Boolean.TRUE);
                    }

                    public void visitJSReferenceExpression(JSReferenceExpression node) {
                        if (node.getQualifier() == null && !JSResolveUtil.isSelfReference((PsiElement)node)) {
                            ResolveResult[] resolveResults = node.multiResolve(false);
                            if (resolveResults.length == 0) {
                                dependsOnInstance.set((Object)Boolean.TRUE);
                            }
                            for (ResolveResult resolveResult : resolveResults) {
                                if (!JSMethodCanBeStaticInspection.checkReferenceResolveResultDependsOnInstance(resolveResult, function)) continue;
                                dependsOnInstance.set((Object)Boolean.TRUE);
                            }
                        }
                        super.visitJSReferenceExpression(node);
                    }

                    public void visitJSFunctionExpression(JSFunctionExpression node) {
                        this.checkFunForExternals((JSFunctionBaseImpl)node);
                    }

                    private void checkFunForExternals(JSFunctionBaseImpl node) {
                        THashSet usedExternalVars = new THashSet();
                        node.addReferencedExternalNames((Set<String>)usedExternalVars);
                        if (usedExternalVars.size() > 0 || JSPsiImplUtils.isArrowFunction(node) && node.isReferencesThis()) {
                            dependsOnInstance.set((Object)Boolean.TRUE);
                        }
                    }

                    public void visitJSFunctionDeclaration(JSFunction node) {
                        this.checkFunForExternals((JSFunctionBaseImpl)node);
                    }

                    public void visitElement(PsiElement element) {
                        if (dependsOnInstance.get() != null) {
                            return;
                        }
                        super.visitElement(element);
                    }
                });
                for (ImplicitUsageProvider usageProvider : (ImplicitUsageProvider[])Extensions.getExtensions((ExtensionPointName)ImplicitUsageProvider.EP_NAME)) {
                    if (!usageProvider.isImplicitUsage((PsiElement)function)) continue;
                    return;
                }
                if (dependsOnInstance.get() == null && !JSInheritanceUtil.participatesInMemberHierarchy((JSQualifiedNamedElement)function)) {
                    LocalQuickFix[] localQuickFixArray;
                    if (holder.isOnTheFly()) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = JSFixFactory.getInstance().makeMethodStaticFix();
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    LocalQuickFix[] fixes = localQuickFixArray;
                    holder.registerProblem(nameIdentifier, JSBundle.message((String)"js.method.can.be.static", (Object[])new Object[0]), fixes);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/inspections/JSMethodCanBeStaticInspection$1", "visitJSFunctionDeclaration"));
            }
        };
        if (jSElementVisitor == null) {
            JSMethodCanBeStaticInspection.$$$reportNull$$$0(1);
        }
        return jSElementVisitor;
    }

    private static boolean hasEmptyBody(@NotNull JSFunction function) {
        if (function == null) {
            JSMethodCanBeStaticInspection.$$$reportNull$$$0(2);
        }
        boolean isEmpty = false;
        JSSourceElement[] body = function.getBody();
        if (body.length == 0) {
            isEmpty = true;
        } else if (body[0] instanceof JSBlockStatement) {
            isEmpty = body[0].getNode().findChildByType(JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS) == null;
        }
        return isEmpty;
    }

    private static boolean checkReferenceResolveResultDependsOnInstance(@NotNull ResolveResult resolveResult, @NotNull JSFunction function) {
        PsiElement resolvedMemberParent;
        JSAttributeList resolvedMemberAttrList;
        TypeScriptTypeParameterListOwner parameterOwner;
        if (resolveResult == null) {
            JSMethodCanBeStaticInspection.$$$reportNull$$$0(3);
        }
        if (function == null) {
            JSMethodCanBeStaticInspection.$$$reportNull$$$0(4);
        }
        if (!resolveResult.isValidResult()) {
            return true;
        }
        PsiElement resolve = resolveResult.getElement();
        if (resolve instanceof ImplicitJSVariableImpl && ("hostComponent".equals(((ImplicitJSVariableImpl)resolve).getName()) || "outerDocument".equals(((ImplicitJSVariableImpl)resolve).getName()))) {
            return true;
        }
        if (resolve instanceof TypeScriptTypeParameter && (parameterOwner = ((TypeScriptTypeParameter)resolve).getOwner()) instanceof TypeScriptClass) {
            return true;
        }
        return resolve instanceof JSAttributeListOwner && !(resolve instanceof JSClass) ? (resolvedMemberAttrList = ((JSAttributeListOwner)resolve).getAttributeList()) != null && !resolvedMemberAttrList.hasModifier(JSAttributeList.ModifierType.STATIC) && !JSResolveUtil.isConstructorFunction(resolve) && resolve != function && (resolvedMemberParent = JSResolveUtil.findParent(resolve)) instanceof JSClass : resolve instanceof JSImplicitElement && ((JSImplicitElement)resolve).getType() == JSImplicitElement.Type.Tag;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSMethodCanBeStaticInspection";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSMethodCanBeStaticInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasEmptyBody";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkReferenceResolveResultDependsOnInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

