/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLastCommaInArrayLiteralInspection
extends JSInspection {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.last.comma.in.array.literal.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSLastCommaInArrayLiteralInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSArrayLiteralExpression(JSArrayLiteralExpression node) {
                if (DialectDetector.isTypeScript((PsiElement)node) || DialectDetector.isES6((PsiElement)node)) {
                    return;
                }
                PsiElement child = JSLastCommaInArrayLiteralInspection.findErrorNode(node);
                if (child != null) {
                    JSPrefixExpression prefixExpr;
                    if (!DialectDetector.isActionScript((PsiElement)node) && (prefixExpr = (JSPrefixExpression)ObjectUtils.tryCast((Object)node.getParent(), JSPrefixExpression.class)) != null && prefixExpr.getOperationSign() == JSTokenTypes.MINUS) {
                        return;
                    }
                    holder.registerProblem(child, JSBundle.message((String)"javascript.validation.message.unneeded.comma", (Object[])new Object[0]), new LocalQuickFix[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.validation.message.remove.unneeded.comma.fix", child.getNode())});
                }
            }
        };
        if (jSElementVisitor == null) {
            JSLastCommaInArrayLiteralInspection.$$$reportNull$$$0(1);
        }
        return jSElementVisitor;
    }

    @Nullable
    public static PsiElement findErrorNode(@NotNull JSArrayLiteralExpression node) {
        ASTNode childNode;
        PsiElement lastChild;
        PsiElement child;
        if (node == null) {
            JSLastCommaInArrayLiteralInspection.$$$reportNull$$$0(2);
        }
        PsiElement psiElement = child = (lastChild = node.getLastChild()) != null ? lastChild.getPrevSibling() : null;
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment) {
            child = child.getPrevSibling();
        }
        if (child != null && (childNode = child.getNode()) != null && childNode.getElementType() == JSTokenTypes.COMMA) {
            return child;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSLastCommaInArrayLiteralInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSLastCommaInArrayLiteralInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findErrorNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

