/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSArrowFunctionBracesCanBeRemovedInspection
extends JSInspection
implements ES6CoolRefactoring,
CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSFunctionExpression(JSFunctionExpression functionExpression) {
                ASTNode redundantNode;
                if (!ES6CoolRefactoring.isEs6Compatible((PsiElement)functionExpression) || !JSPsiImplUtils.isArrowFunction((JSFunction)functionExpression)) {
                    return;
                }
                JSBlockStatement body = JSArrowFunctionBracesCanBeRemovedInspection.getBlockBody(functionExpression);
                JSElement statement = JSArrowFunctionBracesCanBeRemovedInspection.getSingleStatement(body);
                JSElement expression = JSArrowFunctionBracesCanBeRemovedInspection.getExpressionFromStatement((PsiElement)statement);
                if (body == null || statement == null || expression == null) {
                    return;
                }
                ASTNode aSTNode = redundantNode = statement instanceof JSReturnStatement ? statement.getNode().findChildByType(JSTokenTypes.RETURN_KEYWORD) : body.getNode().findChildByType(JSTokenTypes.LBRACE);
                if (redundantNode == null) {
                    return;
                }
                ConvertToShorthandFix fix = new ConvertToShorthandFix((PsiElement)functionExpression);
                String description = JSBundle.message((String)"js.arrow.function.braces.can.be.removed.problem.description", (Object[])new Object[0]);
                int functionStartOffset = functionExpression.getTextRange().getStartOffset();
                TextRange redundantRange = TextRange.from((int)(redundantNode.getStartOffset() - functionStartOffset), (int)redundantNode.getTextLength());
                holder.registerProblem((PsiElement)functionExpression, description, ProblemHighlightType.LIKE_UNUSED_SYMBOL, redundantRange, new LocalQuickFix[]{fix});
                if (holder.isOnTheFly()) {
                    TextRange infoRange = TextRange.from((int)0, (int)(redundantNode.getTextRange().getEndOffset() - functionStartOffset));
                    holder.registerProblem((PsiElement)functionExpression, description, ProblemHighlightType.INFORMATION, infoRange, new LocalQuickFix[]{fix});
                }
            }
        };
        if (jSElementVisitor == null) {
            JSArrowFunctionBracesCanBeRemovedInspection.$$$reportNull$$$0(0);
        }
        return jSElementVisitor;
    }

    private static void invoke(@NotNull JSFunctionExpression arrowFunction) throws IncorrectOperationException {
        JSElement replacement;
        boolean shouldPlaceResultOnNewLine;
        if (arrowFunction == null) {
            JSArrowFunctionBracesCanBeRemovedInspection.$$$reportNull$$$0(1);
        }
        JSBlockStatement body = JSArrowFunctionBracesCanBeRemovedInspection.getBlockBody(arrowFunction);
        JSElement statement = JSArrowFunctionBracesCanBeRemovedInspection.getSingleStatement(body);
        JSElement expression = JSArrowFunctionBracesCanBeRemovedInspection.getExpressionFromStatement((PsiElement)statement);
        if (body == null || statement == null || expression == null) {
            return;
        }
        boolean bl = shouldPlaceResultOnNewLine = expression.textContains('\n') && !(expression instanceof JSObjectLiteralExpression);
        if (expression instanceof JSObjectLiteralExpression) {
            JSExpressionStatement replacementStatement = JSChangeUtil.createStatementPsiFromTextWithContext("(" + expression.getText() + ");", (PsiElement)expression, JSExpressionStatement.class);
            if (replacementStatement == null) {
                return;
            }
            replacement = replacementStatement.getExpression();
        } else {
            replacement = expression;
        }
        if (replacement == null) {
            return;
        }
        JSElement replaced = JSChangeUtil.replaceElement((JSElement)body, replacement);
        if (shouldPlaceResultOnNewLine) {
            JSChangeUtil.addWs(replaced.getParent().getNode(), replaced.getNode(), "\n");
        }
        FormatFixer.create((PsiElement)replaced, FormatFixer.Mode.Reformat).fixFormat();
    }

    @Nullable
    private static JSElement getExpressionFromStatement(@Nullable PsiElement statement) {
        if (statement == null) {
            return null;
        }
        if (statement instanceof JSReturnStatement) {
            return ((JSReturnStatement)statement).getExpression();
        }
        if (statement instanceof JSExpressionStatement) {
            JSExpression expression = ((JSExpressionStatement)statement).getExpression();
            return expression instanceof JSCommaExpression ? null : expression;
        }
        return null;
    }

    @Nullable
    private static JSElement getSingleStatement(@Nullable JSBlockStatement block) {
        PsiElement statement;
        if (block == null) {
            return null;
        }
        List<PsiElement> blockElements = JSArrowFunctionBracesCanBeRemovedInspection.getStatementsAndComments(block);
        PsiElement psiElement = statement = blockElements.size() == 1 ? blockElements.get(0) : null;
        while (statement instanceof JSBlockStatement) {
            List<PsiElement> elements = JSArrowFunctionBracesCanBeRemovedInspection.getStatementsAndComments((JSBlockStatement)statement);
            statement = elements.size() == 1 ? elements.get(0) : null;
        }
        if (statement == null) {
            return null;
        }
        return (JSElement)ObjectUtils.tryCast((Object)statement, JSElement.class);
    }

    private static JSBlockStatement getBlockBody(@NotNull JSFunctionExpression function) {
        if (function == null) {
            JSArrowFunctionBracesCanBeRemovedInspection.$$$reportNull$$$0(2);
        }
        return (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)function, JSBlockStatement.class);
    }

    private static List<PsiElement> getStatementsAndComments(@NotNull JSBlockStatement block) {
        if (block == null) {
            JSArrowFunctionBracesCanBeRemovedInspection.$$$reportNull$$$0(3);
        }
        return ContainerUtil.filter((Object[])block.getChildren(), element -> JSChangeUtil.isSourceElementOrComment(element));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSArrowFunctionBracesCanBeRemovedInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrowFunction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSArrowFunctionBracesCanBeRemovedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBlockBody";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStatementsAndComments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConvertToShorthandFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected ConvertToShorthandFix(@Nullable PsiElement element) {
            super(element);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"js.arrow.function.braces.can.be.removed.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                ConvertToShorthandFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                ConvertToShorthandFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            JSFunctionExpression arrowFunction;
            if (project == null) {
                ConvertToShorthandFix.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                ConvertToShorthandFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                ConvertToShorthandFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                ConvertToShorthandFix.$$$reportNull$$$0(5);
            }
            if ((arrowFunction = (JSFunctionExpression)ObjectUtils.tryCast((Object)startElement, JSFunctionExpression.class)) == null) {
                return;
            }
            JSArrowFunctionBracesCanBeRemovedInspection.invoke(arrowFunction);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSArrowFunctionBracesCanBeRemovedInspection$ConvertToShorthandFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSArrowFunctionBracesCanBeRemovedInspection$ConvertToShorthandFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

