/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.psi.ES6AssignmentProperty;
import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.intentions.JSFunctionsHelper;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.ES6ChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ShorthandObjectPropertyInspection
extends JSInspection
implements CleanupLocalInspectionTool {
    private static final LocalQuickFix expandShorthandQuickFix = new ExpandShorthandQuickFix();
    private static final LocalQuickFix replaceWithShorthandFix = new ReplaceWithShorthandQuickFix();
    private static final LocalQuickFix replaceWithFunctionPropertyFix = new ReplaceWithFunctionPropertyQuickFix();
    private static final LocalQuickFix expandFunctionPropertyFix = new ExpandFunctionPropertyQuickFix();

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSDestructuringProperty(JSDestructuringProperty property) {
                boolean canBeShorthanded;
                if (!ES6ShorthandObjectPropertyInspection.isES6((PsiElement)property)) {
                    return;
                }
                boolean isShorthand = property instanceof JSDestructuringShorthandedProperty;
                if (isShorthand) {
                    this.registerExpandFix((JSElement)property, expandShorthandQuickFix);
                    return;
                }
                JSInitializerOwner destructuringElement = property.getDestructuringElement();
                boolean bl = canBeShorthanded = destructuringElement instanceof JSVariable && !property.isRest() && StringUtil.equals((CharSequence)destructuringElement.getName(), (CharSequence)property.getName());
                if (canBeShorthanded) {
                    this.registerShorthandFix((PsiNameIdentifierOwner)property, JSBundle.message((String)"js.property.can.be.replaced.with.shorthand", (Object[])new Object[0]), replaceWithShorthandFix);
                }
            }

            public void visitJSProperty(JSProperty property) {
                boolean canBeShorthanded;
                boolean isShorthand;
                if (!ES6ShorthandObjectPropertyInspection.isES6((PsiElement)property)) {
                    return;
                }
                boolean bl = isShorthand = property instanceof ES6Property && ((ES6Property)property).isShorthanded() || property instanceof ES6AssignmentProperty;
                if (isShorthand || property instanceof JSFunctionProperty) {
                    LocalQuickFix fix = property instanceof JSFunctionProperty ? expandFunctionPropertyFix : expandShorthandQuickFix;
                    this.registerExpandFix((JSElement)property, fix);
                    return;
                }
                PsiElement identifier = property.getNameIdentifier();
                if (identifier == null) {
                    return;
                }
                JSExpression value = property.getValue();
                JSAssignmentExpression assignment = value instanceof JSAssignmentExpression ? (JSAssignmentExpression)value : null;
                boolean bl2 = canBeShorthanded = ES6ShorthandObjectPropertyInspection.referenceExpressionMatchesName(value, property.getName()) || assignment != null && assignment.getDefinitionExpression() != null && ES6ShorthandObjectPropertyInspection.referenceExpressionMatchesName(assignment.getDefinitionExpression().getExpression(), property.getName());
                if (canBeShorthanded) {
                    this.registerShorthandFix((PsiNameIdentifierOwner)property, JSBundle.message((String)"js.property.can.be.replaced.with.shorthand", (Object[])new Object[0]), replaceWithShorthandFix);
                    return;
                }
                if (value instanceof JSFunctionExpression && !property.isGetProperty() && !property.isSetProperty() && !JSPsiImplUtils.isArrowFunction((JSFunction)((JSFunctionExpression)value))) {
                    this.registerShorthandFix((PsiNameIdentifierOwner)property, JSBundle.message((String)"js.property.can.be.replaced.with.function.property", (Object[])new Object[0]), replaceWithFunctionPropertyFix);
                }
            }

            private void registerShorthandFix(PsiNameIdentifierOwner element, String description, LocalQuickFix fix) {
                PsiElement identifier = element.getNameIdentifier();
                if (identifier != null) {
                    InspectionManager inspectionManager = holder.getManager();
                    PsiElement nextSibling = JSPsiImplUtils.getNextSiblingIgnoreWhitespace(identifier);
                    PsiElement endElement = nextSibling != null && nextSibling.getNode().getElementType() == JSTokenTypes.COLON ? nextSibling : identifier;
                    ProblemDescriptor problemDescriptor = inspectionManager.createProblemDescriptor(identifier, endElement, description, ProblemHighlightType.LIKE_UNUSED_SYMBOL, holder.isOnTheFly(), new LocalQuickFix[]{fix});
                    holder.registerProblem(problemDescriptor);
                }
            }

            private void registerExpandFix(JSElement element, LocalQuickFix fix) {
                if (holder.isOnTheFly()) {
                    holder.registerProblem((PsiElement)element, fix.getFamilyName(), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{fix});
                }
            }
        };
        if (jSElementVisitor == null) {
            ES6ShorthandObjectPropertyInspection.$$$reportNull$$$0(0);
        }
        return jSElementVisitor;
    }

    private static boolean isES6(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            ES6ShorthandObjectPropertyInspection.$$$reportNull$$$0(1);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) != null && (dialect.isECMA6 || dialect.isTypeScript);
    }

    private static boolean referenceExpressionMatchesName(@Nullable JSExpression value, @Nullable String name) {
        return value instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)value, name);
    }

    private static <T extends JSElement> void transformProperty(@Nullable T sourceProperty, @NotNull NullableFunction<T, JSElement> createReplacement) {
        if (createReplacement == null) {
            ES6ShorthandObjectPropertyInspection.$$$reportNull$$$0(2);
        }
        if (sourceProperty == null) {
            return;
        }
        PsiComment docComment = JSDocumentationUtils.findDocComment(sourceProperty);
        JSElement replacement = (JSElement)createReplacement.fun(sourceProperty);
        if (replacement == null) {
            return;
        }
        JSDocumentationUtils.moveJSDoc(docComment, (PsiElement)replacement);
        FormatFixer.create((PsiElement)replacement, FormatFixer.Mode.Reformat).fixFormat();
    }

    private static JSProperty replacePropertyWithText(@NotNull JSProperty property, @NotNull String propertyText) {
        JSObjectLiteralExpression dummyObjectLiteral;
        if (property == null) {
            ES6ShorthandObjectPropertyInspection.$$$reportNull$$$0(3);
        }
        if (propertyText == null) {
            ES6ShorthandObjectPropertyInspection.$$$reportNull$$$0(4);
        }
        if ((dummyObjectLiteral = JSChangeUtil.createExpressionPsiWithContext("{" + propertyText + "}", (PsiElement)property, JSObjectLiteralExpression.class)) == null || dummyObjectLiteral.getFirstProperty() == null) {
            return null;
        }
        return (JSProperty)property.replace((PsiElement)dummyObjectLiteral.getFirstProperty());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createReplacement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isES6";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "transformProperty";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replacePropertyWithText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExpandFunctionPropertyQuickFix
    implements LocalQuickFix {
        private ExpandFunctionPropertyQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"js.expand.shorthand.property.quick.fix", (Object[])new Object[0]);
            if (string == null) {
                ExpandFunctionPropertyQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            JSFunctionProperty property;
            if (project == null) {
                ExpandFunctionPropertyQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ExpandFunctionPropertyQuickFix.$$$reportNull$$$0(2);
            }
            if ((property = (JSFunctionProperty)ObjectUtils.tryCast((Object)descriptor2.getStartElement(), JSFunctionProperty.class)) == null || property.getName() == null) {
                return;
            }
            ES6ShorthandObjectPropertyInspection.transformProperty((JSElement)property, prop -> {
                JSFunction result2 = JSFunctionsHelper.createAnonymousFunction((JSFunction)prop);
                if (result2 == null) {
                    return null;
                }
                JSProperty resultProp = ES6ShorthandObjectPropertyInspection.replacePropertyWithText((JSProperty)prop, prop.getName() + ": " + result2.getText());
                if (resultProp == null) {
                    return null;
                }
                return resultProp;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ExpandFunctionPropertyQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ExpandFunctionPropertyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ReplaceWithFunctionPropertyQuickFix
    implements LocalQuickFix {
        private ReplaceWithFunctionPropertyQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"js.replace.with.function.property.quick.fix", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithFunctionPropertyQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                ReplaceWithFunctionPropertyQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ReplaceWithFunctionPropertyQuickFix.$$$reportNull$$$0(2);
            }
            JSProperty property = (JSProperty)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getStartElement(), JSProperty.class);
            ES6ShorthandObjectPropertyInspection.transformProperty((JSElement)property, prop -> {
                JSFunction function;
                JSFunction jSFunction = function = prop != null && prop.getValue() instanceof JSFunction ? (JSFunction)prop.getValue() : null;
                if (function == null || prop.getName() == null) {
                    return null;
                }
                ES6FunctionProperty result2 = JSFunctionsHelper.createFunctionProperty(function, prop.getName());
                if (result2 == null) {
                    return null;
                }
                return (JSProperty)prop.replace((PsiElement)result2);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ReplaceWithFunctionPropertyQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ReplaceWithFunctionPropertyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ExpandShorthandQuickFix
    implements LocalQuickFix {
        private ExpandShorthandQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"js.expand.shorthand.property.quick.fix", (Object[])new Object[0]);
            if (string == null) {
                ExpandShorthandQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            ES6Property es6Property;
            if (project == null) {
                ExpandShorthandQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ExpandShorthandQuickFix.$$$reportNull$$$0(2);
            }
            if ((es6Property = (ES6Property)ObjectUtils.tryCast((Object)(element = descriptor2.getStartElement()), ES6Property.class)) != null) {
                ES6ShorthandObjectPropertyInspection.transformProperty((JSElement)es6Property, prop -> prop.getName() == null || prop.getValue() == null ? null : ES6ChangeUtil.expandShorthandPropertyWithValue((JSProperty)prop, prop.getName()));
                return;
            }
            ES6AssignmentProperty assignmentProperty = (ES6AssignmentProperty)ObjectUtils.tryCast((Object)element, ES6AssignmentProperty.class);
            if (assignmentProperty != null && assignmentProperty.getName() != null) {
                ES6ShorthandObjectPropertyInspection.transformProperty((JSElement)assignmentProperty, prop -> ES6ChangeUtil.expandShorthandPropertyWithValue((JSProperty)assignmentProperty, assignmentProperty.getText()));
                return;
            }
            JSDestructuringShorthandedProperty destructuringProperty = (JSDestructuringShorthandedProperty)ObjectUtils.tryCast((Object)element, JSDestructuringShorthandedProperty.class);
            if (destructuringProperty != null) {
                ES6ShorthandObjectPropertyInspection.transformProperty((JSElement)destructuringProperty, ES6ChangeUtil::expandDestructuringProperty);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ExpandShorthandQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ExpandShorthandQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ReplaceWithShorthandQuickFix
    implements LocalQuickFix {
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"js.replace.with.shorthand.property.quick.fix", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithShorthandQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            JSProperty property;
            if (project == null) {
                ReplaceWithShorthandQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ReplaceWithShorthandQuickFix.$$$reportNull$$$0(2);
            }
            if ((property = (JSProperty)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getStartElement(), JSProperty.class)) != null) {
                ES6ShorthandObjectPropertyInspection.transformProperty((JSElement)property, ES6ChangeUtil::replaceWithShorthand);
                return;
            }
            JSDestructuringProperty destructuringProperty = (JSDestructuringProperty)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getStartElement(), JSDestructuringProperty.class);
            if (destructuringProperty != null) {
                ES6ShorthandObjectPropertyInspection.transformProperty((JSElement)destructuringProperty, ES6ChangeUtil::replaceWithShorthand);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ReplaceWithShorthandQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ShorthandObjectPropertyInspection$ReplaceWithShorthandQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

