/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.type.jsfunction;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;

public class JSFunctionHierarchyNodeDescriptor
extends HierarchyNodeDescriptor {
    public JSFunctionHierarchyNodeDescriptor(Project project, HierarchyNodeDescriptor parentDescriptor, JSPsiElementBase jsFunction, boolean isBase) {
        super(project, (NodeDescriptor)parentDescriptor, (PsiElement)jsFunction, isBase);
    }

    public final JSPsiElementBase getJSFunction() {
        return (JSPsiElementBase)this.getPsiElement();
    }

    public final boolean update() {
        VirtualFile file2;
        boolean changes = super.update();
        if (this.getJSFunction() == null) {
            String invalidPrefix = IdeBundle.message((String)"node.hierarchy.invalid", (Object[])new Object[0]);
            if (!this.myHighlightedText.getText().startsWith(invalidPrefix)) {
                this.myHighlightedText.getBeginning().addText(invalidPrefix, HierarchyNodeDescriptor.getInvalidPrefixAttributes());
            }
            return true;
        }
        JSPsiElementBase jsFunction = this.getJSFunction();
        if (jsFunction.isClassOrInterface() == JSElementBase.ClassOrInterface.INTERFACE) {
            this.setIcon(PlatformIcons.INTERFACE_ICON);
        }
        if (changes && this.myIsBase) {
            LayeredIcon icon = new LayeredIcon(2);
            icon.setIcon(this.getIcon(), 0);
            icon.setIcon(AllIcons.Hierarchy.Base, 1, -AllIcons.Hierarchy.Base.getIconWidth() / 2, 0);
            this.setIcon((Icon)icon);
        }
        CompositeAppearance oldText = this.myHighlightedText;
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes classNameAttributes = null;
        if (this.myColor != null) {
            classNameAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        this.myHighlightedText.getEnding().addText(jsFunction.getName(), classNameAttributes);
        VirtualFile virtualFile = file2 = jsFunction.isValid() ? jsFunction.getContainingFile().getVirtualFile() : null;
        if (file2 != null) {
            this.myHighlightedText.getEnding().addText(" (" + file2.getName() + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
            this.myName = this.myHighlightedText.getText();
        }
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes = true;
        }
        return changes;
    }
}

