/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react.tsx;

import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContextualUnionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptReactComponentUtil {
    public static final String ELEMENT_CLASS_NAME = "ElementClass";
    public static final Set<String> REACT_COMPONENT_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"Component", "PureComponent"});
    public static final Set<String> REACT_SINGLE_VARIANT_COMPONENT_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"StatelessComponent", "ComponentType", "ComponentClass"});
    public static final String PROPS_FIELD_NAME = "props";
    private static final JSType STRING_TYPE = new JSStringType(true, JSTypeSource.EXPLICITLY_DECLARED, JSTypeContext.INSTANCE);
    private static final JSType BOOLEAN_TYPE = new JSBooleanType(true, JSTypeSource.EXPLICITLY_DECLARED, JSTypeContext.INSTANCE);

    @NotNull
    public static Collection<JSClass> resolveComponent(@NotNull XmlTag tag) {
        if (tag == null) {
            TypeScriptReactComponentUtil.$$$reportNull$$$0(0);
        }
        JSTypeResolveResult result2 = TypeScriptImportHandler.getInstance().resolveName(tag.getName(), (PsiElement)tag);
        ArrayList toReturn = ContainerUtil.newArrayList();
        for (PsiElement psiElement : result2.getElements()) {
            JSClass jsClass;
            if (!(psiElement instanceof JSClass) || (jsClass = (JSClass)psiElement).isInterface()) continue;
            toReturn.add(jsClass);
        }
        ArrayList arrayList = toReturn;
        if (arrayList == null) {
            TypeScriptReactComponentUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    public static JSType getTypeScriptPropsTypeFromPsiElement(@Nullable PsiElement resolve, @NotNull XmlTag tag) {
        JSType typeFromParam;
        if (tag == null) {
            TypeScriptReactComponentUtil.$$$reportNull$$$0(2);
        }
        PsiElement initialElement = resolve;
        if (resolve instanceof JSVariable) {
            resolve = ((JSVariable)resolve).tryGetFunctionExpressionInitializer();
        }
        if (resolve instanceof JSClass) {
            Pair<JSClass, JSType> type = TypeScriptReactComponentUtil.getPropsType((JSClass)resolve);
            if (type != null && type.second != null) {
                return TypeScriptUtil.applyGenericsToType((JSType)type.second, (JSClass)resolve, (JSClass)type.first);
            }
        } else if (!(!(resolve instanceof JSFunction) || resolve instanceof TypeScriptFunction && ((TypeScriptFunction)resolve).isOverloadImplementation() || (typeFromParam = TypeScriptReactComponentUtil.getTypeFromFunctionParameter((JSFunction)resolve)) == null)) {
            return typeFromParam;
        }
        if (initialElement instanceof TypeScriptFunction && ((TypeScriptFunction)initialElement).isOverloadImplementation()) {
            ArrayList allTypes = ContainerUtil.newArrayList();
            for (TypeScriptFunction overload : ((TypeScriptFunction)initialElement).getOverloadDeclarations()) {
                JSType typeFromParam2;
                if (overload.isOverloadImplementation() || (typeFromParam2 = TypeScriptReactComponentUtil.getTypeFromFunctionParameter((JSFunction)overload)) == null) continue;
                allTypes.add(typeFromParam2);
            }
            if (allTypes.size() >= 1) {
                return JSContextualUnionTypeImpl.getContextualUnionType(allTypes, JSTypeSourceFactory.createTypeSource((PsiElement)tag, true));
            }
        }
        if (initialElement == null) {
            return null;
        }
        JSTypeEvaluationResult varType = JSTypeEvaluator.getElementType(initialElement);
        if (varType != null) {
            JSType genericStatelessArg;
            JSType type = varType.getType();
            if (type instanceof JSGenericTypeImpl && (genericStatelessArg = JSTypeUtils.getSingleGenericArgTypeFromGenericType((JSGenericTypeImpl)type, TypeScriptReactComponentUtil::isReactSingleVariantComponent, true)) != null) {
                return genericStatelessArg;
            }
            return TypeScriptReactComponentUtil.getPropsTypeFromJsType(type);
        }
        return null;
    }

    @Contract(value="null -> false")
    private static boolean isReactSingleVariantComponent(@Nullable JSType t) {
        if (!(t instanceof JSResolvableType)) {
            return false;
        }
        JSResolvedTypeInfo info = ((JSResolvableType)t).resolveType();
        JSClass declaration = (JSClass)info.getDeclarationOfType(TypeScriptInterface.class);
        if (declaration == null) {
            declaration = (JSClass)info.getDeclarationOfType(TypeScriptTypeAlias.class);
        }
        return declaration != null && REACT_SINGLE_VARIANT_COMPONENT_NAMES.contains(declaration.getName());
    }

    @Nullable
    private static JSType getTypeFromFunctionParameter(@NotNull JSFunction resolve) {
        JSParameterListElement[] parameters;
        JSType typeFromParam;
        if (resolve == null) {
            TypeScriptReactComponentUtil.$$$reportNull$$$0(3);
        }
        if ((typeFromParam = TypeScriptReactComponentUtil.getPropsTypeFromParameters(parameters = resolve.getParameters())) != null) {
            return typeFromParam;
        }
        return null;
    }

    @Nullable
    private static JSType getPropsTypeFromParameters(@NotNull JSParameterListElement[] parameters) {
        if (parameters == null) {
            TypeScriptReactComponentUtil.$$$reportNull$$$0(4);
        }
        if (parameters.length != 1) {
            return null;
        }
        JSType type = parameters[0].getType();
        if (type != null) {
            return type;
        }
        JSTypeEvaluationResult elementType = JSTypeEvaluator.getElementType((PsiElement)parameters[0]);
        return elementType == null ? null : elementType.getType();
    }

    @Nullable
    @Contract(value="null -> null")
    private static JSType getPropsTypeFromJsType(@Nullable JSType type) {
        if (type == null) {
            return null;
        }
        for (JSRecordType.CallSignature member : type.asRecordType().getCallSignatures()) {
            JSRecordType.PropertySignature signature;
            JSResolvedTypeInfo info;
            JSClass aClass;
            JSType innerType;
            JSType returnType;
            JSFunctionType functionType;
            if (!member.hasNew() || !((functionType = member.getFunctionType()) instanceof TypeScriptJSFunctionTypeImpl) || !((returnType = ((TypeScriptJSFunctionTypeImpl)functionType).getReturnType()) instanceof JSGenericTypeImpl) || !((innerType = ((JSGenericTypeImpl)returnType).getType()) instanceof JSResolvableType) || (aClass = (info = ((JSResolvableType)innerType).resolveType()).getDeclarationOfType(JSClass.class)) == null || !REACT_COMPONENT_NAMES.contains(aClass.getName()) || (signature = returnType.asRecordType().findPropertySignature(PROPS_FIELD_NAME)) == null) continue;
            return signature.getType();
        }
        return null;
    }

    @Nullable
    private static JSType getAttributeValueType(@Nullable XmlAttributeValue element, @NotNull PsiElement initialElement) {
        JSExpression expression;
        if (initialElement == null) {
            TypeScriptReactComponentUtil.$$$reportNull$$$0(5);
        }
        if (element == null) {
            return BOOLEAN_TYPE;
        }
        if (StringUtil.isQuotedString((String)element.getText())) {
            return STRING_TYPE;
        }
        PsiElement child = element.getFirstChild();
        if (child instanceof JSEmbeddedContent && (expression = (JSExpression)PsiTreeUtil.getChildOfType((PsiElement)child, JSExpression.class)) != null) {
            return JSResolveUtil.getExpressionJSType(expression);
        }
        return JSAnyType.get(initialElement, true);
    }

    @NotNull
    private static List<JSSpreadExpression> getSpreadAttributes(@NotNull XmlTag tag) {
        JSEmbeddedContent[] possibleSpread;
        if (tag == null) {
            TypeScriptReactComponentUtil.$$$reportNull$$$0(6);
        }
        if ((possibleSpread = (JSEmbeddedContent[])PsiTreeUtil.getChildrenOfType((PsiElement)tag, JSEmbeddedContent.class)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptReactComponentUtil.$$$reportNull$$$0(7);
            }
            return list;
        }
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)possibleSpread.length);
        for (JSEmbeddedContent content : possibleSpread) {
            JSSpreadExpression spreadExpression;
            JSEmbeddedContent inner = (JSEmbeddedContent)PsiTreeUtil.getChildOfType((PsiElement)content, JSEmbeddedContent.class);
            if (inner == null || (spreadExpression = (JSSpreadExpression)PsiTreeUtil.getChildOfType((PsiElement)inner, JSSpreadExpression.class)) == null) continue;
            result2.add(spreadExpression);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            TypeScriptReactComponentUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public static JSRecordTypeImpl createRecordTypeFromTag(@NotNull XmlTag tag, @NotNull PsiElement initialElement) {
        if (tag == null) {
            TypeScriptReactComponentUtil.$$$reportNull$$$0(9);
        }
        if (initialElement == null) {
            TypeScriptReactComponentUtil.$$$reportNull$$$0(10);
        }
        XmlAttribute[] attributes = tag.getAttributes();
        ArrayList props = ContainerUtil.newArrayList();
        for (XmlAttribute attribute : attributes) {
            props.add(new JSRecordTypeImpl.PropertySignatureImpl(attribute.getName(), TypeScriptReactComponentUtil.getAttributeValueType(attribute.getValueElement(), initialElement), false));
        }
        for (JSSpreadExpression spreadExpression : TypeScriptReactComponentUtil.getSpreadAttributes(tag)) {
            JSType type;
            JSExpression expression = spreadExpression.getExpression();
            if (expression == null || (type = JSResolveUtil.getExpressionJSType(expression)) == null) continue;
            for (JSRecordType.TypeMember member : type.asRecordType().getTypeMembers()) {
                if (!(member instanceof JSRecordType.PropertySignature)) continue;
                props.add(member);
            }
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)tag, true), props);
        if (jSRecordTypeImpl == null) {
            TypeScriptReactComponentUtil.$$$reportNull$$$0(11);
        }
        return jSRecordTypeImpl;
    }

    @Nullable
    public static Pair<JSClass, JSType> getPropsType(@NotNull JSClass componentClass) {
        if (componentClass == null) {
            TypeScriptReactComponentUtil.$$$reportNull$$$0(12);
        }
        for (JSClass<?> aClass : TypeScriptUtil.getNonStrictParents(componentClass, false)) {
            JSField props = aClass.findFieldByName(PROPS_FIELD_NAME);
            if (!REACT_COMPONENT_NAMES.contains(aClass.getName()) || props == null) continue;
            return Pair.create(aClass, (Object)props.getType());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactComponentUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactComponentUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveComponent";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpreadAttributes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createRecordTypeFromTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveComponent";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypeScriptPropsTypeFromPsiElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromFunctionParameter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPropsTypeFromParameters";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValueType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSpreadAttributes";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createRecordTypeFromTag";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPropsType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

