/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.ecmascript6.ES6SpecificHandlersFactory;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.ExpectedTypeEvaluator;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXSpecificHandlersFactory
extends ES6SpecificHandlersFactory {
    @Override
    @NotNull
    public ExpectedTypeEvaluator newExpectedTypeEvaluator(JSExpression parent, JSExpectedTypeKind expectedTypeKind) {
        JSXExpectedTypeEvaluator jSXExpectedTypeEvaluator = new JSXExpectedTypeEvaluator(parent, expectedTypeKind);
        if (jSXExpectedTypeEvaluator == null) {
            JSXSpecificHandlersFactory.$$$reportNull$$$0(0);
        }
        return jSXExpectedTypeEvaluator;
    }

    @Nullable
    public static JSType computeExpectedTypeFromEmbeddedContent(@NotNull JSEmbeddedContent embeddedContent) {
        XmlAttribute attribute;
        PsiElement attrValueCandidate;
        PsiElement parent;
        if (embeddedContent == null) {
            JSXSpecificHandlersFactory.$$$reportNull$$$0(1);
        }
        if ((parent = embeddedContent.getParent()) instanceof JSEmbeddedContent && (attrValueCandidate = parent.getParent()) instanceof XmlAttributeValue && (attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)attrValueCandidate, XmlAttribute.class)) != null) {
            XmlAttributeDescriptor descriptor2 = attribute.getDescriptor();
            return ReactXmlExtension.getType(descriptor2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/JSXSpecificHandlersFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embeddedContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "newExpectedTypeEvaluator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/JSXSpecificHandlersFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "computeExpectedTypeFromEmbeddedContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JSXExpectedTypeEvaluator
    extends ExpectedTypeEvaluator {
        private static final String[] STYLES = new String[]{"Image", "ScrollView", "Text"};

        public JSXExpectedTypeEvaluator(JSExpression parent, JSExpectedTypeKind expectedTypeKind) {
            super(parent, expectedTypeKind);
        }

        @Override
        public void visitJSProperty(JSProperty node) {
            JSCallExpression call;
            if (this.myParent instanceof JSObjectLiteralExpression && JSXExpectedTypeEvaluator.isStyleSheetCreate(call = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myGrandParent, JSCallExpression.class, (boolean)true, (Class[])new Class[]{JSExecutionScope.class}))) {
                JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)this.myParent, true);
                ArrayList<JSType> styles = new ArrayList<JSType>(STYLES.length);
                for (String style : STYLES) {
                    styles.add(JSNamedType.createType("__React." + style + "Style", source, JSContext.INSTANCE));
                    styles.add(JSNamedType.createType("React." + style + "Style", source, JSContext.INSTANCE));
                }
                this.myResult = new JSCompositeTypeImpl(source, (List<JSType>)styles);
                return;
            }
            super.visitJSProperty(node);
        }

        private static boolean isStyleSheetCreate(@Nullable JSCallExpression call) {
            return call != null && call.getMethodExpression() instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)call.getMethodExpression(), "StyleSheet", "create");
        }

        public void visitJSEmbeddedContent(JSEmbeddedContent embeddedContent) {
            JSType expectedType = JSXSpecificHandlersFactory.computeExpectedTypeFromEmbeddedContent(embeddedContent);
            if (expectedType != null) {
                this.myResult = expectedType;
            }
            super.visitJSEmbeddedContent(embeddedContent);
        }
    }
}

