/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.blocks.alignment;

import com.intellij.formatting.Alignment;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JSConditionalExpressionAlignmentFactory
implements ASTNodeBasedAlignmentFactory {
    private final CommonCodeStyleSettings mySettings;
    private final Alignment myAlignment1;
    private final Alignment myAlignment2;

    public JSConditionalExpressionAlignmentFactory(CommonCodeStyleSettings settings) {
        this.mySettings = settings;
        this.myAlignment1 = Alignment.createAlignment();
        this.myAlignment2 = Alignment.createChildAlignment((Alignment)this.myAlignment1);
    }

    @Override
    public Alignment getAlignment(@NotNull ASTNode child) {
        if (child == null) {
            JSConditionalExpressionAlignmentFactory.$$$reportNull$$$0(0);
        }
        if (!this.mySettings.ALIGN_MULTILINE_TERNARY_OPERATION) {
            return null;
        }
        IElementType childElementType = child.getElementType();
        if (JSExtendedLanguagesTokenSetProvider.EXPRESSIONS.contains(childElementType)) {
            return this.myAlignment1;
        }
        if (childElementType == JSTokenTypes.COLON || childElementType == JSTokenTypes.QUEST) {
            return this.myAlignment2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/formatter/blocks/alignment/JSConditionalExpressionAlignmentFactory", "getAlignment"));
    }
}

