/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6NamedImports;
import com.intellij.lang.html.HtmlQuotesFormatPreprocessor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.PostFormatProcessorUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.HtmlCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSEnforceCodeStylePostProcessor
implements PostFormatProcessor {
    private static final TokenSet possiblyAmbiguousTokens = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.LBRACKET, JSTokenTypes.LPAR, JSTokenTypes.PLUS, JSTokenTypes.MINUS, JSTokenTypes.DIV, JSTokenTypes.BACKQUOTE});

    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(1);
        }
        return PostFormatProcessorUtil.processElement(source, JSEnforceCodeStylePostProcessor::processTextRange);
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile rootPsi, @NotNull TextRange range, @NotNull CodeStyleSettings settings) {
        if (rootPsi == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(2);
        }
        if (range == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(4);
        }
        TextRange textRange = PostFormatProcessorUtil.processText(rootPsi, range, JSEnforceCodeStylePostProcessor::processTextRange);
        if (textRange == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    @NotNull
    private static TextRange processTextRange(@NotNull PsiElement rootPsi, @NotNull TextRange range) {
        JSLanguageDialect dialect;
        if (rootPsi == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(6);
        }
        if (range == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(7);
        }
        if ((dialect = DialectDetector.languageDialectOfElement(rootPsi)) == null || !dialect.getOptionHolder().isJavaScript() && !dialect.getOptionHolder().isTypeScript && !dialect.getOptionHolder().isECMA4) {
            TextRange textRange = range;
            if (textRange == null) {
                JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(8);
            }
            return textRange;
        }
        if (rootPsi instanceof JSEmbeddedContent && rootPsi.getParent() instanceof XmlAttributeValue) {
            TextRange textRange = range;
            if (textRange == null) {
                JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(9);
            }
            return textRange;
        }
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)rootPsi.getContainingFile());
        HtmlCodeStyleSettings htmlSettings = (HtmlCodeStyleSettings)settings.getCustomSettings(HtmlCodeStyleSettings.class);
        JSCodeStyleSettings languageSettings = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.getSettingsClass(dialect));
        if (!(languageSettings.FORCE_QUOTE_STYlE || languageSettings.FORCE_SEMICOLON_STYLE || htmlSettings.HTML_ENFORCE_QUOTES || languageSettings.ENFORCE_TRAILING_COMMA != JSCodeStyleSettings.TrailingCommaOption.Keep)) {
            TextRange textRange = range;
            if (textRange == null) {
                JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(10);
            }
            return textRange;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)rootPsi.getProject());
        Document document = rootPsi.getContainingFile().getViewProvider().getDocument();
        if (document == null) {
            TextRange textRange = range;
            if (textRange == null) {
                JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(11);
            }
            return textRange;
        }
        MyVisitor visitor = new MyVisitor(rootPsi, range, settings, document, dialect);
        DocumentUtil.executeInBulk((Document)document, (boolean)true, () -> {
            if (rootPsi == null) {
                JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(16);
            }
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
            rootPsi.accept((PsiElementVisitor)visitor);
            psiDocumentManager.commitDocument(document);
        });
        TextRange textRange = visitor.getResultRange();
        if (textRange == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(12);
        }
        return textRange;
    }

    private static boolean isComma(@Nullable PsiElement afterList) {
        return afterList != null && afterList.getNode().getElementType() == JSTokenTypes.COMMA;
    }

    private static boolean isNewLineWS(@Nullable PsiElement possiblyWhitespace) {
        return possiblyWhitespace instanceof PsiWhiteSpace && possiblyWhitespace.getText().contains("\n");
    }

    private static boolean isDestructuringAssignmentRest(@NotNull JSElement last) {
        if (last == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(13);
        }
        return last instanceof JSSpreadExpression && JSDestructuringUtil.getDestructuringAssignmentInitializer((JSExpression)last) != null;
    }

    private static boolean isSafeToDeleteSemicolon(@NotNull PsiElement semicolon, @NotNull JSElement jsElement) {
        if (semicolon == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(14);
        }
        if (jsElement == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(15);
        }
        if (!(jsElement instanceof JSStatement)) {
            return true;
        }
        if (PsiTreeUtil.prevLeaf((PsiElement)semicolon) instanceof OuterLanguageElement) {
            return false;
        }
        JSStatement nextStatement = (JSStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)jsElement, JSStatement.class);
        if (nextStatement == null) {
            return true;
        }
        PsiElement firstLeaf = PsiTreeUtil.getDeepestFirst((PsiElement)nextStatement);
        return !possiblyAmbiguousTokens.contains(firstLeaf.getNode().getElementType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPsi";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semicolon";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "processText";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "processTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processTextRange";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isDestructuringAssignmentRest";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isSafeToDeleteSemicolon";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processTextRange$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyVisitor
    extends JSRecursiveElementVisitor {
        private final CodeStyleSettings.QuoteStyle myHtmlQuoteStyle;
        private final boolean myEnforceHtmlQuotes;
        private final PostFormatProcessorHelper myPostProcessorHelper;
        private final TextRange myOriginalRange;
        private final JSCodeStyleSettings languageSettings;
        private final Document myDocument;
        private final DialectOptionHolder myDialectOptionHolder;
        private final HtmlQuotesFormatPreprocessor.HtmlQuotesConverter myQuotesConverter;

        public MyVisitor(@NotNull PsiElement context, @NotNull TextRange originalRange, @NotNull CodeStyleSettings settings, @NotNull Document document, @NotNull JSLanguageDialect languageDialect) {
            if (context == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (originalRange == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if (settings == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if (document == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if (languageDialect == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            HtmlCodeStyleSettings htmlSettings = (HtmlCodeStyleSettings)settings.getCustomSettings(HtmlCodeStyleSettings.class);
            this.myHtmlQuoteStyle = htmlSettings.HTML_QUOTE_STYLE;
            this.myEnforceHtmlQuotes = htmlSettings.HTML_ENFORCE_QUOTES;
            this.myOriginalRange = originalRange;
            this.myPostProcessorHelper = new PostFormatProcessorHelper(settings);
            this.myPostProcessorHelper.setResultTextRange(originalRange);
            this.languageSettings = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.getSettingsClass(languageDialect));
            this.myQuotesConverter = new HtmlQuotesFormatPreprocessor.HtmlQuotesConverter(this.myHtmlQuoteStyle, context, this.myPostProcessorHelper);
            this.myDocument = document;
            this.myDialectOptionHolder = languageDialect.getOptionHolder();
        }

        public TextRange getResultRange() {
            return this.myPostProcessorHelper.getResultTextRange();
        }

        public void visitElement(PsiElement element) {
            super.visitElement(element);
            this.applyJavaScriptQuoteStyle(element);
            if (element instanceof XmlTag) {
                this.applyJSXQuoteStyle(element);
            }
        }

        public void visitES6ImportDeclaration(ES6ImportDeclaration importDeclaration) {
            super.visitES6ImportDeclaration(importDeclaration);
            this.applySemicolonStyle((JSElement)importDeclaration);
        }

        public void visitES6NamedImports(ES6NamedImports imports) {
            super.visitES6NamedImports(imports);
            this.applyTrailingCommaStyle((JSElement[])imports.getSpecifiers(), JSTokenTypes.RBRACE);
        }

        public void visitES6ExportDeclaration(ES6ExportDeclaration exportDeclaration) {
            super.visitES6ExportDeclaration(exportDeclaration);
            this.applyTrailingCommaStyle((JSElement[])exportDeclaration.getExportSpecifiers(), JSTokenTypes.RBRACE);
            this.applySemicolonStyle((JSElement)exportDeclaration);
        }

        public void visitES6ExportDefaultAssignment(ES6ExportDefaultAssignment node) {
            super.visitES6ExportDefaultAssignment(node);
            JSNamedElement element = node.getNamedElement();
            if (element instanceof JSClass || element instanceof JSFunction) {
                return;
            }
            this.applySemicolonStyle((JSElement)node);
        }

        public void visitJSStatement(JSStatement node) {
            super.visitJSStatement(node);
            PsiElement parent = node.getParent();
            if (JSUtils.isStatementUsuallyRequiringSemicolon(node) && !(parent instanceof TypeScriptEnum)) {
                this.applySemicolonStyle((JSElement)node);
            }
        }

        public void visitJSForStatement(JSForStatement node) {
            JSStatement body;
            JSExpression update;
            JSExpression initialization;
            JSVarStatement varDeclaration = node.getVarDeclaration();
            if (varDeclaration != null) {
                for (JSVariable variable : varDeclaration.getVariables()) {
                    variable.accept((PsiElementVisitor)this);
                }
            }
            if ((initialization = node.getInitialization()) != null) {
                initialization.accept((PsiElementVisitor)this);
            }
            if ((update = node.getUpdate()) != null) {
                update.accept((PsiElementVisitor)this);
            }
            if ((body = node.getBody()) != null) {
                body.accept((PsiElementVisitor)this);
            }
        }

        public void visitJSForInStatement(JSForInStatement node) {
            JSStatement body;
            JSExpression collectionExpression = node.getCollectionExpression();
            if (collectionExpression != null) {
                collectionExpression.accept((PsiElementVisitor)this);
            }
            if ((body = node.getBody()) != null) {
                body.accept((PsiElementVisitor)this);
            }
        }

        public void visitJSArrayLiteralExpression(JSArrayLiteralExpression node) {
            super.visitJSArrayLiteralExpression(node);
            this.applyTrailingCommaStyle((JSElement)ArrayUtil.getLastElement((Object[])node.getExpressions()), JSTokenTypes.RBRACKET, el -> !JSEnforceCodeStylePostProcessor.isDestructuringAssignmentRest((JSElement)el));
        }

        public void visitJSObjectLiteralExpression(JSObjectLiteralExpression node) {
            super.visitJSObjectLiteralExpression(node);
            this.applyTrailingCommaStyle((JSElement)ArrayUtil.getLastElement((Object[])node.getPropertiesIncludingSpreads()), JSTokenTypes.RBRACE, el -> !JSEnforceCodeStylePostProcessor.isDestructuringAssignmentRest(el));
        }

        public void visitJSParameterList(JSParameterList node) {
            super.visitJSParameterList(node);
            if (this.myDialectOptionHolder.hasFeature(JSLanguageFeature.TRAILING_FUNCTION_COMMA)) {
                this.applyTrailingCommaStyle((JSElement)node.getParameters(), JSTokenTypes.RPAR, (Condition)p -> !p.isRest());
            }
        }

        public void visitJSArgumentList(JSArgumentList node) {
            super.visitJSArgumentList(node);
            if (this.myDialectOptionHolder.hasFeature(JSLanguageFeature.TRAILING_FUNCTION_COMMA)) {
                this.applyTrailingCommaStyle((JSElement[])node.getArguments(), JSTokenTypes.RPAR);
            }
        }

        public void visitJSDestructuringObject(JSDestructuringObject destructuringObject) {
            super.visitJSDestructuringObject(destructuringObject);
            this.applyTrailingCommaStyle((JSElement)destructuringObject.getProperties(), JSTokenTypes.RBRACE, (Condition)p -> !p.isRest());
        }

        public void visitJSDestructuringArray(JSDestructuringArray destructuringArray) {
            super.visitJSDestructuringArray(destructuringArray);
            this.applyTrailingCommaStyle((JSElement)ObjectUtils.coalesce((Object)destructuringArray.getRestElement(), (Object)ArrayUtil.getLastElement((Object[])destructuringArray.getElements())), JSTokenTypes.RBRACKET, t -> !(t instanceof JSDestructuringArrayRestElement));
        }

        private void applyJSXQuoteStyle(@NotNull PsiElement element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            if (this.myHtmlQuoteStyle == CodeStyleSettings.QuoteStyle.None || !this.myEnforceHtmlQuotes) {
                return;
            }
            element.accept((PsiElementVisitor)this.myQuotesConverter);
        }

        private void applyJavaScriptQuoteStyle(@NotNull PsiElement element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            if (!this.languageSettings.FORCE_QUOTE_STYlE || !this.containedInRange(element)) {
                return;
            }
            ASTNode node = element.getNode();
            if (!JSTokenTypes.STRING_LITERALS.contains(node.getElementType())) {
                return;
            }
            String stringValue = node.getText();
            if (stringValue.length() < 2) {
                return;
            }
            String currentQuote = stringValue.substring(0, 1);
            char currentQuoteChar = currentQuote.charAt(0);
            String newQuote = JSCodeStyleSettings.getQuote(element);
            if (stringValue.charAt(stringValue.length() - 1) != currentQuoteChar) {
                return;
            }
            if (StringUtil.equals((CharSequence)newQuote, (CharSequence)currentQuote)) {
                return;
            }
            TextRange nodeRange = node.getTextRange();
            this.replaceRange(nodeRange.getStartOffset(), nodeRange.getStartOffset() + 1, newQuote);
            this.replaceRange(nodeRange.getEndOffset() - 1, nodeRange.getEndOffset(), newQuote);
            String quotedValue = stringValue.substring(1, stringValue.length() - 1);
            String newQuotedValue = JSStringUtil.changeQuotesInLiteralValue(quotedValue, currentQuoteChar, newQuote.charAt(0));
            if (newQuotedValue == quotedValue) {
                return;
            }
            this.replaceRange(nodeRange.getStartOffset() + 1, nodeRange.getEndOffset() - 1, newQuotedValue);
        }

        private void applySemicolonStyle(@NotNull JSElement node) {
            boolean needSemicolon;
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(7);
            }
            if (!this.languageSettings.FORCE_SEMICOLON_STYLE || !this.containedInRange((PsiElement)node) || PsiTreeUtil.getDeepestLast((PsiElement)node) instanceof PsiErrorElement) {
                return;
            }
            ASTNode lastLeafElement = node.getLastChild().getNode();
            boolean hasSemicolon = lastLeafElement.getElementType() == JSTokenTypes.SEMICOLON;
            if (hasSemicolon == (needSemicolon = this.languageSettings.USE_SEMICOLON_AFTER_STATEMENT)) {
                return;
            }
            if (needSemicolon) {
                this.insertString(lastLeafElement.getStartOffset() + lastLeafElement.getTextLength(), ";");
            } else if (JSEnforceCodeStylePostProcessor.isSafeToDeleteSemicolon(lastLeafElement.getPsi(), node)) {
                this.deleteNode(lastLeafElement);
            }
        }

        private <T extends JSElement> void applyTrailingCommaStyle(@NotNull T[] listChildren, @NotNull IElementType rBracketType, @NotNull Condition<T> shouldAddToLastElement) {
            if (listChildren == null) {
                MyVisitor.$$$reportNull$$$0(8);
            }
            if (rBracketType == null) {
                MyVisitor.$$$reportNull$$$0(9);
            }
            if (shouldAddToLastElement == null) {
                MyVisitor.$$$reportNull$$$0(10);
            }
            this.applyTrailingCommaStyle((JSElement)ArrayUtil.getLastElement((Object[])listChildren), rBracketType, shouldAddToLastElement);
        }

        private <T extends JSElement> void applyTrailingCommaStyle(@NotNull T[] listChildren, @NotNull IElementType rBracketType) {
            if (listChildren == null) {
                MyVisitor.$$$reportNull$$$0(11);
            }
            if (rBracketType == null) {
                MyVisitor.$$$reportNull$$$0(12);
            }
            this.applyTrailingCommaStyle((JSElement)ArrayUtil.getLastElement((Object[])listChildren), rBracketType, Conditions.alwaysTrue());
        }

        private <T extends JSElement> void applyTrailingCommaStyle(@Nullable T lastListElement, @NotNull IElementType rBracketType, @NotNull Condition<T> shouldAddToLastElement) {
            JSCodeStyleSettings.TrailingCommaOption settingValue;
            if (rBracketType == null) {
                MyVisitor.$$$reportNull$$$0(13);
            }
            if (shouldAddToLastElement == null) {
                MyVisitor.$$$reportNull$$$0(14);
            }
            if ((settingValue = this.languageSettings.ENFORCE_TRAILING_COMMA) == JSCodeStyleSettings.TrailingCommaOption.Keep) {
                return;
            }
            if (lastListElement == null || !this.containedInRange((PsiElement)lastListElement)) {
                return;
            }
            PsiElement afterList = JSPsiImplUtils.findNextCodeElement(lastListElement);
            if (afterList instanceof OuterLanguageElement || afterList != null && JSPsiImplUtils.findNextCodeElement(afterList) instanceof OuterLanguageElement) {
                return;
            }
            if (settingValue == JSCodeStyleSettings.TrailingCommaOption.Remove) {
                if (JSEnforceCodeStylePostProcessor.isComma(afterList)) {
                    this.deleteNode(afterList.getNode());
                }
            } else if (settingValue == JSCodeStyleSettings.TrailingCommaOption.WhenMultiline) {
                PsiElement whitespaceToCheck;
                PsiElement parent = lastListElement.getParent();
                if (parent == null) {
                    return;
                }
                ASTNode rBracket = parent.getNode().findChildByType(rBracketType);
                ASTNode beforeBracketNode = rBracket != null ? rBracket.getTreePrev() : null;
                PsiElement psiElement = whitespaceToCheck = beforeBracketNode != null ? beforeBracketNode.getPsi() : null;
                if (JSEnforceCodeStylePostProcessor.isComma(afterList)) {
                    if (!JSEnforceCodeStylePostProcessor.isNewLineWS(whitespaceToCheck)) {
                        this.deleteNode(afterList.getNode());
                    }
                } else if (JSEnforceCodeStylePostProcessor.isNewLineWS(whitespaceToCheck) && shouldAddToLastElement.value(lastListElement)) {
                    this.insertString(lastListElement.getTextRange().getEndOffset(), ",");
                }
            }
        }

        private void insertString(int offset, String result2) {
            int actualOffset = this.myPostProcessorHelper.mapOffset(offset);
            this.myDocument.insertString(actualOffset, (CharSequence)result2);
            this.myPostProcessorHelper.updateResultRange(0, result2.length());
        }

        private void deleteNode(ASTNode node) {
            TextRange range = node.getTextRange();
            this.replaceRange(range.getStartOffset(), range.getEndOffset(), "");
        }

        private void replaceRange(int start, int end, String result2) {
            int mappedStart = this.myPostProcessorHelper.mapOffset(start);
            int mappedEnd = this.myPostProcessorHelper.mapOffset(end);
            this.myDocument.replaceString(mappedStart, mappedEnd, (CharSequence)result2);
            this.myPostProcessorHelper.updateResultRange(mappedEnd - mappedStart, result2.length());
        }

        private boolean containedInRange(@NotNull PsiElement element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(15);
            }
            return this.myOriginalRange.contains(element.getTextRange());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageDialect";
                    break;
                }
                case 5: 
                case 6: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listChildren";
                    break;
                }
                case 9: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rBracketType";
                    break;
                }
                case 10: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shouldAddToLastElement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyJSXQuoteStyle";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyJavaScriptQuoteStyle";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applySemicolonStyle";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyTrailingCommaStyle";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "containedInRange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

