/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.FormattableInjectedBlockInJS;
import com.intellij.lang.javascript.formatter.JSBinaryExpressionBlock;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSFormatterUtil;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.lang.javascript.formatter.blocks.JSBlockEx;
import com.intellij.lang.javascript.formatter.blocks.JSParameterBlock;
import com.intellij.lang.javascript.formatter.blocks.JSParameterListBlock;
import com.intellij.lang.javascript.formatter.blocks.SubBlockVisitor;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.inject.JSFormattableInjectionUtil;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.typescript.formatter.blocks.TypedJSBlock;
import com.intellij.lang.typescript.formatter.blocks.TypedJSParameterBlock;
import com.intellij.lang.typescript.formatter.blocks.TypedJSParameterListBlock;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.webcore.formatter.chainedMethods.CallChainDotBlock;
import com.intellij.xml.template.formatter.TemplateFormatUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBlockContext {
    private final CommonCodeStyleSettings myCommonSettings;
    private final CodeStyleSettings myTopSettings;
    private final Language myDialect;
    @Nullable
    private XmlFormattingPolicy myPolicy;
    private final JSCodeStyleSettings myDialectSettings;
    @NotNull
    private final FormattingMode myFormattingMode;

    public JSBlockContext(@NotNull CodeStyleSettings topSettings, @NotNull Language dialect, @Nullable JSCodeStyleSettings explicitSettings, @NotNull FormattingMode formattingMode) {
        if (topSettings == null) {
            JSBlockContext.$$$reportNull$$$0(0);
        }
        if (dialect == null) {
            JSBlockContext.$$$reportNull$$$0(1);
        }
        if (formattingMode == null) {
            JSBlockContext.$$$reportNull$$$0(2);
        }
        this.myTopSettings = topSettings;
        this.myFormattingMode = formattingMode;
        this.myDialectSettings = explicitSettings != null ? explicitSettings : (JSCodeStyleSettings)topSettings.getCustomSettings(JSCodeStyleSettings.getSettingsClass(dialect));
        this.myCommonSettings = topSettings.getCommonSettings(dialect);
        this.myDialect = dialect;
    }

    public void setXmlFormattingPolicy(XmlFormattingPolicy xmlFormattingPolicy) {
        this.myPolicy = xmlFormattingPolicy;
    }

    @NotNull
    public static JSBlockContext createDefault(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            JSBlockContext.$$$reportNull$$$0(3);
        }
        JSBlockContext jSBlockContext = new JSBlockContext(settings, (Language)JavascriptLanguage.INSTANCE, null, FormattingMode.REFORMAT);
        if (jSBlockContext == null) {
            JSBlockContext.$$$reportNull$$$0(4);
        }
        return jSBlockContext;
    }

    @NotNull
    public FormattingMode getFormattingMode() {
        FormattingMode formattingMode = this.myFormattingMode;
        if (formattingMode == null) {
            JSBlockContext.$$$reportNull$$$0(5);
        }
        return formattingMode;
    }

    public CodeStyleSettings getTopSettings() {
        return this.myTopSettings;
    }

    public Language getDialect() {
        return this.myDialect;
    }

    public JSCodeStyleSettings getDialectSettings() {
        return this.myDialectSettings;
    }

    public CommonCodeStyleSettings getCommonSettings() {
        return this.myCommonSettings;
    }

    @NotNull
    public Block createBlock(@NotNull ASTNode child, @Nullable Wrap wrap, @Nullable Alignment childAlignment, @Nullable Indent childIndent, @Nullable ASTNodeBasedAlignmentFactory alignmentFactory, @Nullable JSBlock parentBlock) {
        Block outerLangBlock;
        if (child == null) {
            JSBlockContext.$$$reportNull$$$0(6);
        }
        if (child instanceof JSXmlLiteralExpressionImpl && this.myPolicy != null) {
            SubBlockVisitor.JSXmlTagBlock jSXmlTagBlock = new SubBlockVisitor.JSXmlTagBlock(child, wrap, childAlignment, this.myPolicy, childIndent, parentBlock);
            if (jSXmlTagBlock == null) {
                JSBlockContext.$$$reportNull$$$0(7);
            }
            return jSXmlTagBlock;
        }
        if (child.getElementType() == JSStubElementTypes.STRING_TEMPLATE_EXPRESSION && parentBlock != null && parentBlock.processInjections() && JSFormattableInjectionUtil.hostContainsFormattableInjection(child.getPsi())) {
            FormattableInjectedBlockInJS formattableInjectedBlockInJS = new FormattableInjectedBlockInJS(child, childAlignment, childIndent, wrap, this.myTopSettings);
            if (formattableInjectedBlockInJS == null) {
                JSBlockContext.$$$reportNull$$$0(8);
            }
            return formattableInjectedBlockInJS;
        }
        Block block = outerLangBlock = child.getPsi() instanceof OuterLanguageElement ? TemplateFormatUtil.buildTemplateLanguageBlock((OuterLanguageElement)((OuterLanguageElement)child.getPsi()), (CodeStyleSettings)this.myTopSettings, (Indent)childIndent) : null;
        if (outerLangBlock != null) {
            Block block2 = outerLangBlock;
            if (block2 == null) {
                JSBlockContext.$$$reportNull$$$0(9);
            }
            return block2;
        }
        JSBlock jSBlock = this.createSubBlock(child, childAlignment, childIndent, wrap, alignmentFactory, parentBlock);
        if (jSBlock == null) {
            JSBlockContext.$$$reportNull$$$0(10);
        }
        return jSBlock;
    }

    @NotNull
    protected JSBlock createSubBlock(@NotNull ASTNode child, Alignment childAlignment, Indent childIndent, Wrap wrap, ASTNodeBasedAlignmentFactory sharedAlignmentFactory, @Nullable JSBlock parentBlock) {
        IElementType childType;
        if (child == null) {
            JSBlockContext.$$$reportNull$$$0(11);
        }
        if ((childType = child.getElementType()) == JSElementTypes.BINARY_EXPRESSION && JSBlockContext.indentBinaryAsBlock(child, parentBlock)) {
            JSBinaryExpressionBlock jSBinaryExpressionBlock = new JSBinaryExpressionBlock(child, childAlignment, wrap, sharedAlignmentFactory, this);
            if (jSBinaryExpressionBlock == null) {
                JSBlockContext.$$$reportNull$$$0(12);
            }
            return jSBinaryExpressionBlock;
        }
        if (childType == JSElementTypes.ARGUMENT_LIST) {
            JSBlock jSBlock = this.createParameterListBLock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory);
            if (jSBlock == null) {
                JSBlockContext.$$$reportNull$$$0(13);
            }
            return jSBlock;
        }
        ASTNode parent = child.getTreeParent();
        if (parent != null) {
            IElementType parentType = parent.getElementType();
            if (parentType == JSElementTypes.ARGUMENT_LIST) {
                if (childType != JSTokenTypes.LPAR && (childType != JSTokenTypes.RPAR || JSFormatterUtil.isEnterAtNewArgument(this.myFormattingMode, child)) && childType != JSTokenTypes.COMMA) {
                    JSBlock jSBlock = this.createParameterBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory);
                    if (jSBlock == null) {
                        JSBlockContext.$$$reportNull$$$0(14);
                    }
                    return jSBlock;
                }
            } else if (parentType == JSElementTypes.REFERENCE_EXPRESSION && (childType == JSTokenTypes.DOT || childType == JSTokenTypes.ELVIS || childType == JSElementTypes.DOT_SHARP)) {
                JSDotBlock jSDotBlock = new JSDotBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory, this);
                if (jSDotBlock == null) {
                    JSBlockContext.$$$reportNull$$$0(15);
                }
                return jSDotBlock;
            }
        }
        JSBlock jSBlock = this.createJSSubBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory);
        if (jSBlock == null) {
            JSBlockContext.$$$reportNull$$$0(16);
        }
        return jSBlock;
    }

    private static boolean indentBinaryAsBlock(@NotNull ASTNode child, JSBlock parentBlock) {
        ASTNode parent;
        if (child == null) {
            JSBlockContext.$$$reportNull$$$0(17);
        }
        if ((parent = child.getTreeParent()) == null || parentBlock == null) {
            return false;
        }
        IElementType parentElementType = parent.getElementType();
        return parentElementType == JSStubElementTypes.RETURN_STATEMENT || parentElementType == JSElementTypes.ARGUMENT_LIST || parentElementType == JSElementTypes.PARENTHESIZED_EXPRESSION && !SubBlockVisitor.shouldIndentParenthesized(parent) || parentElementType == JSStubElementTypes.ASSIGNMENT_EXPRESSION || JSElementTypes.FUNCTION_EXPRESSIONS.contains(parentElementType) || JSElementTypes.IF_STATEMENT == parentElementType || JSElementTypes.BODY_VARIABLES.contains(parentElementType) || parentElementType == JSElementTypes.CONDITIONAL_EXPRESSION && child != parent.getFirstChildNode();
    }

    @NotNull
    private JSBlock createParameterListBLock(@NotNull ASTNode child, Alignment childAlignment, Indent childIndent, Wrap wrap, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory) {
        if (child == null) {
            JSBlockContext.$$$reportNull$$$0(18);
        }
        if (JSBlockContext.isTypedJSDialect(this.myDialect)) {
            TypedJSParameterListBlock typedJSParameterListBlock = new TypedJSParameterListBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory, this);
            if (typedJSParameterListBlock == null) {
                JSBlockContext.$$$reportNull$$$0(19);
            }
            return typedJSParameterListBlock;
        }
        JSParameterListBlock jSParameterListBlock = new JSParameterListBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory, this);
        if (jSParameterListBlock == null) {
            JSBlockContext.$$$reportNull$$$0(20);
        }
        return jSParameterListBlock;
    }

    @NotNull
    private JSBlock createParameterBlock(@NotNull ASTNode child, Alignment childAlignment, Indent childIndent, Wrap wrap, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory) {
        if (child == null) {
            JSBlockContext.$$$reportNull$$$0(21);
        }
        if (JSBlockContext.isTypedJSDialect(this.myDialect)) {
            TypedJSParameterBlock typedJSParameterBlock = new TypedJSParameterBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory, this);
            if (typedJSParameterBlock == null) {
                JSBlockContext.$$$reportNull$$$0(22);
            }
            return typedJSParameterBlock;
        }
        JSParameterBlock jSParameterBlock = new JSParameterBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory, this);
        if (jSParameterBlock == null) {
            JSBlockContext.$$$reportNull$$$0(23);
        }
        return jSParameterBlock;
    }

    @NotNull
    private JSBlock createJSSubBlock(@NotNull ASTNode child, Alignment childAlignment, Indent childIndent, Wrap wrap, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory) {
        if (child == null) {
            JSBlockContext.$$$reportNull$$$0(24);
        }
        if (JSBlockContext.isTypedJSDialect(this.myDialect)) {
            TypedJSBlock typedJSBlock = new TypedJSBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory, this);
            if (typedJSBlock == null) {
                JSBlockContext.$$$reportNull$$$0(25);
            }
            return typedJSBlock;
        }
        JSBlockEx jSBlockEx = new JSBlockEx(child, childAlignment, childIndent, wrap, sharedAlignmentFactory, this);
        if (jSBlockEx == null) {
            JSBlockContext.$$$reportNull$$$0(26);
        }
        return jSBlockEx;
    }

    private static boolean isTypedJSDialect(@NotNull Language dialect) {
        if (dialect == null) {
            JSBlockContext.$$$reportNull$$$0(27);
        }
        return dialect == JavaScriptSupportLoader.FLOW_JS || dialect.isKindOf((Language)JavaScriptSupportLoader.TYPESCRIPT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topSettings";
                break;
            }
            case 1: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingMode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/JSBlockContext";
                break;
            }
            case 6: 
            case 11: 
            case 17: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/JSBlockContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefault";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormattingMode";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createBlock";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubBlock";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterListBLock";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterBlock";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createJSSubBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDefault";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createBlock";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createSubBlock";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "indentBinaryAsBlock";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createParameterListBLock";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createParameterBlock";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createJSSubBlock";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isTypedJSDialect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JSDotBlock
    extends JSBlockEx
    implements CallChainDotBlock {
        public JSDotBlock(@NotNull ASTNode node, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable Wrap wrap, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory, @NotNull JSBlockContext jsBlockContext) {
            if (node == null) {
                JSDotBlock.$$$reportNull$$$0(0);
            }
            if (jsBlockContext == null) {
                JSDotBlock.$$$reportNull$$$0(1);
            }
            super(node, alignment, indent, wrap, sharedAlignmentFactory, jsBlockContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "jsBlockContext";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/formatter/JSBlockContext$JSDotBlock";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

