/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.findUsages;

import com.intellij.codeInsight.highlighting.HighlightUsagesDescriptionLocation;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.findUsages.JavaScriptFindUsagesProvider;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewShortNameLocation;
import org.jetbrains.annotations.NotNull;

public class JavaScriptUsageViewDescriptionProvider
implements ElementDescriptionProvider {
    public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
        if (element == null) {
            JavaScriptUsageViewDescriptionProvider.$$$reportNull$$$0(0);
        }
        if (location == null) {
            JavaScriptUsageViewDescriptionProvider.$$$reportNull$$$0(1);
        }
        if (location instanceof UsageViewLongNameLocation) {
            if (element instanceof JSPackageWrapper || element instanceof JSPackageStatement || element instanceof JSClass || element instanceof JSVariable || element instanceof JSFunction) {
                return JSFormatUtil.formatEntityDescription(element, ((JSQualifiedNamedElement)element).getQualifiedName(), true);
            }
            if (DialectDetector.languageOfElement(element).isKindOf((Language)JavascriptLanguage.INSTANCE)) {
                return JavaScriptUsageViewDescriptionProvider.defaultElementDescription(element);
            }
        } else if (location instanceof UsageViewShortNameLocation) {
            if (element instanceof JSNamedElement) {
                return StringUtil.notNullize((String)((JSNamedElement)element).getName());
            }
        } else if (element instanceof JSNamedElement && location instanceof HighlightUsagesDescriptionLocation) {
            return JavaScriptUsageViewDescriptionProvider.defaultElementDescription(element);
        }
        return null;
    }

    private static String defaultElementDescription(PsiElement element) {
        JavaScriptFindUsagesProvider usagesProvider = new JavaScriptFindUsagesProvider();
        return usagesProvider.getType(element) + " " + usagesProvider.getDescriptiveName(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "location";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/findUsages/JavaScriptUsageViewDescriptionProvider";
        objectArray[2] = "getElementDescription";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

