/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeWithSignature;
import com.intellij.lang.javascript.ecmascript6.types.TypeScriptOverloadContextualType;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitOverloadedAliasElement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElementWithBackingItem;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCacheService;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptSignatureChooser {
    private static final Comparator<PsiElement> FUNCTIONS_FIRST = Comparator.comparing(el -> el instanceof TypeScriptCompileTimeType ? 1 : -1).thenComparing(el -> el instanceof TypeScriptModule ? 1 : -1);
    public static final Comparator<ResolveResult> FUNCTIONS_FIRST_RESOLVE_RESULT = (o1, o2) -> FUNCTIONS_FIRST.compare(o1.getElement(), o2.getElement());
    public static final int HAS_REST_ARG = Integer.MAX_VALUE;

    @NotNull
    public static JSResolveResult checkParameterTypes(@NotNull PsiElement candidate, @Nullable List<JSType> argumentTypes, @NotNull NullableLazyValue<JSType> qualifierType, @Nullable JSTypeSubstitutor genericArguments, boolean isNewExpression) {
        if (candidate == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(0);
        }
        if (qualifierType == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(1);
        }
        if (!(candidate instanceof JSFunction)) {
            JSResolveResult jSResolveResult = new JSResolveResult(candidate);
            if (jSResolveResult == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(2);
            }
            return jSResolveResult;
        }
        if (candidate instanceof TypeScriptFunction && ((TypeScriptFunction)candidate).isOverloadImplementation()) {
            JSResolveResult jSResolveResult = TypeScriptSignatureChooser.getOverloadSignatureForImplementation(candidate, argumentTypes, qualifierType, genericArguments, isNewExpression);
            if (jSResolveResult == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(3);
            }
            return jSResolveResult;
        }
        JSFunction jsFunction = (JSFunction)candidate;
        JSParameterList parameterList = jsFunction.isConstructor() == isNewExpression ? jsFunction.getParameterList() : null;
        JSResolveResult jSResolveResult = new JSResolveResult(candidate, null, TypeScriptSignatureChooser.checkParameterTypes(candidate, argumentTypes, qualifierType, genericArguments, parameterList));
        if (jSResolveResult == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(4);
        }
        return jSResolveResult;
    }

    @NotNull
    public static JSResolveResult getOverloadSignatureForImplementation(@NotNull PsiElement functionCandidate, @Nullable List<JSType> argumentTypes, @NotNull NullableLazyValue<JSType> qualifierType, @Nullable JSTypeSubstitutor substitutor, boolean isNewExpression) {
        if (functionCandidate == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(5);
        }
        if (qualifierType == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(6);
        }
        List overloads = ((TypeScriptFunction)functionCandidate).getOverloadDeclarations();
        String firstError = null;
        TypeScriptFunction firstOverload = null;
        for (TypeScriptFunction overload : overloads) {
            if (overload.isConstructor() != isNewExpression) continue;
            String latestError = TypeScriptSignatureChooser.checkParameterTypes(functionCandidate, argumentTypes, qualifierType, substitutor, overload.getParameterList());
            if (latestError == null) {
                JSResolveResult jSResolveResult = new JSResolveResult((PsiElement)overload);
                if (jSResolveResult == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(7);
                }
                return jSResolveResult;
            }
            if (firstError != null) continue;
            firstError = latestError;
            firstOverload = overload;
        }
        PsiElement resultFunction = functionCandidate;
        if (firstError != null) {
            resultFunction = firstOverload;
        }
        JSResolveResult jSResolveResult = new JSResolveResult(resultFunction, null, firstError);
        if (jSResolveResult == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(8);
        }
        return jSResolveResult;
    }

    public static boolean isOverloadImplementation(@Nullable PsiElement function) {
        return function instanceof TypeScriptFunction && ((TypeScriptFunction)function).isOverloadImplementation();
    }

    @NotNull
    public static List<JSParameterTypeDecorator> getTypeDecoratorsWithAppliedGenerics(@NotNull JSParameterItem[] parameters, @Nullable JSTypeSubstitutor genericArguments) {
        if (parameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(9);
        }
        ArrayList<JSParameterTypeDecorator> parameterTypes = new ArrayList<JSParameterTypeDecorator>();
        for (JSParameterItem p : parameters) {
            JSType parameterType = p.getType();
            if (parameterType != null) {
                parameterType = JSTypeUtils.applyGenericArguments(parameterType, (Map<String, JSType>)genericArguments);
            }
            JSParameterTypeDecoratorImpl typeDecorator = new JSParameterTypeDecoratorImpl(parameterType, p.isOptional(), p.isRest(), p.getTypeDecorator().isExplicitlyDeclared());
            parameterTypes.add(typeDecorator);
        }
        ArrayList<JSParameterTypeDecorator> arrayList = parameterTypes;
        if (arrayList == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Nullable
    public static String checkParameterTypes(@NotNull PsiElement context, @Nullable List<JSType> argumentTypes, @NotNull NullableLazyValue<JSType> qualifierType, @Nullable JSTypeSubstitutor genericArguments, @Nullable JSParameterList parameterList) {
        if (context == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(11);
        }
        if (qualifierType == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(12);
        }
        if (parameterList == null) {
            return null;
        }
        List<JSParameterTypeDecorator> functionParameters = TypeScriptSignatureChooser.getTypeDecoratorsWithAppliedGenerics((JSParameterItem[])parameterList.getParameters(), genericArguments);
        return TypeScriptSignatureChooser.checkParameterTypes(context, ContainerUtil.notNullize(argumentTypes), qualifierType, functionParameters);
    }

    @Nullable
    private static String checkParameterTypes(@NotNull PsiElement contextFunctionOrElement, @NotNull List<JSType> argumentTypes, @Nullable NullableLazyValue<JSType> qualifierLazyType, @NotNull List<JSParameterTypeDecorator> functionParameters) {
        JSType thisType;
        JSType qualifierType;
        if (contextFunctionOrElement == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(13);
        }
        if (argumentTypes == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(14);
        }
        if (functionParameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(15);
        }
        ProcessingContext processingContext = JSTypeComparingCacheService.getProcessingContextWithCache(contextFunctionOrElement);
        processingContext.put(JSTypeBaseImpl.CALL_ENV_KEY, (Object)true);
        List<JSParameterTypeDecorator> arguments = JSTypeUtils.getParameterTypeDecorators(argumentTypes);
        if (!JSTypeUtils.areArgumentsAssignable(functionParameters, arguments, processingContext, false, false, true)) {
            return "javascript.argument.types.mismatch";
        }
        if (!(contextFunctionOrElement instanceof TypeScriptFunction)) {
            return null;
        }
        TypeScriptFunction tsFunction = (TypeScriptFunction)contextFunctionOrElement;
        JSType jSType = qualifierType = qualifierLazyType != null ? (JSType)qualifierLazyType.getValue() : null;
        if (qualifierType != null && (thisType = tsFunction.getExplicitThisType()) != null && !thisType.isDirectlyAssignableType(qualifierType, processingContext)) {
            return "javascript.argument.types.mismatch";
        }
        List<JSType> types = functionParameters.stream().map(el -> el.getType()).collect(Collectors.toList());
        if (TypeScriptGenericTypesEvaluator.getInstance().hasGenericsCompatibilityErrors(types, argumentTypes, tsFunction)) {
            return "javascript.argument.types.mismatch";
        }
        return null;
    }

    @Nullable
    public static JSFunction getFunctionWithParameters(@NotNull JSCallExpression expression, @NotNull Collection<JSFunction> functions) {
        if (expression == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(16);
        }
        if (functions == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(17);
        }
        return TypeScriptSignatureChooser.getFunctionWithParameters(expression, functions, null);
    }

    @Nullable
    public static <T extends JSFunctionItem> T getFunctionWithParameters(@NotNull JSCallExpression expression, @NotNull Collection<T> functions, @Nullable JSTypeSubstitutor substitutor) {
        if (expression == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(18);
        }
        if (functions == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(19);
        }
        List<JSType> argumentTypes = JSTypeUtils.getArgumentTypes(expression.getArgumentList());
        for (JSFunctionItem constructor : functions) {
            List<JSParameterTypeDecorator> parameters = TypeScriptSignatureChooser.getTypeDecoratorsWithAppliedGenerics(constructor.getParameters(), substitutor);
            if (TypeScriptSignatureChooser.checkParameterTypes((PsiElement)expression, argumentTypes, null, parameters) != null) continue;
            return (T)constructor;
        }
        return null;
    }

    @NotNull
    public static List<JSFunctionWithSubstitutor> resolveConstructorOrCallSignature(@NotNull PsiElement referenceExpression) {
        PsiElement functionCandidate;
        List<JSFunctionItem> resolveElements;
        if (referenceExpression == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(20);
        }
        if (!(referenceExpression instanceof JSReferenceExpression) || !(referenceExpression.getParent() instanceof JSCallExpression)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(21);
            }
            return list;
        }
        JSCallExpression callExpression = (JSCallExpression)referenceExpression.getParent();
        JSReferenceExpression element = (JSReferenceExpression)referenceExpression;
        ResolveResult[] resolveResults = element.multiResolve(false);
        boolean hasAliases = Arrays.stream(resolveResults).anyMatch(r -> r.getElement() instanceof TypeScriptProxyImplicitElementWithBackingItem);
        if (hasAliases) {
            resolveResults = TypeScriptImplicitOverloadedAliasElement.unwrapElements(resolveResults);
        }
        List<PsiElement> elements = JSResolveResult.toElements(resolveResults);
        if (callExpression instanceof JSNewExpression && (resolveElements = TypeScriptSignatureChooser.getConstructorsForResolveElements((JSExpression)referenceExpression, elements)).size() > 0) {
            List<JSFunctionWithSubstitutor> list = resolveElements.stream().map(JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR).collect(Collectors.toList());
            if (list == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(22);
            }
            return list;
        }
        if (elements.size() == 1 && (functionCandidate = (PsiElement)ContainerUtil.getFirstItem(elements)) != null && (!(functionCandidate instanceof JSFunction) || hasAliases) && DialectDetector.isTypeScript(functionCandidate)) {
            List<JSFunctionWithSubstitutor> list = TypeScriptSignatureChooser.getCallSignatures(functionCandidate, callExpression);
            if (list == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(23);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    private static List<JSFunctionItem> getConstructorsForResolveElements(@NotNull JSExpression parent, @NotNull Collection<PsiElement> elements) {
        if (parent == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(25);
        }
        if (elements == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(26);
        }
        if (!elements.isEmpty()) {
            List result2 = ContainerUtil.newSmartList();
            for (PsiElement psiElement : elements) {
                ResolveResult[] results;
                List<PsiElement> resolvedElements;
                if (!(psiElement instanceof JSClass) || (resolvedElements = JSResolveResult.toElements(results = JSClassUtils.resolveES6Constructor((JSClass)psiElement, parent))).isEmpty()) continue;
                result2.addAll(resolvedElements);
            }
            if (result2.size() > 0) {
                List list = ContainerUtil.mapNotNull((Collection)result2, el -> el instanceof JSFunctionItem ? (JSFunctionItem)el : null);
                if (list == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(27);
                }
                return list;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    private static List<JSFunctionWithSubstitutor> getCallSignatures(@NotNull PsiElement functionCandidate, @NotNull JSCallExpression callExpression) {
        if (functionCandidate == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(29);
        }
        if (callExpression == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(30);
        }
        JSTypeSubstitutor substitutor = TypeScriptGenericTypesEvaluator.addExplicitGenericArgumentsFromCall(functionCandidate, (PsiElement)callExpression, null);
        Collection<JSFunctionWithSubstitutor> functionWithSubstitutors = JSPsiImplUtils.calculatePossibleFunctions(functionCandidate, (PsiElement)callExpression);
        List functionItems = functionWithSubstitutors.stream().map(el -> el.myFunctionItem).collect(Collectors.toList());
        Object functionItem = TypeScriptSignatureChooser.getFunctionWithParameters(callExpression, functionItems, substitutor);
        if (functionItem != null) {
            for (JSFunctionWithSubstitutor withSubstitutor : functionWithSubstitutors) {
                if (withSubstitutor.myFunctionItem != functionItem) continue;
                List list = ContainerUtil.createMaybeSingletonList((Object)withSubstitutor);
                if (list == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(31);
                }
                return list;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(32);
        }
        return list;
    }

    public static int getMinArgumentCount(@NotNull List<JSParameterTypeDecorator> parameters) {
        if (parameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(33);
        }
        if (parameters.size() == 0) {
            return 0;
        }
        int minArgumentCount = 0;
        for (JSParameterTypeDecorator element : parameters) {
            if (element.isOptional() || element.isRest()) break;
            ++minArgumentCount;
        }
        return minArgumentCount;
    }

    public static int getMaxArgumentCount(@NotNull List<JSParameterTypeDecorator> parameters) {
        int size;
        if (parameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(34);
        }
        if ((size = parameters.size()) == 0) {
            return 0;
        }
        JSParameterTypeDecorator lastParameter = (JSParameterTypeDecorator)ContainerUtil.getLastItem(parameters);
        return lastParameter != null && lastParameter.isRest() ? Integer.MAX_VALUE : size;
    }

    public static int getMinArgumentCount(@NotNull JSParameterItem[] parameters) {
        if (parameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(35);
        }
        if (parameters.length == 0) {
            return 0;
        }
        int minArgumentCount = 0;
        for (JSParameterItem element : parameters) {
            if (element.isOptional() || element.isRest()) break;
            ++minArgumentCount;
        }
        return minArgumentCount;
    }

    public static int getMaxArgumentCount(@NotNull JSParameterItem[] parameters) {
        int length;
        if (parameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(36);
        }
        if ((length = parameters.length) == 0) {
            return 0;
        }
        JSParameterItem lastParameter = (JSParameterItem)ArrayUtil.getLastElement((Object[])parameters);
        return lastParameter != null && lastParameter.isRest() ? Integer.MAX_VALUE : length;
    }

    @Nullable
    public static JSRecordType.CallSignature findMatchedSignature(@NotNull List<JSRecordType.CallSignature> signatures, @NotNull JSRecordType.CallSignature signature, boolean partialMatch, boolean ignoreReturnType) {
        if (signatures == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(37);
        }
        if (signature == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(38);
        }
        for (JSRecordType.CallSignature type : signatures) {
            if (!TypeScriptSignatureChooser.compareSignaturesIdentical(type, signature, partialMatch, ignoreReturnType)) continue;
            return type;
        }
        return null;
    }

    @NotNull
    public static List<JSRecordType.CallSignature> findMatchingSignatures(@NotNull List<List<JSRecordType.CallSignature>> table, @NotNull JSRecordType.CallSignature signature, int workingIndex) {
        if (table == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(39);
        }
        if (signature == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(40);
        }
        List result2 = ContainerUtil.newSmartList();
        for (int i = 0; i < table.size(); ++i) {
            JSRecordType.CallSignature matched;
            List<JSRecordType.CallSignature> signatures = table.get(i);
            JSRecordType.CallSignature callSignature = matched = i == workingIndex ? signature : TypeScriptSignatureChooser.findMatchedSignature(signatures, signature, true, true);
            if (matched == null) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(41);
                }
                return list;
            }
            result2.add(matched);
        }
        List list = result2;
        if (list == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(42);
        }
        return list;
    }

    private static boolean compareSignaturesIdentical(@NotNull JSRecordType.CallSignature source, @NotNull JSRecordType.CallSignature target, boolean partialMatch, boolean ignoreReturnType) {
        if (source == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(43);
        }
        if (target == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(44);
        }
        if (source.isEquivalentTo((JSRecordType.TypeMember)target, true)) {
            return true;
        }
        if (!TypeScriptSignatureChooser.isMatchingSignature(source, target, partialMatch)) {
            return false;
        }
        List lParameters = source.getParameterTypeDecorators();
        List rParameters = target.getParameterTypeDecorators();
        int rLength = rParameters.size();
        PsiElement element = source.getMemberSource().getSingleElement();
        for (int i = 0; i < lParameters.size(); ++i) {
            JSType rParameterType;
            JSParameterTypeDecorator lDecorator = (JSParameterTypeDecorator)lParameters.get(i);
            JSParameterTypeDecorator rDecorator = rLength > i ? (JSParameterTypeDecorator)rParameters.get(i) : null;
            JSType lParameterType = lDecorator.getType();
            JSType jSType = rParameterType = rDecorator == null ? TypeScriptSignatureChooser.getRestComponentType(rParameters, element) : rDecorator.getType();
            if (TypeScriptTypeRelations.isTypeRelatedTo(lParameterType, rParameterType, null)) continue;
            return false;
        }
        if (!ignoreReturnType) {
            JSType sourceReturnType = source.getReturnType();
            JSType targetReturnType = target.getReturnType();
            return TypeScriptTypeRelations.isTypeRelatedTo(sourceReturnType, targetReturnType, null);
        }
        return true;
    }

    @Nullable
    public static JSType getRestComponentType(@NotNull List<JSParameterTypeDecorator> parameters, PsiElement context) {
        int size;
        if (parameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(45);
        }
        if ((size = parameters.size()) == 0) {
            return null;
        }
        JSParameterTypeDecorator last = parameters.get(size - 1);
        return last.isRest() && last.getType() != null ? JSTypeUtils.getIndexableComponentType(last.getType()) : JSAnyType.get(context, true);
    }

    public static boolean isMatchingSignature(@NotNull JSRecordType.CallSignature source, @NotNull JSRecordType.CallSignature target, boolean partial) {
        if (source == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(46);
        }
        if (target == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(47);
        }
        List sourceParameters = source.getParameterTypeDecorators();
        int minSource = TypeScriptSignatureChooser.getMinArgumentCount(sourceParameters);
        List targetParameters = target.getParameterTypeDecorators();
        int minTarget = TypeScriptSignatureChooser.getMinArgumentCount(targetParameters);
        boolean sourceHasRestParameter = TypeScriptSignatureChooser.hasRestParameter(sourceParameters);
        boolean targetHasRestParameter = TypeScriptSignatureChooser.hasRestParameter(targetParameters);
        if (sourceParameters.size() == targetParameters.size() && minSource == minTarget && sourceHasRestParameter == targetHasRestParameter) {
            return true;
        }
        if (partial && minSource <= minTarget) {
            if (sourceHasRestParameter && !targetHasRestParameter) {
                return true;
            }
            if (sourceHasRestParameter == targetHasRestParameter) {
                return sourceParameters.size() >= targetParameters.size();
            }
        }
        return false;
    }

    private static boolean hasRestParameter(@NotNull List<JSParameterTypeDecorator> parameters) {
        if (parameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(48);
        }
        return parameters.size() != 0 && parameters.get(parameters.size() - 1).isRest();
    }

    @Nullable
    public static JSType mapContextualTypeForOverload(@Nullable JSType jsType, @Nullable PsiElement functionCandidate) {
        if (jsType == null) {
            return null;
        }
        return jsType.transformTypeHierarchy(el -> {
            if (el instanceof TypeScriptOverloadContextualType) {
                TypeScriptOverloadContextualType contextualType = (TypeScriptOverloadContextualType)el;
                if (functionCandidate != null) {
                    for (JSTypeWithSignature signature : contextualType.getTypes()) {
                        if (!functionCandidate.getManager().areElementsEquivalent(functionCandidate, (PsiElement)signature.getFunction())) continue;
                        return signature.evaluateGenerics(contextualType.getExpression(), contextualType.getIndex());
                    }
                }
                return contextualType.asCompositeWithAppliedGenerics();
            }
            return el;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 41: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 41: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 1: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser";
                break;
            }
            case 5: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionCandidate";
                break;
            }
            case 9: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFunctionOrElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionParameters";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatures";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "checkParameterTypes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverloadSignatureForImplementation";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeDecoratorsWithAppliedGenerics";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveConstructorOrCallSignature";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorsForResolveElements";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallSignatures";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "findMatchingSignatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkParameterTypes";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 41: 
            case 42: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOverloadSignatureForImplementation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTypeDecoratorsWithAppliedGenerics";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionWithParameters";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstructorOrCallSignature";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorsForResolveElements";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getCallSignatures";
                break;
            }
            case 33: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getMinArgumentCount";
                break;
            }
            case 34: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getMaxArgumentCount";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findMatchedSignature";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingSignatures";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "compareSignaturesIdentical";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getRestComponentType";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingSignature";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "hasRestParameter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 41: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

