/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptReferenceContributor
extends PsiReferenceContributor {
    public static final Pattern TYPESCRIPT_REFERENCE_PATH = Pattern.compile("^///\\s*<\\s*reference\\s*path\\s*=\\s*(['\"])([^'\"]+)\\1[^/]*\\s*/>.*$");
    public static final ElementPattern<JSLiteralExpression> AUGMENTATION_REF = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(JSLiteralExpression.class).withParent(TypeScriptModule.class)).with((PatternCondition)new PatternCondition<JSLiteralExpression>("TypeScript.declare.augmentation"){

        public boolean accepts(@NotNull JSLiteralExpression expression, ProcessingContext context) {
            PsiElement parent;
            if (expression == null) {
                1.$$$reportNull$$$0(0);
            }
            if (!((parent = expression.getParent()) instanceof TypeScriptModule)) {
                return false;
            }
            return ((TypeScriptModule)parent).isAugmentation() && ((TypeScriptModule)parent).getNameIdentifier() == expression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$1", "accepts"));
        }
    });

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            TypeScriptReferenceContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider(AUGMENTATION_REF, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    2.$$$reportNull$$$0(1);
                }
                JSLiteralExpression literalExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)element, JSLiteralExpression.class);
                PsiReference[] psiReferenceArray = JSModuleReferenceContributor.getReferencesForStringLiteral(literalExpression, this, false);
                if (psiReferenceArray == null) {
                    2.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiComment().withElementType(JSTokenTypes.END_OF_LINE_COMMENT)).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                PsiElement psiElement = (PsiElement)element;
                if (!DialectDetector.isTypeScript(psiElement)) {
                    return false;
                }
                String text = psiElement.getText();
                return TYPESCRIPT_REFERENCE_PATH.matcher(text).matches();
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        })), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
                if (psiElement == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (processingContext == null) {
                    3.$$$reportNull$$$0(1);
                }
                PsiComment comment = (PsiComment)ObjectUtils.tryCast((Object)psiElement, PsiComment.class);
                Matcher matcher = TYPESCRIPT_REFERENCE_PATH.matcher(psiElement.getText());
                if (comment != null && matcher.find()) {
                    String fileName = matcher.group(2);
                    FileReference[] fileReferenceArray = new FileReferenceSetWithDefaultContext(fileName, (PsiElement)comment, matcher.start(2), this, false, false){

                        public boolean isAbsolutePathReference() {
                            if (super.isAbsolutePathReference()) {
                                return true;
                            }
                            String path = this.getPathString();
                            return path != null && FileUtil.isAbsolute((String)path);
                        }

                        @NotNull
                        public Collection<PsiFileSystemItem> getDefaultContexts() {
                            Collection contexts = super.getDefaultContexts();
                            if (this.isAbsolutePathReference()) {
                                Collection fileSystemRoots = this.toFileSystemItems(ManagingFS.getInstance().getLocalRoots());
                                ArrayList arrayList = ContainerUtil.newArrayList((Iterable)ContainerUtil.concat((Iterable[])new Iterable[]{contexts, fileSystemRoots}));
                                if (arrayList == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return arrayList;
                            }
                            Collection collection = contexts;
                            if (collection == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return collection;
                        }

                        protected int findSeparatorOffset(@NotNull CharSequence sequence, int startingFrom) {
                            if (sequence == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            return StringUtil.indexOfAny((CharSequence)sequence, (String)"\\/", (int)startingFrom, (int)sequence.length());
                        }

                        protected int findSeparatorLength(@NotNull CharSequence sequence, int atOffset) {
                            char c;
                            if (sequence == null) {
                                1.$$$reportNull$$$0(3);
                            }
                            return (c = sequence.charAt(atOffset)) == '\\' || c == '/' ? 1 : 0;
                        }

                        public FileReference createFileReference(TextRange textRange, int i, String text) {
                            return new JSFileReference(text, i, textRange, this, TypeScriptUtil.TYPESCRIPT_EXTENSIONS);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n2;
                            String string;
                            switch (n) {
                                default: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    n2 = 2;
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    n2 = 3;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n2];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$3$1";
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "sequence";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getDefaultContexts";
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$3$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray;
                                    objectArray[2] = "findSeparatorOffset";
                                    break;
                                }
                                case 3: {
                                    objectArray = objectArray;
                                    objectArray[2] = "findSeparatorLength";
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n) {
                                default: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    }.getAllReferences();
                    if (fileReferenceArray == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    return fileReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    3.$$$reportNull$$$0(3);
                }
                return PsiReference.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiElement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processingContext";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$3";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @Nullable
    public static String findReferencePath(@NotNull PsiComment comment) {
        Matcher matcher;
        if (comment == null) {
            TypeScriptReferenceContributor.$$$reportNull$$$0(1);
        }
        if (comment.getTokenType() == JSTokenTypes.END_OF_LINE_COMMENT && (matcher = TYPESCRIPT_REFERENCE_PATH.matcher(comment.getText())).matches()) {
            return matcher.group(2);
        }
        return null;
    }

    @Nullable
    public static PsiFile findReferencedFile(@NotNull PsiComment comment) {
        if (comment == null) {
            TypeScriptReferenceContributor.$$$reportNull$$$0(2);
        }
        if (TypeScriptReferenceContributor.findReferencePath(comment) == null) {
            return null;
        }
        PsiReference[] references = comment.getReferences();
        if (references.length == 0 || !(references[references.length - 1] instanceof JSFileReference)) {
            return null;
        }
        PsiElement resolve = references[references.length - 1].resolve();
        return resolve instanceof PsiFile ? (PsiFile)resolve : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findReferencePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findReferencedFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FileReferenceSetWithDefaultContext
    extends FileReferenceSet {
        public FileReferenceSetWithDefaultContext(@NotNull String str, @NotNull PsiElement element, int startInElement, PsiReferenceProvider provider2, boolean isCaseSensitive, boolean endingSlashNotAllowed) {
            if (str == null) {
                FileReferenceSetWithDefaultContext.$$$reportNull$$$0(0);
            }
            if (element == null) {
                FileReferenceSetWithDefaultContext.$$$reportNull$$$0(1);
            }
            super(str, element, startInElement, provider2, isCaseSensitive, endingSlashNotAllowed, TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY);
        }

        @NotNull
        public Collection<PsiFileSystemItem> computeDefaultContexts() {
            PsiDirectory directory;
            PsiFile file2 = this.getContainingFile();
            if (file2 == null) {
                List<PsiFileSystemItem> list = Collections.emptyList();
                if (list == null) {
                    FileReferenceSetWithDefaultContext.$$$reportNull$$$0(2);
                }
                return list;
            }
            if (this.isAbsolutePathReference()) {
                Collection collection = FileReferenceSetWithDefaultContext.getAbsoluteTopLevelDirLocations((PsiFile)file2);
                if (collection == null) {
                    FileReferenceSetWithDefaultContext.$$$reportNull$$$0(3);
                }
                return collection;
            }
            VirtualFile parent = file2.getViewProvider().getVirtualFile().getParent();
            if (parent != null && (directory = file2.getManager().findDirectory(parent)) != null) {
                Set<PsiDirectory> set = Collections.singleton(directory);
                if (set == null) {
                    FileReferenceSetWithDefaultContext.$$$reportNull$$$0(4);
                }
                return set;
            }
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                FileReferenceSetWithDefaultContext.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$FileReferenceSetWithDefaultContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$FileReferenceSetWithDefaultContext";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeDefaultContexts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

