/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitOverloadedAliasElement;
import com.intellij.lang.javascript.psi.impl.JSParenthesizedExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCallExpressionResolver {
    @NotNull
    private final NotNullLazyValue<List<JSType>> myArgumentTypesValue;
    @NotNull
    private final NullableLazyValue<JSType> myQualifierTypeValue;
    @NotNull
    private final JSCallExpression myCallExpression;

    @Nullable
    public static JSCallExpression getCallExpression(@NotNull PsiElement place) {
        PsiElement parent;
        if (place == null) {
            TypeScriptCallExpressionResolver.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = parent = place instanceof PsiFile ? place : place.getParent();
        while (parent instanceof JSParenthesizedExpressionImpl) {
            parent = parent.getParent();
        }
        return parent instanceof JSCallExpression ? (JSCallExpression)parent : null;
    }

    public TypeScriptCallExpressionResolver(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            TypeScriptCallExpressionResolver.$$$reportNull$$$0(1);
        }
        this.myCallExpression = callExpression;
        this.myArgumentTypesValue = NotNullLazyValue.createValue(() -> {
            if (callExpression == null) {
                TypeScriptCallExpressionResolver.$$$reportNull$$$0(15);
            }
            return TypeScriptGenericTypesEvaluator.getArgumentTypesForSignatureChecking(callExpression.getArguments(), true);
        });
        this.myQualifierTypeValue = NullableLazyValue.createValue(() -> {
            JSExpression expression;
            if (callExpression == null) {
                TypeScriptCallExpressionResolver.$$$reportNull$$$0(14);
            }
            if (!((expression = callExpression.getMethodExpression()) instanceof JSReferenceExpression)) {
                return null;
            }
            JSExpression qualifier = ((JSReferenceExpression)expression).getQualifier();
            return qualifier == null ? null : JSResolveUtil.getExpressionJSType(qualifier);
        });
    }

    @NotNull
    private JSResolveResult checkParameterTypesForSignatureAndOverloads(@NotNull JSResolveResult result2) {
        PsiElement element;
        if (result2 == null) {
            TypeScriptCallExpressionResolver.$$$reportNull$$$0(2);
        }
        if (!((element = result2.getElement()) instanceof JSFunction)) {
            JSResolveResult jSResolveResult = result2;
            if (jSResolveResult == null) {
                TypeScriptCallExpressionResolver.$$$reportNull$$$0(3);
            }
            return jSResolveResult;
        }
        JSTypeSubstitutor genericsFromType = TypeScriptCallExpressionResolver.getExplicitTypeGenerics(result2);
        JSTypeSubstitutor genericArguments = TypeScriptGenericTypesEvaluator.addExplicitGenericArgumentsFromCall(element, (PsiElement)this.myCallExpression, genericsFromType);
        List<JSType> arguments = ((List)this.myArgumentTypesValue.getValue()).stream().map(type -> TypeScriptGenericTypesEvaluator.getExplicitTypeOrAnyIfTypeScript((PsiElement)this.myCallExpression, TypeScriptSignatureChooser.mapContextualTypeForOverload(type, element))).collect(Collectors.toList());
        JSResolveResult resolveResult = TypeScriptSignatureChooser.checkParameterTypes(element, arguments, this.myQualifierTypeValue, genericArguments, this.myCallExpression instanceof JSNewExpression);
        ES6ImportExportDeclarationPart usedImport = (ES6ImportExportDeclarationPart)ObjectUtils.coalesce((Object)result2.getES6Import(), (Object)resolveResult.getES6Import());
        if (!resolveResult.isValidResult()) {
            PsiElement elementToResolve = element;
            if (TypeScriptSignatureChooser.isOverloadImplementation(element)) {
                elementToResolve = resolveResult.getElement();
            }
            JSResolveResult jSResolveResult = new JSResolveResult(elementToResolve, (JSElement)usedImport, resolveResult.getResolveProblemKey());
            if (jSResolveResult == null) {
                TypeScriptCallExpressionResolver.$$$reportNull$$$0(4);
            }
            return jSResolveResult;
        }
        JSResolveResult jSResolveResult = usedImport == null ? resolveResult : resolveResult.copyWithImport((JSElement)usedImport);
        if (jSResolveResult == null) {
            TypeScriptCallExpressionResolver.$$$reportNull$$$0(5);
        }
        return jSResolveResult;
    }

    @NotNull
    private static JSTypeSubstitutor getExplicitTypeGenerics(@NotNull ResolveResult resolveResult) {
        if (resolveResult == null) {
            TypeScriptCallExpressionResolver.$$$reportNull$$$0(6);
        }
        JSTypeSubstitutor explicitTypeGenerics = JSTypeSubstitutor.EMPTY;
        if (!(resolveResult instanceof JSResolveResult)) {
            JSTypeSubstitutor jSTypeSubstitutor = explicitTypeGenerics;
            if (jSTypeSubstitutor == null) {
                TypeScriptCallExpressionResolver.$$$reportNull$$$0(7);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor substitutor = ((JSResolveResult)resolveResult).getTypeSubstitutor();
        JSTypeSubstitutor jSTypeSubstitutor = substitutor == null ? explicitTypeGenerics : substitutor;
        if (jSTypeSubstitutor == null) {
            TypeScriptCallExpressionResolver.$$$reportNull$$$0(8);
        }
        return jSTypeSubstitutor;
    }

    public ResolveResult[] chooseSignatures(@NotNull ResolveResult[] results) {
        if (results == null) {
            TypeScriptCallExpressionResolver.$$$reportNull$$$0(9);
        }
        if (results.length <= 1) {
            return results;
        }
        return this.chooseSignaturesImpl(results);
    }

    @NotNull
    private ResolveResult[] chooseSignaturesImpl(@NotNull ResolveResult[] results) {
        ResolveResult[] finalResults;
        TypeScriptImplicitOverloadedAliasElement element;
        if (results == null) {
            TypeScriptCallExpressionResolver.$$$reportNull$$$0(10);
        }
        if (results.length <= 1) {
            if (results == null) {
                TypeScriptCallExpressionResolver.$$$reportNull$$$0(11);
            }
            return results;
        }
        String fakeAliasName = null;
        JSNamedElement aliasElement = null;
        if (Arrays.stream(results).allMatch(r -> r.getElement() instanceof TypeScriptImplicitOverloadedAliasElement) && (element = (TypeScriptImplicitOverloadedAliasElement)results[0].getElement()) != null) {
            fakeAliasName = element.getName();
            aliasElement = (JSNamedElement)element.getExplicitElement();
            results = TypeScriptImplicitOverloadedAliasElement.unwrapElements(results);
        }
        int argumentsLength = this.myCallExpression.getArguments().length;
        JSTypeDeclaration[] callTypeParameters = TypeScriptPsiUtil.getNestedTypeArguments((PsiElement)this.myCallExpression);
        List filterResult = ContainerUtil.filter((Object[])results, el -> {
            PsiElement result2 = el.getElement();
            if (result2 instanceof TypeScriptFunction) {
                TypeScriptTypeParameter[] owner = TypeScriptPsiUtil.getTypeParametersForOwner(result2);
                if (callTypeParameters.length > owner.length) {
                    return false;
                }
                JSParameterListElement[] parameters = ((TypeScriptFunction)result2).getParameters();
                int min = TypeScriptSignatureChooser.getMinArgumentCount((JSParameterItem[])parameters);
                int max = TypeScriptSignatureChooser.getMaxArgumentCount((JSParameterItem[])parameters);
                return min <= argumentsLength && argumentsLength <= max;
            }
            return true;
        });
        if (filterResult.size() == 1) {
            ResolveResult[] resolveResults = new ResolveResult[]{(ResolveResult)filterResult.get(0)};
            if (fakeAliasName != null && aliasElement != null) {
                resolveResults = TypeScriptImplicitOverloadedAliasElement.wrapElements(resolveResults, fakeAliasName, aliasElement);
            }
            if (resolveResults == null) {
                TypeScriptCallExpressionResolver.$$$reportNull$$$0(12);
            }
            return resolveResults;
        }
        LinkedHashSet validResults = ContainerUtil.newLinkedHashSet();
        ArrayList inValidResults = ContainerUtil.newArrayList();
        List toCheck = filterResult.size() > 0 ? filterResult : ContainerUtil.newArrayList((Object[])results);
        for (ResolveResult result2 : toCheck) {
            PsiElement element2 = result2.getElement();
            if (!(result2 instanceof JSResolveResult) || !result2.isValidResult() || element2 == null) {
                AbstractCollection toAdd = result2.isValidResult() ? validResults : inValidResults;
                toAdd.add(result2);
                continue;
            }
            JSResolveResult oldResolveResult = (JSResolveResult)result2;
            JSResolveResult newResolveResult = this.checkParameterTypesForSignatureAndOverloads(oldResolveResult);
            if (newResolveResult.isValidResult()) {
                JSElement importElement = (JSElement)ObjectUtils.coalesce((Object)oldResolveResult.getES6Import(), (Object)newResolveResult.getES6Import());
                validResults.add(newResolveResult.copyWithImport(importElement));
                continue;
            }
            inValidResults.add(newResolveResult);
        }
        ResolveResult[] resolveResultArray = finalResults = validResults.size() > 0 ? TypeScriptPsiUtil.chooseOverload(validResults.toArray(ResolveResult.EMPTY_ARRAY)) : inValidResults.toArray(ResolveResult.EMPTY_ARRAY);
        if (fakeAliasName != null && aliasElement != null) {
            finalResults = TypeScriptImplicitOverloadedAliasElement.wrapElements(finalResults, fakeAliasName, aliasElement);
        }
        if (finalResults == null) {
            TypeScriptCallExpressionResolver.$$$reportNull$$$0(13);
        }
        return finalResults;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptCallExpressionResolver";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptCallExpressionResolver";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "checkParameterTypesForSignatureAndOverloads";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitTypeGenerics";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseSignaturesImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCallExpression";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkParameterTypesForSignatureAndOverloads";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitTypeGenerics";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "chooseSignatures";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "chooseSignaturesImpl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

