/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumConstantValueImpl
implements EnumConstantValue {
    @Nullable
    private final String unparsedValue;
    private final AtomicInteger numericDelta = new AtomicInteger(0);
    private final AtomicNullableLazyValue<String> stringValueLazy = new AtomicNullableLazyValue<String>(){

        @Nullable
        protected String compute() {
            if (EnumConstantValueImpl.this.unparsedValue != null && StringUtil.isQuotedString((String)EnumConstantValueImpl.this.unparsedValue) && EnumConstantValueImpl.this.numericDelta.get() == 0) {
                return JSStringUtil.unquoteAndUnescapeString(EnumConstantValueImpl.this.unparsedValue);
            }
            return null;
        }
    };
    private final AtomicNullableLazyValue<Double> numericValueLazy = new AtomicNullableLazyValue<Double>(){

        @Nullable
        protected Double compute() {
            Double numericValue;
            if (EnumConstantValueImpl.this.unparsedValue != null && JSStringUtil.isNumericValueStart(EnumConstantValueImpl.this.unparsedValue, true) && (numericValue = JSNumberParser.tryParseNumericValue(EnumConstantValueImpl.this.unparsedValue, true)) != null) {
                return numericValue + (double)EnumConstantValueImpl.this.numericDelta.get();
            }
            return null;
        }
    };

    public EnumConstantValueImpl(@Nullable String unparsedValue) {
        this.unparsedValue = unparsedValue;
    }

    public String getStringValue() {
        return (String)this.stringValueLazy.getValue();
    }

    public Double getNumericValue() {
        return (Double)this.numericValueLazy.getValue();
    }

    @NotNull
    public EnumConstantValueImpl increaseNumericDelta(int delta) {
        EnumConstantValueImpl newEnum = new EnumConstantValueImpl(this.unparsedValue);
        newEnum.numericDelta.set(this.numericDelta.get() + delta);
        EnumConstantValueImpl enumConstantValueImpl = newEnum;
        if (enumConstantValueImpl == null) {
            EnumConstantValueImpl.$$$reportNull$$$0(0);
        }
        return enumConstantValueImpl;
    }

    @Nullable
    public String getSerializedString() {
        if (this.numericDelta.get() > 0) {
            Double value = this.getNumericValue();
            if (value == null) {
                return null;
            }
            int intValue = (int)value.doubleValue();
            if (value == (double)intValue) {
                return String.valueOf(intValue);
            }
            return String.valueOf(value);
        }
        return this.unparsedValue;
    }

    public boolean isValid() {
        return this.unparsedValue != null;
    }

    @Nullable
    public String getDescription() {
        String stringValue = this.getStringValue();
        if (stringValue != null) {
            return stringValue;
        }
        Double doubleValue = this.getNumericValue();
        if (doubleValue != null) {
            return new DecimalFormat("#.######").format(doubleValue);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/EnumConstantValueImpl", "increaseNumericDelta"));
    }
}

