/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSReferenceCompletionContributor;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSDestructuringPropertyCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result2) {
        JSDestructuringObject objectPattern;
        PsiElement position;
        PsiElement parent;
        if (parameters == null) {
            JSDestructuringPropertyCompletionProvider.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JSDestructuringPropertyCompletionProvider.$$$reportNull$$$0(1);
        }
        if ((parent = (position = parameters.getPosition()).getParent()) instanceof JSVariable) {
            parent = parent.getParent();
        }
        assert (parent instanceof JSDestructuringProperty) : "must be filtered in JSPatternBasedCompletionContributor";
        JSDestructuringProperty destructuringProperty = (JSDestructuringProperty)parent;
        JSDestructuringObject jSDestructuringObject = objectPattern = destructuringProperty.getParent() instanceof JSDestructuringObject ? (JSDestructuringObject)destructuringProperty.getParent() : null;
        if (objectPattern == null) {
            return;
        }
        Set existingProperties = ContainerUtil.map2Set((Object[])objectPattern.getProperties(), JSNamedElementBase::getName);
        PsiFile file2 = objectPattern.getContainingFile();
        QualifiedItemProcessor<? extends ResultSink> localProcessor = JSDestructuringPropertyCompletionProvider.createCompletionItemProcessor((JSElement)destructuringProperty);
        JSTypeEvaluator.evaluateExpressionOrElementTypes(file2, localProcessor, (PsiElement)objectPattern, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
        List<PsiElement> localResults = localProcessor.getResults();
        VariantsProcessor processor = new VariantsProcessor(file2, (PsiElement)destructuringProperty, true, parameters, result2);
        if (localResults != null) {
            processor.populateCompletionList(JSDestructuringPropertyCompletionProvider.filterResults(JSDestructuringPropertyCompletionProvider.toLookupElements(localResults), existingProperties), false, result2);
        }
        JSReferenceCompletionContributor.processCompeteMatchedElements(processor);
        Collection<LookupElement> variantProcessorResults = processor.getCurrentResults();
        processor.populateCompletionList(JSDestructuringPropertyCompletionProvider.filterResults(variantProcessorResults, existingProperties), false, result2);
    }

    private static List<LookupElement> filterResults(@NotNull Collection<? extends LookupElement> results, @NotNull Set<String> existingProperties) {
        if (results == null) {
            JSDestructuringPropertyCompletionProvider.$$$reportNull$$$0(2);
        }
        if (existingProperties == null) {
            JSDestructuringPropertyCompletionProvider.$$$reportNull$$$0(3);
        }
        return ContainerUtil.filter(results, lookupElement -> {
            JSQualifiedName namespace;
            PsiElement element;
            if (existingProperties == null) {
                JSDestructuringPropertyCompletionProvider.$$$reportNull$$$0(8);
            }
            if ((element = lookupElement.getPsiElement()) instanceof ES6ExportDefaultAssignment && existingProperties.contains("default")) {
                return false;
            }
            if (element instanceof JSQualifiedNamedElement && (namespace = ((JSQualifiedNamedElement)element).getNamespace()) != null && ("Object".equals(namespace.getName()) || "Function".equals(namespace.getName()))) {
                return false;
            }
            return !(element instanceof PsiNamedElement) || !existingProperties.contains(((PsiNamedElement)element).getName());
        });
    }

    @NotNull
    private static List<LookupElement> toLookupElements(@NotNull List<PsiElement> localResults) {
        if (localResults == null) {
            JSDestructuringPropertyCompletionProvider.$$$reportNull$$$0(4);
        }
        List list = ContainerUtil.mapNotNull(localResults, e -> {
            if (e instanceof ES6ExportDefaultAssignment) {
                return PrioritizedLookupElement.withPriority((LookupElement)JSLookupUtilImpl.createLookupElement(e, "default"), (double)JSLookupPriority.SMART_PRIORITY.getPriorityValue());
            }
            if (!(e instanceof PsiNamedElement)) {
                return null;
            }
            return JSLookupUtilImpl.createPrioritizedLookupElement((PsiNamedElement)e, JSLookupPriority.SMART_PRIORITY);
        });
        if (list == null) {
            JSDestructuringPropertyCompletionProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static QualifiedItemProcessor<? extends ResultSink> createCompletionItemProcessor(@NotNull JSElement destructuringElement) {
        if (destructuringElement == null) {
            JSDestructuringPropertyCompletionProvider.$$$reportNull$$$0(6);
        }
        QualifiedItemProcessor<? extends ResultSink> qualifiedItemProcessor = JSDialectSpecificHandlersFactory.forElement((PsiElement)destructuringElement).createCompletionItemProcessor(new CompletionResultSink((PsiElement)destructuringElement), destructuringElement.getContainingFile());
        if (qualifiedItemProcessor == null) {
            JSDestructuringPropertyCompletionProvider.$$$reportNull$$$0(7);
        }
        return qualifiedItemProcessor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingProperties";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localResults";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSDestructuringPropertyCompletionProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSDestructuringPropertyCompletionProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toLookupElements";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompletionItemProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "filterResults";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toLookupElements";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionItemProcessor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterResults$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

