/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.webpack;

import com.google.gson.Gson;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeJSSettingsManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.lang.javascript.buildTools.webpack.WebPackConfig;
import com.intellij.lang.javascript.buildTools.webpack.WebPackNotifier;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/lang/javascript/buildTools/webpack/WebPackExecutor;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "notifier", "Lcom/intellij/lang/javascript/buildTools/webpack/WebPackNotifier;", "errorNotify", "", "project", "Lcom/intellij/openapi/project/Project;", "configPath", "", "loadConfig", "Lcom/intellij/lang/javascript/buildTools/webpack/WebPackConfig;", "run", "Lcom/intellij/execution/process/ProcessOutput;", "path", "intellij.javascript.impl"})
public final class WebPackExecutor {
    private final WebPackNotifier notifier = new WebPackNotifier();
    @NotNull
    private final Logger logger = Logger.getInstance((String)"#com.intellij.lang.javascript.buildTools.webpack.WebPackExecutor");

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @Nullable
    public final ProcessOutput run(@NotNull Project project, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        NodeJsInterpreterManager nodeJsInterpreterManager = NodeJsInterpreterManager.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreterManager, (String)"NodeJsInterpreterManager.getInstance(project)");
        NodeJsInterpreter nodeJsInterpreter = nodeJsInterpreterManager.getDefault();
        if (nodeJsInterpreter == null) {
            return null;
        }
        NodeJsInterpreter node = nodeJsInterpreter;
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.withCharset(StandardCharsets.UTF_8);
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(node);
        if (!(localInterpreter != null && localInterpreter.isValid() || (localInterpreter = NodeJsLocalInterpreterManager.getInstance().detectMostRelevant()) != null)) {
            String string = "Failed to load " + PathUtil.getFileName((String)path);
            MessageType messageType = MessageType.WARNING;
            Intrinsics.checkExpressionValueIsNotNull((Object)messageType, (String)"MessageType.WARNING");
            this.notifier.notify(project, string, messageType, path, new AnAction(project, "Set up node.js interpreter"){
                final /* synthetic */ Project $project;

                public void actionPerformed(@Nullable AnActionEvent e) {
                    NodeJSSettingsManager.editSettingsAppropriately(this.$project);
                }
                {
                    this.$project = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            });
            return null;
        }
        Map map = commandLine.getEnvironment();
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"commandLine.environment");
        Map map2 = map;
        CharSequence charSequence = "NODE_ENV";
        String string = "development";
        map2.put(charSequence, string);
        commandLine.setExePath(localInterpreter.getInterpreterSystemDependentPath());
        commandLine.setWorkDirectory(VfsUtil.virtualToIoFile((VirtualFile)project.getBaseDir()));
        commandLine.addParameter("-e");
        String loader = "";
        if (StringsKt.contains$default((CharSequence)path, (CharSequence)".babel.", (boolean)false, (int)2, null)) {
            loader = StringsKt.trimIndent((String)"\n        try {\n          require('@babel/register');\n        } catch (e) {\n          require('babel-register');\n        }\n        ");
        } else if (StringsKt.endsWith$default((String)path, (String)".ts", (boolean)false, (int)2, null)) {
            loader = "require('ts-node/register');";
        }
        charSequence = loader;
        StringBuilder stringBuilder = new StringBuilder().append("\n      ").append(loader).append("\n      function mergeConfigs(array){\n        result = {};\n        for (var i = 0; i < array.length; i++) {\n          var obj = array[i];\n          result.output = result.output || obj.output;\n          if (!result.resolve) {\n            result.resolve = obj.resolve;\n          } else if (obj.resolve) {\n            if (!result.resolve.alias) {\n              result.resolve.alias = obj.resolve.alias;\n            } else if (obj.resolve.alias) {\n              result.resolve.alias = Object.assign(result.resolve.alias, obj.resolve.alias);\n            }\n            if (!result.resolve.modules) {\n              result.resolve.modules = obj.resolve.modules;\n            } else if (obj.resolve.modules) {\n              result.resolve.modules = result.resolve.modules.concat(obj.resolve.modules);\n            }\n            if (!result.resolve.modulesDirectories) {\n              result.resolve.modulesDirectories = obj.resolve.modulesDirectories;\n            } else if (obj.resolve.modulesDirectories) {\n              result.resolve.modulesDirectories = result.resolve.modulesDirectories.concat(obj.resolve.modulesDirectories);\n            }\n            result.resolve.root = result.resolve.root || obj.resolve.root;\n          }\n        }\n        return result;\n      }\n      var config = require('").append(path).append("');\n      function printConfig(config) {\n        if (");
        GeneralCommandLine generalCommandLine = commandLine;
        boolean bl = charSequence.length() > 0;
        generalCommandLine.addParameter(StringsKt.trimIndent((String)stringBuilder.append(bl).append(" && config.default !== undefined) config = config.default;\n        if (typeof(config) === 'function') config = config({development: true});\n        if (Array.isArray(config)) {\n          config = mergeConfigs(config);\n        }\n        config = {resolve: config.resolve, output: config.output}\n        console.log(JSON.stringify(config))\n        process.exit(0)\n      }\n      if (typeof Promise !== 'undefined') {\n        config = Promise.resolve(config).then(function(value) {\n          printConfig(value)\n        })\n      } else {\n        printConfig(config)\n      }\n      ").toString()));
        return NodeCommandLineUtil.execute(commandLine, 10000L);
    }

    @NotNull
    public final WebPackConfig loadConfig(@NotNull Project project, @NotNull String configPath) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)configPath, (String)"configPath");
        ProcessOutput run2 = this.run(project, configPath);
        if (run2 != null && run2.getExitCode() == 0) {
            String string;
            String string2;
            String string3 = run2.getStdout();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"run.stdout");
            String string4 = string2 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String stdOut = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            int lastNewLine = StringsKt.lastIndexOf$default((CharSequence)stdOut, (char)'\n', (int)0, (boolean)false, (int)6, null);
            if (lastNewLine > 0) {
                String string5 = stdOut;
                int n = lastNewLine + 1;
                String string6 = string5;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(n);
                string = string7;
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = stdOut;
            }
            String result2 = string;
            try {
                WebPackConfig config2 = (WebPackConfig)new Gson().fromJson(result2, WebPackConfig.class);
                String string8 = "Module resolution rules from <a href='#'>" + PathUtil.getFileName((String)configPath) + "</a> are now used for coding assistance.";
                MessageType messageType = MessageType.INFO;
                Intrinsics.checkExpressionValueIsNotNull((Object)messageType, (String)"MessageType.INFO");
                WebPackNotifier.notify$default(this.notifier, project, string8, messageType, configPath, null, 16, null);
                WebPackConfig webPackConfig = config2;
                Intrinsics.checkExpressionValueIsNotNull((Object)webPackConfig, (String)"config");
                return webPackConfig;
            }
            catch (RuntimeException e) {
                this.logger.debug("" + e.getMessage() + "\nstdout: " + run2.getStdout() + "\nstderr: " + run2.getStderr(), (Throwable)e);
                this.errorNotify(project, configPath);
            }
        } else if (run2 != null) {
            this.logger.warn("failed to evaluate webpack config. exit code: " + run2.getExitCode() + "" + (run2.isTimeout() ? ", timed out" : "") + '\n' + "stdout: " + run2.getStdout() + "\nstderr: " + run2.getStderr());
            this.errorNotify(project, configPath);
        }
        return new WebPackConfig(null, null, 3, null);
    }

    private final void errorNotify(Project project, String configPath) {
        String string = "Can't analyse <a href='#'>" + PathUtil.getFileName((String)configPath) + "</a>: coding assistance will ignore module resolution rules in this file.\n" + "Possible reasons: this file is not a valid webpack configuration file or its format is not currently supported by the IDE";
        MessageType messageType = MessageType.WARNING;
        Intrinsics.checkExpressionValueIsNotNull((Object)messageType, (String)"MessageType.WARNING");
        WebPackNotifier.notify$default(this.notifier, project, string, messageType, configPath, null, 16, null);
    }
}

