/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt.rc;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.debug.NodeLocalDebugRunProfileState;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.buildTools.TypeScriptErrorConsoleFilter;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntCoreTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntTargetTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntTaskStructureUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileManager;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileStructure;
import com.intellij.lang.javascript.buildTools.grunt.execution.GruntWatchTaskListener;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettings;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class GruntRunProfileState
implements NodeLocalDebugRunProfileState {
    private static final String WATCH_TASK_NAME = "watch";
    private final ExecutionEnvironment myEnvironment;
    private final GruntRunSettings myRunSettings;
    private final GruntNonSharedSettings myNonSharedSettings;

    public GruntRunProfileState(@NotNull ExecutionEnvironment environment, @NotNull GruntRunSettings runSettings, @NotNull GruntNonSharedSettings nonSharedSettings) {
        if (environment == null) {
            GruntRunProfileState.$$$reportNull$$$0(0);
        }
        if (runSettings == null) {
            GruntRunProfileState.$$$reportNull$$$0(1);
        }
        if (nonSharedSettings == null) {
            GruntRunProfileState.$$$reportNull$$$0(2);
        }
        this.myEnvironment = environment;
        this.myRunSettings = runSettings;
        this.myNonSharedSettings = nonSharedSettings;
    }

    @NotNull
    public GruntRunSettings getRunSettings() {
        GruntRunSettings gruntRunSettings = this.myRunSettings;
        if (gruntRunSettings == null) {
            GruntRunProfileState.$$$reportNull$$$0(3);
        }
        return gruntRunSettings;
    }

    @Override
    @NotNull
    public ExecutionResult execute(int debugPort) throws ExecutionException {
        ConsoleView console;
        NodeJsLocalInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolveAsLocal(this.myEnvironment.getProject());
        GeneralCommandLine commandLine = this.createCommandLine(interpreter, debugPort);
        ProcessHandler processHandler = JsbtUtil.createProcessHandlerWithBeepSupport(commandLine);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        this.installWatchHandler(processHandler);
        if (debugPort != -1) {
            console = null;
        } else {
            console = this.createConsole(commandLine.getWorkDirectory());
            console.attachToProcess(processHandler);
            this.foldCommandLine(console, processHandler);
        }
        DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult((ExecutionConsole)console, processHandler);
        if (defaultExecutionResult == null) {
            GruntRunProfileState.$$$reportNull$$$0(4);
        }
        return defaultExecutionResult;
    }

    private void installWatchHandler(final @NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            GruntRunProfileState.$$$reportNull$$$0(5);
        }
        GruntfileManager gruntfileManager = GruntfileManager.getInstance(this.myEnvironment.getProject());
        VirtualFile gruntfile = LocalFileFinder.findFile((String)FileUtil.toSystemDependentName((String)this.myRunSettings.getGruntfilePath()));
        if (gruntfile != null) {
            GruntfileStructure gruntfileStructure = gruntfileManager.getCachedStructure(gruntfile);
            if (gruntfileStructure != null) {
                GruntRunProfileState.installWatchHandler(this.myEnvironment.getProject(), processHandler, gruntfileStructure, this.myRunSettings.getTasks());
            } else {
                gruntfileManager.fetchGruntStructure(gruntfile, new CatchingConsumer<GruntfileStructure, JsbtTaskFetchException>(){

                    public void consume(JsbtTaskFetchException e) {
                    }

                    public void consume(GruntfileStructure structure) {
                        GruntRunProfileState.installWatchHandler(GruntRunProfileState.this.myEnvironment.getProject(), processHandler, structure, GruntRunProfileState.this.myRunSettings.getTasks());
                    }
                });
            }
        } else {
            GruntRunProfileState.installWatchHandler(this.myEnvironment.getProject(), processHandler, null, this.myRunSettings.getTasks());
        }
    }

    private static void installWatchHandler(@NotNull Project project, @NotNull ProcessHandler processHandler, @Nullable GruntfileStructure gruntfileStructure, @NotNull List<String> taskNames) {
        if (project == null) {
            GruntRunProfileState.$$$reportNull$$$0(6);
        }
        if (processHandler == null) {
            GruntRunProfileState.$$$reportNull$$$0(7);
        }
        if (taskNames == null) {
            GruntRunProfileState.$$$reportNull$$$0(8);
        }
        for (String taskName : taskNames) {
            String watchTaskName = GruntRunProfileState.findWatchTaskNameFor(gruntfileStructure, taskName);
            if (watchTaskName == null) continue;
            processHandler.addProcessListener((ProcessListener)new GruntWatchTaskListener(project, watchTaskName));
            return;
        }
    }

    @Nullable
    private static String findWatchTaskNameFor(@Nullable GruntfileStructure structure, @NotNull String taskName) {
        GruntTask task;
        if (taskName == null) {
            GruntRunProfileState.$$$reportNull$$$0(9);
        }
        if (structure != null && (task = structure.findTaskByName(taskName)) != null) {
            Collection<GruntTask> dependentTasks = GruntTask.listAllDependentTasksFor(task);
            for (GruntTask dependentTask : dependentTasks) {
                GruntTargetTask dependentTargetTask;
                if (dependentTask instanceof GruntCoreTask && dependentTask.getName().contains(WATCH_TASK_NAME)) {
                    return dependentTask.getName();
                }
                if (!(dependentTask instanceof GruntTargetTask) || !(dependentTargetTask = (GruntTargetTask)dependentTask).getCoreTask().getName().contains(WATCH_TASK_NAME)) continue;
                return dependentTargetTask.getName();
            }
        }
        return taskName.equals(WATCH_TASK_NAME) || taskName.startsWith("watch:") ? taskName : null;
    }

    @NotNull
    private ConsoleView createConsole(@Nullable File cwd) {
        TextConsoleBuilderImpl builder = new TextConsoleBuilderImpl(this.myEnvironment.getProject());
        builder.setUsePredefinedMessageFilter(false);
        builder.addFilter((Filter)new NodeStackTraceFilter(this.myEnvironment.getProject(), cwd));
        builder.addFilter((Filter)new NodeConsoleAdditionalFilter(this.myEnvironment.getProject(), cwd));
        builder.addFilter((Filter)new TypeScriptErrorConsoleFilter(this.myEnvironment.getProject(), cwd));
        ConsoleView consoleView = builder.getConsole();
        if (consoleView == null) {
            GruntRunProfileState.$$$reportNull$$$0(10);
        }
        return consoleView;
    }

    @NotNull
    private GeneralCommandLine createCommandLine(@NotNull NodeJsLocalInterpreter interpreter, int debugPort) {
        if (interpreter == null) {
            GruntRunProfileState.$$$reportNull$$$0(11);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(CharsetToolkit.UTF8_CHARSET);
        File workingDirectory = new File(this.myRunSettings.getGruntfilePath()).getParentFile();
        commandLine.withWorkDirectory(workingDirectory.getAbsolutePath());
        this.myRunSettings.getEnvData().configureCommandLine(commandLine, true);
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        List nodeOptionList = ParametersListUtil.parse((String)this.myRunSettings.getNodeOptions().trim());
        NodeCommandLineUtil.addNodeOptionsForDebugging(commandLine, nodeOptionList, debugPort, true, interpreter, true);
        commandLine.addParameter(GruntTaskStructureUtil.getGruntCliMainFilePath(this.myNonSharedSettings.getGruntCliPackage()));
        commandLine.addParameter("--gruntfile");
        commandLine.addParameter(FileUtil.toSystemDependentName((String)this.myRunSettings.getGruntfilePath()));
        String arguments = this.myRunSettings.getArguments().trim();
        if (StringUtil.isNotEmpty((String)arguments)) {
            commandLine.addParameters(ParametersList.parse((String)arguments));
        }
        commandLine.addParameters(this.myRunSettings.getTasks());
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            GruntRunProfileState.$$$reportNull$$$0(12);
        }
        return generalCommandLine;
    }

    @Override
    public void foldCommandLine(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        BaseOSProcessHandler osProcessHandler;
        if (consoleView == null) {
            GruntRunProfileState.$$$reportNull$$$0(13);
        }
        if (processHandler == null) {
            GruntRunProfileState.$$$reportNull$$$0(14);
        }
        if ((osProcessHandler = (BaseOSProcessHandler)ObjectUtils.tryCast((Object)processHandler, BaseOSProcessHandler.class)) != null) {
            ArrayList args = ContainerUtil.newArrayList((Object[])new String[]{"grunt"});
            String arguments = this.myRunSettings.getArguments().trim();
            if (StringUtil.isNotEmpty((String)arguments)) {
                args.addAll(ParametersListUtil.parse((String)arguments));
            }
            args.addAll(this.myRunSettings.getTasks());
            GruntRunProfileState.doFoldCommandLine(consoleView, osProcessHandler, ParametersListUtil.join((List)args));
        }
    }

    private static void doFoldCommandLine(final @NotNull ConsoleView consoleView, final @NotNull BaseOSProcessHandler processHandler, final @NotNull String foldedCommandLineText) {
        String commandLine;
        if (consoleView == null) {
            GruntRunProfileState.$$$reportNull$$$0(15);
        }
        if (processHandler == null) {
            GruntRunProfileState.$$$reportNull$$$0(16);
        }
        if (foldedCommandLineText == null) {
            GruntRunProfileState.$$$reportNull$$$0(17);
        }
        if ((commandLine = processHandler.getCommandLine()) != null) {
            if (processHandler.isStartNotified()) {
                JsbtUtil.foldMatchingTextAtOffset(consoleView, 0, commandLine, foldedCommandLineText);
            } else {
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void startNotified(@NotNull ProcessEvent event) {
                        if (event == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        processHandler.removeProcessListener((ProcessListener)this);
                        JsbtUtil.foldMatchingTextAtOffset(consoleView, 0, commandLine, foldedCommandLineText);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState$2", "startNotified"));
                    }
                });
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonSharedSettings";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState";
                break;
            }
            case 5: 
            case 7: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskNames";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldedCommandLineText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "installWatchHandler";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findWatchTaskNameFor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "foldCommandLine";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doFoldCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

