/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.bower.BowerPackagesView;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.lang.javascript.bower.BowerSettingsManager;
import com.intellij.lang.javascript.bower.BowerValidationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.ui.PathShortener;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowerView {
    private final Project myProject;
    private final JPanel myComponent;
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final NodePackageField myBowerPackageField;
    private final TextFieldWithBrowseButton myBowerJsonField;
    private final BowerPackagesView myPackagesView;
    private final Color myNormalForeground;
    private volatile boolean myAllowUpdates;

    public BowerView(@NotNull Project project) {
        if (project == null) {
            BowerView.$$$reportNull$$$0(0);
        }
        this.myAllowUpdates = true;
        this.myProject = project;
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.myBowerPackageField = new NodePackageField(this.myNodeInterpreterField, BowerSettingsManager.PKG_DESCRIPTOR, null);
        this.myBowerJsonField = BowerView.createBowerJsonField(project);
        this.myPackagesView = new BowerPackagesView(project);
        this.myNormalForeground = ((JTextField)this.myBowerJsonField.getChildComponent()).getForeground();
        JPanel panel = FormBuilder.createFormBuilder().setAlignLabelOnRight(true).addLabeledComponent("&Node interpreter:", (JComponent)((Object)this.myNodeInterpreterField)).addLabeledComponent("&Bower package:", (JComponent)((Object)this.myBowerPackageField)).addLabeledComponent("b&ower.json:", (JComponent)this.myBowerJsonField).getPanel();
        this.myNodeInterpreterField.addChangeListener(newInterpreter -> this.updateLaterIfAllowed());
        this.myBowerPackageField.addSelectionListener((Consumer<NodePackage>)((Consumer)pkg -> this.updateLaterIfAllowed()));
        this.listenForChanges((JTextComponent)this.myBowerJsonField.getChildComponent());
        this.myComponent = BowerView.createResult(panel, this.myPackagesView.getComponent());
    }

    private static JPanel createResult(@NotNull JComponent top, @NotNull JComponent bottom) {
        if (top == null) {
            BowerView.$$$reportNull$$$0(1);
        }
        if (bottom == null) {
            BowerView.$$$reportNull$$$0(2);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)top, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        panel.add((Component)bottom, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        return panel;
    }

    private void listenForChanges(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            BowerView.$$$reportNull$$$0(3);
        }
        textComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                BowerView.this.updateLaterIfAllowed();
            }
        });
    }

    private void updateLaterIfAllowed() {
        if (this.myAllowUpdates) {
            this.updateLater();
        }
    }

    private void updateLater() {
        UIUtil.invokeLaterIfNeeded(() -> this.update());
    }

    private void update() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        BowerSettings.Builder builder = new BowerSettings.Builder(this.myProject);
        builder.setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef());
        builder.setBowerPackage(this.myBowerPackageField.getSelected());
        builder.setBowerJsonPath(PathShortener.getAbsolutePath((JTextField)this.myBowerJsonField.getTextField()));
        List<BowerValidationInfo> validationInfos = this.validate();
        this.myPackagesView.onSettingsChanged(builder.build(), validationInfos);
    }

    @NotNull
    private List<BowerValidationInfo> validate() {
        ArrayList infos = ContainerUtil.newArrayList();
        this.processValidationInfo(infos, null, this.validateNodeInterpreter());
        this.processValidationInfo(infos, null, this.validateBowerPackage());
        JTextField bowerJsonTextField = this.myBowerJsonField.getTextField();
        BowerValidationInfo bowerJsonInfo = BowerView.validateFilePathField(bowerJsonTextField, PathShortener.getAbsolutePath((JTextField)bowerJsonTextField), "bower.json");
        this.processValidationInfo(infos, bowerJsonTextField, bowerJsonInfo);
        ArrayList arrayList = infos;
        if (arrayList == null) {
            BowerView.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private void processValidationInfo(@NotNull List<BowerValidationInfo> infos, @Nullable Component component, @Nullable BowerValidationInfo info) {
        if (infos == null) {
            BowerView.$$$reportNull$$$0(5);
        }
        if (info != null) {
            infos.add(info);
        }
        if (component instanceof JTextComponent) {
            component.setForeground((Color)(info != null ? JBColor.RED : this.myNormalForeground));
        }
    }

    @Nullable
    private BowerValidationInfo validateNodeInterpreter() {
        NodeJsInterpreter interpreter = this.myNodeInterpreterField.getInterpreter();
        String nodeInterpreterErrorMessage = NodeJsLocalInterpreter.getErrorMessage(interpreter);
        if (nodeInterpreterErrorMessage != null) {
            return new BowerValidationInfo((Component)((Object)this.myNodeInterpreterField), "Please correct path to {{LINK}}", "Node interpreter");
        }
        return null;
    }

    @Nullable
    private BowerValidationInfo validateBowerPackage() {
        NodePackage selected = this.myBowerPackageField.getSelected();
        String errorMessage = selected.getErrorMessage("bower");
        if (errorMessage != null) {
            return new BowerValidationInfo((Component)((Object)this.myBowerPackageField), "Please correct path to {{LINK}}", "Bower package");
        }
        return null;
    }

    @Nullable
    private static BowerValidationInfo validateFilePathField(@NotNull Component component, @NotNull String path, @NotNull String fieldName) {
        File file2;
        if (component == null) {
            BowerView.$$$reportNull$$$0(6);
        }
        if (path == null) {
            BowerView.$$$reportNull$$$0(7);
        }
        if (fieldName == null) {
            BowerView.$$$reportNull$$$0(8);
        }
        if ((file2 = new File(path)).isFile()) {
            return null;
        }
        return new BowerValidationInfo(component, "Please correct path to {{LINK}}", fieldName);
    }

    @NotNull
    private static TextFieldWithBrowseButton createBowerJsonField(@NotNull Project project) {
        if (project == null) {
            BowerView.$$$reportNull$$$0(9);
        }
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)textFieldWithBrowseButton, (String)"Select bower.json", (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        PathShortener.enablePathShortening((JTextField)textFieldWithBrowseButton.getTextField(), null);
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton;
        if (textFieldWithBrowseButton2 == null) {
            BowerView.$$$reportNull$$$0(10);
        }
        return textFieldWithBrowseButton2;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            BowerView.$$$reportNull$$$0(11);
        }
        return jPanel;
    }

    @NotNull
    public BowerSettings getSettings() {
        BowerSettings bowerSettings = new BowerSettings.Builder(this.myProject).setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef()).setBowerPackage(this.myBowerPackageField.getSelected()).setBowerJsonPath(PathShortener.getAbsolutePath((JTextField)this.myBowerJsonField.getTextField())).build();
        if (bowerSettings == null) {
            BowerView.$$$reportNull$$$0(12);
        }
        return bowerSettings;
    }

    public void setSettings(@NotNull BowerSettings settings) {
        if (settings == null) {
            BowerView.$$$reportNull$$$0(13);
        }
        this.myAllowUpdates = false;
        try {
            this.myNodeInterpreterField.setInterpreterRef(settings.getInterpreterRef());
            this.myBowerPackageField.setSelected(settings.getBowerPackage());
            this.myBowerJsonField.setText(FileUtil.toSystemDependentName((String)settings.getBowerJsonPath()));
            this.updateLater();
        }
        finally {
            this.myAllowUpdates = true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "top";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bottom";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/bower/BowerView";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/bower/BowerView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createBowerJsonField";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createResult";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "listenForChanges";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processValidationInfo";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateFilePathField";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createBowerJsonField";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

