/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.google.common.collect.ImmutableList;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.javascript.bower.BowerCommandLineUtil;
import com.intellij.lang.javascript.bower.BowerCommandRun;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class BowerAvailablePackagesManager {
    private static final Logger LOG = Logger.getInstance(BowerAvailablePackagesManager.class);
    private static final BowerAvailablePackagesManager INSTANCE = new BowerAvailablePackagesManager();
    private volatile WeakReference<Result> myLastResultRef;
    private final Object myLoadRunLock = new Object();
    private LoadRun myCurrentLoadRun;

    @NotNull
    public static BowerAvailablePackagesManager getInstance() {
        BowerAvailablePackagesManager bowerAvailablePackagesManager = INSTANCE;
        if (bowerAvailablePackagesManager == null) {
            BowerAvailablePackagesManager.$$$reportNull$$$0(0);
        }
        return bowerAvailablePackagesManager;
    }

    @NotNull
    public List<String> getOrLoadAvailablePackages(@NotNull BowerSettings settings, boolean forceReload) throws IOException {
        List<String> list;
        Result lastResult;
        if (settings == null) {
            BowerAvailablePackagesManager.$$$reportNull$$$0(1);
        }
        if (!forceReload && (lastResult = (Result)SoftReference.dereference(this.myLastResultRef)) != null && lastResult.mySettings.equals(settings)) {
            List list2 = lastResult.myPackages;
            if (list2 == null) {
                BowerAvailablePackagesManager.$$$reportNull$$$0(2);
            }
            return list2;
        }
        try {
            LoadRun loadRun = this.getOrCreateLoadRun(settings);
            list = loadRun.getFuture().get();
        }
        catch (Exception e) {
            LOG.info("Failed to list all bower packages", (Throwable)e);
            throw new IOException("Failed to list all bower packages", e);
        }
        if (list == null) {
            BowerAvailablePackagesManager.$$$reportNull$$$0(3);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private LoadRun getOrCreateLoadRun(@NotNull BowerSettings settings) throws ExecutionException {
        FutureTask<List<String>> future;
        LoadRun loadRun;
        if (settings == null) {
            BowerAvailablePackagesManager.$$$reportNull$$$0(4);
        }
        Object object = this.myLoadRunLock;
        synchronized (object) {
            loadRun = this.myCurrentLoadRun;
            if (loadRun != null && !loadRun.getSettings().equals(settings)) {
                loadRun.terminate();
                loadRun = null;
            }
            if (loadRun != null) {
                LoadRun loadRun2 = loadRun;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl11 : MonitorExitStatement: MONITOREXIT : var4_2
                if (loadRun2 == null) {
                    BowerAvailablePackagesManager.$$$reportNull$$$0(5);
                }
                return loadRun2;
            }
            BowerCommandRun commandRun = BowerCommandLineUtil.startBowerCommand(settings, "search", "--json");
            future = new FutureTask<List<String>>(() -> {
                if (settings == null) {
                    BowerAvailablePackagesManager.$$$reportNull$$$0(10);
                }
                try {
                    ProcessOutput output = commandRun.captureOutput(null, TimeUnit.MINUTES.toMillis(10L));
                    List<String> packages = BowerAvailablePackagesManager.parseAllPackages(output.getStdout());
                    this.myLastResultRef = new WeakReference<Result>(new Result(settings, packages));
                    List<String> list = packages;
                    return list;
                }
                finally {
                    LOG.info("Done 'bower search --json' command");
                    Object object = this.myLoadRunLock;
                    synchronized (object) {
                        this.myCurrentLoadRun = null;
                    }
                }
            });
            this.myCurrentLoadRun = loadRun = new LoadRun(settings, commandRun, future);
        }
        future.run();
        LoadRun loadRun3 = loadRun;
        if (loadRun3 == null) {
            BowerAvailablePackagesManager.$$$reportNull$$$0(6);
        }
        return loadRun3;
    }

    @NotNull
    private static List<String> parseAllPackages(@NotNull String jsonContent) throws IOException {
        if (jsonContent == null) {
            BowerAvailablePackagesManager.$$$reportNull$$$0(7);
        }
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(jsonContent));
        jsonReader.setLenient(false);
        JsonToken topLevelToken = jsonReader.peek();
        if (topLevelToken != JsonToken.BEGIN_ARRAY) {
            LOG.warn("[parse all bower packages] Top-level element should be object, but " + topLevelToken + " found.");
            List<String> list = Collections.emptyList();
            if (list == null) {
                BowerAvailablePackagesManager.$$$reportNull$$$0(8);
            }
            return list;
        }
        jsonReader.beginArray();
        ArrayList packages = ContainerUtil.newArrayList();
        while (jsonReader.hasNext()) {
            JsonToken childToken = jsonReader.peek();
            if (childToken == JsonToken.BEGIN_OBJECT) {
                String packageName = JsonUtil.getChildAsString((JsonReader)jsonReader, (String)"name");
                if (!StringUtil.isNotEmpty((String)packageName)) continue;
                packages.add(packageName);
                continue;
            }
            jsonReader.skipValue();
        }
        jsonReader.endArray();
        Collections.sort(packages);
        ImmutableList immutableList = ImmutableList.copyOf((Collection)packages);
        if (immutableList == null) {
            BowerAvailablePackagesManager.$$$reportNull$$$0(9);
        }
        return immutableList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/bower/BowerAvailablePackagesManager";
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/bower/BowerAvailablePackagesManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrLoadAvailablePackages";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateLoadRun";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAllPackages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOrLoadAvailablePackages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateLoadRun";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseAllPackages";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOrCreateLoadRun$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LoadRun {
        private final BowerSettings mySettings;
        private final BowerCommandRun myCommandRun;
        private final Future<List<String>> myFuture;

        public LoadRun(@NotNull BowerSettings settings, @NotNull BowerCommandRun commandRun, @NotNull Future<List<String>> future) {
            if (settings == null) {
                LoadRun.$$$reportNull$$$0(0);
            }
            if (commandRun == null) {
                LoadRun.$$$reportNull$$$0(1);
            }
            if (future == null) {
                LoadRun.$$$reportNull$$$0(2);
            }
            this.mySettings = settings;
            this.myCommandRun = commandRun;
            this.myFuture = future;
        }

        @NotNull
        public BowerSettings getSettings() {
            BowerSettings bowerSettings = this.mySettings;
            if (bowerSettings == null) {
                LoadRun.$$$reportNull$$$0(3);
            }
            return bowerSettings;
        }

        @NotNull
        public Future<List<String>> getFuture() {
            Future<List<String>> future = this.myFuture;
            if (future == null) {
                LoadRun.$$$reportNull$$$0(4);
            }
            return future;
        }

        public void terminate() {
            this.myCommandRun.terminate();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandRun";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "future";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/bower/BowerAvailablePackagesManager$LoadRun";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/bower/BowerAvailablePackagesManager$LoadRun";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFuture";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Result {
        private final BowerSettings mySettings;
        private final List<String> myPackages;

        private Result(@NotNull BowerSettings settings, @NotNull List<String> packages) {
            if (settings == null) {
                Result.$$$reportNull$$$0(0);
            }
            if (packages == null) {
                Result.$$$reportNull$$$0(1);
            }
            this.mySettings = settings;
            this.myPackages = packages;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "packages";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/bower/BowerAvailablePackagesManager$Result";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

