/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.intellij.ide.util.projectWizard.ModuleNameLocationSettings;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.boilerplate.NpmPackageProjectGenerator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.ui.TextAccessor;
import com.intellij.util.Consumer;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmPackageGeneratorPeerExtensible
implements WebProjectGenerator.GeneratorPeer<NpmPackageProjectGenerator.Settings> {
    public final JPanel myPanel;
    @NotNull
    private final List<String> myPackageNames;
    @NotNull
    private final String myPresentablePackageName;
    @NotNull
    private final Convertor<String, String> myValidator;
    private NodeJsInterpreterField myInterpreter;
    protected NodePackageField myPackageField;
    private TextAccessor myLocation;

    public NpmPackageGeneratorPeerExtensible(@NotNull List<String> packageNames, @NotNull String presentablePackageName, @NotNull Convertor<String, String> validator) {
        if (packageNames == null) {
            NpmPackageGeneratorPeerExtensible.$$$reportNull$$$0(0);
        }
        if (presentablePackageName == null) {
            NpmPackageGeneratorPeerExtensible.$$$reportNull$$$0(1);
        }
        if (validator == null) {
            NpmPackageGeneratorPeerExtensible.$$$reportNull$$$0(2);
        }
        this.myPackageNames = packageNames;
        this.myPresentablePackageName = presentablePackageName;
        this.myValidator = validator;
        this.myPanel = this.createPanel();
    }

    protected JPanel createPanel() {
        Project project = ProjectManager.getInstance().getDefaultProject();
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        this.myInterpreter = new NodeJsInterpreterField(project, false){

            @Override
            public boolean isDefaultProjectInterpreterField() {
                return true;
            }
        };
        this.myInterpreter.setInterpreterRef(NodeJsInterpreterManager.getInstance(project).getInterpreterRef());
        LabeledComponent component = LabeledComponent.create((JComponent)((Object)this.myInterpreter), (String)"Node &interpreter:");
        component.setLabelLocation("West");
        panel.add((Component)component);
        this.myPackageField = new NodePackageField(project, this.myPackageNames, () -> this.myInterpreter.getInterpreter());
        this.myPackageField.setSelected(NodePackage.findPreferredPackage(project, this.myPackageNames, this.myInterpreter.getInterpreter()));
        component = LabeledComponent.create((JComponent)((Object)this.myPackageField), (String)this.myPresentablePackageName);
        component.setAnchor((JComponent)panel.getComponent(0));
        component.setLabelLocation("West");
        panel.add((Component)component);
        JPanel myPanel = panel;
        return myPanel;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            NpmPackageGeneratorPeerExtensible.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    public void buildUI(@NotNull SettingsStep settingsStep) {
        ModuleNameLocationSettings field;
        if (settingsStep == null) {
            NpmPackageGeneratorPeerExtensible.$$$reportNull$$$0(4);
        }
        if ((field = settingsStep.getModuleNameLocationSettings()) != null) {
            this.myLocation = new TextAccessor(){

                public void setText(String text) {
                    field.setModuleName(text);
                }

                public String getText() {
                    return field.getModuleName();
                }
            };
        }
        settingsStep.addSettingsField(UIUtil.replaceMnemonicAmpersand((String)"Node &interpreter:"), (JComponent)((Object)this.myInterpreter));
        settingsStep.addSettingsField(UIUtil.replaceMnemonicAmpersand((String)this.myPresentablePackageName), (JComponent)((Object)this.myPackageField));
    }

    @NotNull
    public NpmPackageProjectGenerator.Settings getSettings() {
        NpmPackageProjectGenerator.Settings settings = new NpmPackageProjectGenerator.Settings(this.myInterpreter.getInterpreterRef(), this.myPackageField.getSelected());
        if (settings == null) {
            NpmPackageGeneratorPeerExtensible.$$$reportNull$$$0(5);
        }
        return settings;
    }

    @Nullable
    public ValidationInfo validate() {
        String validateMessage;
        NodeJsInterpreter interpreter = this.myInterpreter.getInterpreter();
        String error = NodeJsLocalInterpreter.getErrorMessage(interpreter);
        if (error != null) {
            return new ValidationInfo(error);
        }
        String pkgError = this.myPackageField.getSelected().getErrorMessage(UIUtil.replaceMnemonicAmpersand((String)this.myPresentablePackageName));
        if (pkgError != null) {
            return new ValidationInfo(pkgError);
        }
        if (this.myLocation == null) {
            Component component = this.myInterpreter.getParent().getParent().getComponent(0);
            JComponent innerComponent = component instanceof LabeledComponent ? ((LabeledComponent)component).getComponent() : null;
            this.myLocation = innerComponent instanceof TextAccessor ? (TextAccessor)innerComponent : null;
        }
        String string = validateMessage = this.myLocation != null ? (String)this.myValidator.convert((Object)this.myLocation.getText()) : null;
        if (validateMessage != null) {
            return new ValidationInfo(validateMessage);
        }
        return null;
    }

    public boolean isBackgroundJobRunning() {
        return false;
    }

    public void addSettingsStateListener(@NotNull WebProjectGenerator.SettingsStateListener listener2) {
        if (listener2 == null) {
            NpmPackageGeneratorPeerExtensible.$$$reportNull$$$0(6);
        }
        this.myInterpreter.addChangeListener(interpreter -> {
            if (listener2 == null) {
                NpmPackageGeneratorPeerExtensible.$$$reportNull$$$0(8);
            }
            listener2.stateChanged(this.validate() == null);
        });
        this.myPackageField.addSelectionListener((Consumer<NodePackage>)((Consumer)newPackage -> {
            if (listener2 == null) {
                NpmPackageGeneratorPeerExtensible.$$$reportNull$$$0(7);
            }
            listener2.stateChanged(this.validate() == null);
        }));
        listener2.stateChanged(this.validate() == null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNames";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentablePackageName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/boilerplate/NpmPackageGeneratorPeerExtensible";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/boilerplate/NpmPackageGeneratorPeerExtensible";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildUI";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addSettingsStateListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addSettingsStateListener$2";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addSettingsStateListener$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

