/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lexer.FlexLexer;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;

public class JSLexerUtil {
    public static boolean canBeFlowGenericArgumentList(FlexLexer lexer) throws IOException {
        IElementType next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        if (next != JSTokenTypes.IDENTIFIER) {
            return false;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        return next == JSTokenTypes.GT || next == JSTokenTypes.COMMA || next == JSTokenTypes.EXTENDS_KEYWORD;
    }

    public static boolean shouldLexTag(boolean isFlow, FlexLexer lexer) throws IOException {
        IElementType next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        if (next == JSTokenTypes.PLUS || next == JSTokenTypes.MINUS) {
            return false;
        }
        if (!JSKeywordSets.IDENTIFIER_NAMES.contains(next)) {
            return true;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        if (next == JSTokenTypes.EXTENDS_KEYWORD) {
            next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
            return next == JSTokenTypes.EQ;
        }
        if (next == JSTokenTypes.COLON || next == JSTokenTypes.EQ || next == JSTokenTypes.COMMA) {
            return false;
        }
        if (next == JSTokenTypes.GT) {
            next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
            if (next != JSTokenTypes.LPAR) {
                return true;
            }
            return !JSLexerUtil.isParameterListAfterGenericParams(isFlow, lexer);
        }
        return true;
    }

    private static boolean isParameterListAfterGenericParams(boolean isFlow, FlexLexer lexer) throws IOException {
        IElementType next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        if (next == JSTokenTypes.LBRACE || next == JSTokenTypes.LBRACKET) {
            return true;
        }
        if (next == JSTokenTypes.IDENTIFIER && (next = JSLexerUtil.skipCommentsAndWhitespaces(lexer)) == JSTokenTypes.QUEST) {
            next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        }
        if (next == JSTokenTypes.COLON || next == JSTokenTypes.COMMA) {
            return true;
        }
        if (isFlow && next == JSTokenTypes.LPAR) {
            return true;
        }
        if (next != JSTokenTypes.RPAR && !isFlow) {
            return false;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        if (next != JSTokenTypes.LT || !isFlow) {
            return true;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        if (next != JSTokenTypes.IDENTIFIER) {
            return true;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        return next != JSTokenTypes.COMMA && next != JSTokenTypes.EXTENDS_KEYWORD && next != JSTokenTypes.GT;
    }

    private static IElementType skipCommentsAndWhitespaces(FlexLexer lexer) throws IOException {
        IElementType next = lexer.advance();
        while (JSTokenTypes.COMMENTS_AND_WHITESPACES.contains(next)) {
            next = lexer.advance();
        }
        return next;
    }
}

