/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ReferenceExpressionsInfo {
    public static final ES6ReferenceExpressionsInfo EMPTY = new ES6ReferenceExpressionsInfo(ContainerUtil.emptyList(), ContainerUtil.emptyList(), ContainerUtil.newHashMap());
    @NotNull
    private final Collection<PsiElement> myLocals;
    @NotNull
    private final Collection<PsiElement> myExportedLocals;
    @NotNull
    private final Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> myImports;

    private ES6ReferenceExpressionsInfo(@NotNull Collection<PsiElement> locals, @NotNull Collection<PsiElement> exportedLocals, @NotNull Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> imports) {
        if (locals == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(0);
        }
        if (exportedLocals == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(1);
        }
        if (imports == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(2);
        }
        this.myLocals = locals;
        this.myExportedLocals = exportedLocals;
        this.myImports = imports;
    }

    @NotNull
    public Collection<PsiElement> getLocalReferencedElements() {
        Collection<PsiElement> collection = this.myLocals;
        if (collection == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> getReferencedImports() {
        Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> map = this.myImports;
        if (map == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(4);
        }
        return map;
    }

    @NotNull
    public Collection<PsiElement> getExportedLocalReferencedElements() {
        Collection<PsiElement> collection = this.myExportedLocals;
        if (collection == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    public static List<String> getLocalReferencedElementValidations(@NotNull ES6ReferenceExpressionsInfo info, @NotNull JSPsiElementBase element, @NotNull Condition<PsiElement> containedInMovedFilter) {
        if (info == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(6);
        }
        if (element == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(7);
        }
        if (containedInMovedFilter == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(8);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        Collection<PsiElement> localReferencedElements = info.getLocalReferencedElements();
        for (PsiElement referencedElement : localReferencedElements) {
            if (containedInMovedFilter.value((Object)referencedElement)) continue;
            String name = ResolveProcessor.getName(referencedElement);
            String elementDescription = RefactoringUIUtil.getDescription((PsiElement)element, (boolean)false);
            if (referencedElement instanceof ES6ImportSpecifier) {
                String message = JSBundle.message((String)"es6.move.module.members.references.unresolved.import.message", (Object[])new Object[]{elementDescription, name});
                result2.add(message);
                continue;
            }
            String referencedDescription = RefactoringUIUtil.getDescription((PsiElement)referencedElement, (boolean)false);
            String message = JSBundle.message((String)"es6.move.module.members.references.local.message", (Object[])new Object[]{elementDescription, referencedDescription});
            result2.add(message);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    public static ES6ReferenceExpressionsInfo getInfo(@NotNull JSPsiElementBase element) {
        if (element == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(10);
        }
        ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = ES6ReferenceExpressionsInfo.getInfo(element, ES6PsiUtil.findExternalModule((PsiElement)element));
        if (eS6ReferenceExpressionsInfo == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(11);
        }
        return eS6ReferenceExpressionsInfo;
    }

    @NotNull
    public static ES6ReferenceExpressionsInfo getInfo(final @NotNull JSPsiElementBase element, final PsiElement module) {
        if (element == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(12);
        }
        if (module == null) {
            ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = EMPTY;
            if (eS6ReferenceExpressionsInfo == null) {
                ES6ReferenceExpressionsInfo.$$$reportNull$$$0(13);
            }
            return eS6ReferenceExpressionsInfo;
        }
        final ArrayList locals = ContainerUtil.newArrayList();
        final ArrayList exportedLocals = ContainerUtil.newArrayList();
        final LinkedHashMap imports = ContainerUtil.newLinkedHashMap();
        element.acceptChildren((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                ResolveResult[] results;
                super.visitJSReferenceExpression(node);
                if (node.getQualifier() != null) {
                    return;
                }
                String referenceName = node.getReferenceName();
                if (StringUtil.isEmpty((String)referenceName)) {
                    return;
                }
                for (ResolveResult result2 : results = node.multiResolve(false)) {
                    PsiElement resultElement = result2.getElement();
                    if (!result2.isValidResult() || resultElement == null || !(result2 instanceof JSResolveResult)) continue;
                    PsiElement resultModule = ES6PsiUtil.findExternalModule(resultElement);
                    if (module.isEquivalentTo(resultModule) && !(resultElement instanceof ES6ImportedBinding) && !(resultElement instanceof ES6ImportSpecifierAlias)) {
                        if (PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)resultElement, (boolean)false)) continue;
                        List toProcess = ES6ImportHandler.isExportedWithNameOrDefault(resultElement) ? exportedLocals : locals;
                        toProcess.add(resultElement);
                        continue;
                    }
                    Pair<PsiElement, ES6ImportPsiUtil.CreateImportExportInfo> info = ES6ReferenceExpressionsInfo.getImportInfo(referenceName, (JSResolveResult)result2, module);
                    if (info == null) continue;
                    imports.put(info.second, info.first);
                }
            }
        });
        ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = new ES6ReferenceExpressionsInfo(locals, exportedLocals, imports);
        if (eS6ReferenceExpressionsInfo == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(14);
        }
        return eS6ReferenceExpressionsInfo;
    }

    @Nullable
    public static Pair<PsiElement, ES6ImportPsiUtil.CreateImportExportInfo> getImportInfo(@NotNull String referenceName, @NotNull JSResolveResult jsResolveResult, @Nullable PsiElement filterModule) {
        Pair<PsiElement, ES6ImportPsiUtil.CreateImportExportInfo> info;
        if (referenceName == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(15);
        }
        if (jsResolveResult == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(16);
        }
        return (info = ES6ReferenceExpressionsInfo.doGetImportInfo(referenceName, jsResolveResult, filterModule)) != null && (info.first instanceof ES6ImportExportDeclarationPart || ES6ReferenceExpressionsInfo.isAvailableForES6Import((PsiElement)info.first)) ? info : null;
    }

    @Nullable
    private static Pair<PsiElement, ES6ImportPsiUtil.CreateImportExportInfo> doGetImportInfo(@NotNull String referenceName, @NotNull JSResolveResult jsResolveResult, @Nullable PsiElement filterModule) {
        ES6ImportExportDeclaration es6Import;
        if (referenceName == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(17);
        }
        if (jsResolveResult == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(18);
        }
        PsiElement resultElement = jsResolveResult.getElement();
        if (!jsResolveResult.isValidResult() || resultElement == null) {
            return null;
        }
        ES6ImportExportDeclarationPart importPart = jsResolveResult.getES6Import();
        ES6ImportExportDeclaration eS6ImportExportDeclaration = es6Import = importPart == null ? null : importPart.getDeclaration();
        if (es6Import == null) {
            if (resultElement instanceof ES6ImportedBinding) {
                JSElement defaultElement;
                Collection elements = ((ES6ImportedBinding)resultElement).findReferencedElements();
                PsiElement item = (PsiElement)ContainerUtil.getFirstItem((Collection)elements);
                if (item instanceof ES6ExportDefaultAssignment && (defaultElement = ((ES6ExportDefaultAssignment)item).getStubSafeElement()) instanceof JSQualifiedNamedElement) {
                    item = defaultElement;
                }
                if (item != null) {
                    return ES6ReferenceExpressionsInfo.createForBinding(referenceName, item, (ES6ImportedBinding)resultElement);
                }
                return null;
            }
            if (resultElement instanceof ES6ImportSpecifierAlias) {
                ES6ImportSpecifierAlias alias = (ES6ImportSpecifierAlias)resultElement;
                PsiElement resolvedElement = alias.findAliasedElement();
                ES6ImportExportSpecifier specifierElement = alias.findSpecifierElement();
                if (resolvedElement != null && specifierElement != null) {
                    ES6ImportPsiUtil.CreateImportExportInfo info = ES6ReferenceExpressionsInfo.createImportInfoForSpecifier(referenceName, (ES6ImportSpecifier)specifierElement, alias);
                    return Pair.create((Object)resolvedElement, (Object)info);
                }
                return null;
            }
            if (resultElement instanceof ES6ImportSpecifier) {
                ES6ImportPsiUtil.CreateImportExportInfo info = ES6ReferenceExpressionsInfo.createImportInfoForSpecifier(referenceName, (ES6ImportSpecifier)resultElement, null);
                return Pair.create((Object)resultElement, (Object)info);
            }
        } else {
            if (!(es6Import instanceof ES6ImportDeclaration) || filterModule != null && !filterModule.isEquivalentTo(ES6PsiUtil.findExternalModule((PsiElement)es6Import))) {
                return null;
            }
            if (importPart instanceof ES6ImportSpecifier) {
                ES6ImportSpecifier specifier = (ES6ImportSpecifier)importPart;
                ES6ImportSpecifierAlias alias = specifier.getAlias();
                ES6ImportPsiUtil.CreateImportExportInfo info = ES6ReferenceExpressionsInfo.createImportInfoForSpecifier(referenceName, specifier, alias);
                return Pair.create((Object)resultElement, (Object)info);
            }
            if (importPart instanceof ES6ImportedBinding) {
                return ES6ReferenceExpressionsInfo.createForBinding(referenceName, resultElement, (ES6ImportedBinding)importPart);
            }
        }
        return null;
    }

    private static boolean isAvailableForES6Import(@NotNull PsiElement resolvedElement) {
        if (resolvedElement == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(19);
        }
        return !TypeScriptPsiUtil.isAugmentationModule(ES6PsiUtil.findExternalModule(resolvedElement));
    }

    @NotNull
    private static Pair<PsiElement, ES6ImportPsiUtil.CreateImportExportInfo> createForBinding(@NotNull String referenceName, @NotNull PsiElement resultElement, @NotNull ES6ImportedBinding binding) {
        if (referenceName == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(20);
        }
        if (resultElement == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(21);
        }
        if (binding == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(22);
        }
        Pair pair = Pair.create((Object)resultElement, (Object)ES6ReferenceExpressionsInfo.createImportInfoForBinding(referenceName, binding));
        if (pair == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(23);
        }
        return pair;
    }

    @NotNull
    private static ES6ImportPsiUtil.CreateImportExportInfo createImportInfoForBinding(String referenceName, ES6ImportedBinding binding) {
        ES6ImportPsiUtil.ImportExportType importType = binding.isNamespaceImport() ? ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL : ES6ImportPsiUtil.ImportExportType.DEFAULT;
        ES6ImportPsiUtil.CreateImportExportInfo createImportExportInfo = new ES6ImportPsiUtil.CreateImportExportInfo(referenceName, null, importType, true, ES6ReferenceExpressionsInfo.isFlowTypeContext((ES6ImportExportDeclarationPart)binding));
        if (createImportExportInfo == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(24);
        }
        return createImportExportInfo;
    }

    @NotNull
    private static ES6ImportPsiUtil.CreateImportExportInfo createImportInfoForSpecifier(String referenceName, ES6ImportSpecifier specifier, ES6ImportSpecifierAlias alias) {
        ES6ImportPsiUtil.CreateImportExportInfo createImportExportInfo = new ES6ImportPsiUtil.CreateImportExportInfo(alias == null ? referenceName : specifier.getCanonicalText(), referenceName, ES6ImportPsiUtil.ImportExportType.SPECIFIER, true, ES6ReferenceExpressionsInfo.isFlowTypeContext((ES6ImportExportDeclarationPart)specifier));
        if (createImportExportInfo == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(25);
        }
        return createImportExportInfo;
    }

    private static boolean isFlowTypeContext(@NotNull ES6ImportExportDeclarationPart part) {
        ES6ImportExportDeclaration declaration;
        if (part == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(26);
        }
        if ((declaration = part.getDeclaration()) == null || !DialectDetector.isFlow((PsiElement)part)) {
            return false;
        }
        ASTNode node = declaration.getNode();
        ASTNode keyword = node.findChildByType(JSTokenTypes.IMPORT_KEYWORD);
        if (keyword != null) {
            if (ES6ReferenceExpressionsInfo.isTypeImport(keyword.getPsi())) {
                return true;
            }
            if (part instanceof ES6ImportSpecifier) {
                PsiElement firstChild = part.getFirstChild();
                return firstChild != null && firstChild.getNode().getElementType() == JSTokenTypes.TYPE_KEYWORD;
            }
        }
        return false;
    }

    public static boolean isTypeImport(@NotNull PsiElement importKeyWord) {
        PsiElement next;
        if (importKeyWord == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(27);
        }
        if ((next = importKeyWord.getNextSibling()) != null) {
            PsiElement typeElement;
            PsiElement psiElement = typeElement = next instanceof PsiWhiteSpace ? next.getNextSibling() : next;
            if (typeElement != null && typeElement.getNode().getElementType() == JSTokenTypes.TYPE_KEYWORD) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locals";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportedLocals";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containedInMovedFilter";
                break;
            }
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsResolveResult";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultElement";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importKeyWord";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalReferencedElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedImports";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportedLocalReferencedElements";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalReferencedElementValidations";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfo";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createForBinding";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportInfoForBinding";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportInfoForSpecifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLocalReferencedElementValidations";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getImportInfo";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doGetImportInfo";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForES6Import";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createForBinding";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isFlowTypeContext";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isTypeImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

