/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathBuilder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSModulePattern;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImportPathBuilder
extends JSImportPathBuilder {
    @Nullable
    private final TypeScriptConfig myConfigFile;

    public TypeScriptImportPathBuilder(@NotNull PsiElement place, @Nullable PsiElement elementToImport, @NotNull VirtualFile importedFile, @Nullable TypeScriptConfig configFile, boolean useExistingImports) {
        if (place == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(0);
        }
        if (importedFile == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(1);
        }
        super(place, elementToImport, importedFile, useExistingImports);
        this.myConfigFile = configFile;
    }

    @Override
    protected boolean useNodeResolution() {
        if (!super.useNodeResolution()) {
            return false;
        }
        if (this.myConfigFile == null) {
            return true;
        }
        TypeScriptConfig.ModuleResolution resolution = this.myConfigFile.getResolution();
        if (resolution == TypeScriptConfig.ModuleResolution.NODE) {
            return true;
        }
        return TypeScriptConfig.ModuleTarget.COMMON_JS == this.myConfigFile.getModule();
    }

    @Override
    public void processModuleNames(@NotNull Processor<JSModuleNameInfo> processor) {
        JSModuleNameInfo mapping;
        if (processor == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(2);
        }
        if (!this.processExistingImports(processor)) {
            return;
        }
        if (this.myConfigFile != null && (mapping = this.getModuleNameUsingPathMappings()) != null && !processor.process((Object)mapping)) {
            return;
        }
        if (!this.processModuleNameUsingNodeModules(processor)) {
            return;
        }
        super.processModuleNames(processor);
    }

    @Nullable
    private JSModuleNameInfo getModuleNameUsingPathMappings() {
        if (this.myConfigFile == null) {
            return null;
        }
        VirtualFile baseUrl = this.myConfigFile.getBaseUrl();
        if (baseUrl == null) {
            return null;
        }
        JSModuleNameInfo currentMapping = null;
        for (JSModulePathSubstitution substitution : this.myConfigFile.getPaths()) {
            String pattern = substitution.getPattern();
            if (StringUtil.isEmpty((String)pattern)) continue;
            for (String mapping : substitution.getMappings()) {
                JSModuleNameInfo possibleMapping;
                if (StringUtil.isEmpty((String)mapping) || (possibleMapping = this.getModuleNameForMapping(baseUrl, pattern, mapping)) == null || !TypeScriptImportPathBuilder.shouldUseNewMapping(currentMapping, possibleMapping)) continue;
                currentMapping = possibleMapping;
            }
        }
        return currentMapping;
    }

    @Nullable
    private JSModuleNameInfo getModuleNameForMapping(@NotNull VirtualFile baseUrl, @NotNull String pattern, @NotNull String mapping) {
        boolean hasSeparatorInFirstPart;
        if (baseUrl == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(3);
        }
        if (pattern == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(4);
        }
        if (mapping == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(5);
        }
        mapping = FileUtil.toSystemIndependentName((String)mapping);
        int starIndex = mapping.indexOf("*");
        if (pattern.length() < 2) {
            return null;
        }
        if (starIndex < 0) {
            VirtualFile pathFile = TypeScriptImportPathBuilder.getPossibleFileWithExtension(baseUrl, mapping);
            if (pathFile == null) {
                return null;
            }
            VirtualFile file2 = TypeScriptImportPathBuilder.isFromNestedDirectory(pathFile, this.myFileToImport) ? this.checkSymbolAndGetFile(pathFile) : null;
            return file2 == null ? null : new JSModuleNameInfo(pattern, pathFile, file2, this.myPlace);
        }
        String firstPart = mapping.substring(0, starIndex);
        int separatorIndex = firstPart.lastIndexOf(47);
        VirtualFile startDirectory = baseUrl;
        boolean bl = hasSeparatorInFirstPart = separatorIndex >= 0;
        if (hasSeparatorInFirstPart) {
            startDirectory = JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, firstPart.substring(0, separatorIndex));
        }
        if (startDirectory == null) {
            return null;
        }
        List<VirtualFile> parents = TypeScriptImportPathBuilder.collectParents(this.myFileToImport, startDirectory);
        if (parents.isEmpty()) {
            return null;
        }
        VirtualFile placeDirectory = this.myPlaceFile.getParent();
        String partOfString = mapping.substring(hasSeparatorInFirstPart ? separatorIndex : 0);
        for (VirtualFile pathFile : ContainerUtil.reverse(parents)) {
            VirtualFile file3;
            String stringToCheckPattern;
            if (pathFile.equals(placeDirectory) || StringUtil.isEmpty((String)(stringToCheckPattern = VfsUtilCore.findRelativePath((VirtualFile)startDirectory, (VirtualFile)pathFile, (char)'/')))) continue;
            JSModulePattern pathSubstitution = JSPathMappingsUtil.createPatternForString(partOfString);
            Pair matchedStar = JSPathMappingsUtil.findMaxElementByPaths((hasSeparatorInFirstPart ? "/" : "") + stringToCheckPattern, ContainerUtil.createMaybeSingletonList((Object)pathSubstitution));
            if (matchedStar == null || (file3 = this.checkSymbolAndGetFile(pathFile)) == null) continue;
            return new JSModuleNameInfo(pattern.replace("*", (CharSequence)matchedStar.second), file3, pathFile, this.myPlaceModule);
        }
        return null;
    }

    private boolean processModuleNameUsingNodeModules(@NotNull Processor<JSModuleNameInfo> processor) {
        Pair<VirtualFile, VirtualFile> libraryDirectory;
        if (processor == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(6);
        }
        if ((libraryDirectory = ES6CreateImportUtil.findParentLibraryDirectory(this.myProject, this.myFileToImport, TypeScriptAutoImportUtil.NODE_MODULES)) == null) {
            return true;
        }
        VirtualFile moduleDirectory = (VirtualFile)libraryDirectory.first;
        VirtualFile directoryToCalcModuleName = TypeScriptImportPathBuilder.getDirectoryToCalcModuleNameInNodeModules(this.myPlaceModule.getContainingFile(), moduleDirectory);
        if (directoryToCalcModuleName == null) {
            return true;
        }
        THashSet visited = ContainerUtil.newTroveSet();
        if (!this.processForModuleCandidate(processor, moduleDirectory, directoryToCalcModuleName, moduleDirectory, (Set<VirtualFile>)visited)) {
            return false;
        }
        if (this.myElementToImport != null && !moduleDirectory.equals(this.myFileToImport.getParent())) {
            for (VirtualFile candidate : moduleDirectory.getChildren()) {
                if (!candidate.isDirectory() && !TypeScriptUtil.isDefinitionFile(candidate) || !visited.add(candidate) || this.processForModuleCandidate(processor, moduleDirectory, directoryToCalcModuleName, candidate, (Set<VirtualFile>)visited)) continue;
                return false;
            }
        }
        ArrayList parents = ContainerUtil.newArrayList(TypeScriptImportPathBuilder.collectParents(this.myFileToImport, moduleDirectory));
        for (VirtualFile candidate : ContainerUtil.reverse((List)parents)) {
            if (!visited.add(candidate) || this.processForModuleCandidate(processor, moduleDirectory, directoryToCalcModuleName, candidate, (Set<VirtualFile>)visited)) continue;
            return false;
        }
        JSModuleNameInfo moduleInfo = this.createNodeModuleNameInfo(moduleDirectory, directoryToCalcModuleName, this.myFileToImport, this.myFileToImport, this.myPlace);
        return processor.process((Object)moduleInfo);
    }

    private boolean processForModuleCandidate(@NotNull Processor<JSModuleNameInfo> processor, @NotNull VirtualFile moduleDirectory, @NotNull VirtualFile directoryToCalcModuleName, @NotNull VirtualFile moduleCandidate, @NotNull Set<VirtualFile> visited) {
        if (processor == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(7);
        }
        if (moduleDirectory == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(8);
        }
        if (directoryToCalcModuleName == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(9);
        }
        if (moduleCandidate == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(10);
        }
        if (visited == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(11);
        }
        if (moduleCandidate.equals(this.myFileToImport)) {
            return true;
        }
        VirtualFile resolvedCandidate = this.checkSymbolAndGetFile(moduleCandidate);
        if (resolvedCandidate != null && TypeScriptUtil.isDefinitionFile(resolvedCandidate)) {
            visited.add(resolvedCandidate);
            if (!processor.process((Object)this.createNodeModuleNameInfo(moduleDirectory, directoryToCalcModuleName, moduleCandidate, resolvedCandidate, this.myPlace))) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    protected JSModuleNameInfo createNodeModuleNameInfo(@NotNull VirtualFile moduleDirectory, @NotNull VirtualFile directoryToCalcModuleName, @NotNull VirtualFile moduleOrFileToImport, @NotNull VirtualFile candidate, @NotNull PsiElement context) {
        if (moduleDirectory == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(12);
        }
        if (directoryToCalcModuleName == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(13);
        }
        if (moduleOrFileToImport == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(14);
        }
        if (candidate == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(15);
        }
        if (context == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(16);
        }
        String path = TypeScriptImportPathBuilder.getNodeModulePath(moduleDirectory, directoryToCalcModuleName, moduleOrFileToImport);
        JSModuleNameInfo jSModuleNameInfo = new JSModuleNameInfo(path, moduleOrFileToImport, candidate, context);
        if (jSModuleNameInfo == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(17);
        }
        return jSModuleNameInfo;
    }

    @Nullable
    private static String getNodeModulePath(@NotNull VirtualFile moduleDirectory, @NotNull VirtualFile directoryToCalcModuleName, @NotNull VirtualFile moduleOrFileToImport) {
        String path;
        if (moduleDirectory == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(18);
        }
        if (directoryToCalcModuleName == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(19);
        }
        if (moduleOrFileToImport == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(20);
        }
        if ((path = VfsUtilCore.findRelativePath((VirtualFile)directoryToCalcModuleName, (VirtualFile)moduleOrFileToImport, (char)'/')) == null || !"@types".equals(directoryToCalcModuleName.getName())) {
            return path;
        }
        String name = moduleDirectory.getName();
        if (!path.startsWith(name)) {
            return path;
        }
        int separatorIndex = name.indexOf("__");
        if (separatorIndex <= 0) {
            return path;
        }
        String scope = name.substring(0, separatorIndex);
        String module = name.substring(separatorIndex + 2);
        if (scope.isEmpty() || module.isEmpty()) {
            return path;
        }
        String subPath = path.substring(name.length());
        return "@" + scope + "/" + module + subPath;
    }

    private static boolean shouldUseNewMapping(@Nullable JSModuleNameInfo oldMapping, @NotNull JSModuleNameInfo newMapping) {
        if (newMapping == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(21);
        }
        if (oldMapping == null) {
            return true;
        }
        return oldMapping.getPath().length() > newMapping.getPath().length();
    }

    private static VirtualFile getPossibleFileWithExtension(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(22);
        }
        if (mapping == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(23);
        }
        if (JSFileReference.findExtension(mapping, TypeScriptUtil.TYPESCRIPT_EXTENSIONS) != null) {
            return JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, mapping);
        }
        for (String extension : TypeScriptUtil.TYPESCRIPT_EXTENSIONS) {
            VirtualFile possibleFile = JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, mapping + extension);
            if (possibleFile == null) continue;
            return possibleFile;
        }
        return JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, mapping);
    }

    private static boolean isFromNestedDirectory(VirtualFile parentFile, VirtualFile dstFile) {
        if (parentFile.equals(dstFile)) {
            return true;
        }
        if (!parentFile.isDirectory()) {
            parentFile = parentFile.getParent();
        }
        return VfsUtilCore.isAncestor((VirtualFile)parentFile, (VirtualFile)dstFile, (boolean)false);
    }

    @NotNull
    private static List<VirtualFile> collectParents(@NotNull VirtualFile dstFile, @NotNull VirtualFile startDirectory) {
        if (dstFile == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(24);
        }
        if (startDirectory == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(25);
        }
        ArrayList parents = ContainerUtil.newArrayList((Object[])new VirtualFile[]{dstFile});
        boolean hasParent = false;
        for (VirtualFile parent = dstFile.getParent(); parent != null; parent = parent.getParent()) {
            if (startDirectory.equals(parent)) {
                hasParent = true;
                break;
            }
            parents.add(parent);
        }
        if (!hasParent) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptImportPathBuilder.$$$reportNull$$$0(26);
            }
            return list;
        }
        ArrayList arrayList = parents;
        if (arrayList == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @Nullable
    private VirtualFile getRootFromConfig() {
        if (this.myConfigFile == null) {
            return null;
        }
        VirtualFile baseUrl = this.myConfigFile.getBaseUrl();
        return baseUrl != null ? baseUrl : this.myConfigFile.getConfigDirectory();
    }

    @Override
    @Nullable
    protected JSModuleNameInfo processRootPaths(@NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile) {
        VirtualFile rootFile;
        if (moduleFileOrDirectory == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(28);
        }
        if (resolvedModuleFile == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(29);
        }
        if ((rootFile = this.getRootFromConfig()) != null) {
            return this.getPathForRoot(moduleFileOrDirectory, resolvedModuleFile, rootFile);
        }
        return super.processRootPaths(moduleFileOrDirectory, resolvedModuleFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedFile";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 8: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDirectory";
                break;
            }
            case 9: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryToCalcModuleName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleCandidate";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleOrFileToImport";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 17: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/TypeScriptImportPathBuilder";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMapping";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dstFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startDirectory";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFileOrDirectory";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedModuleFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/TypeScriptImportPathBuilder";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeModuleNameInfo";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "collectParents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processModuleNames";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModuleNameForMapping";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processModuleNameUsingNodeModules";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processForModuleCandidate";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createNodeModuleNameInfo";
                break;
            }
            case 17: 
            case 26: 
            case 27: {
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getNodeModulePath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseNewMapping";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleFileWithExtension";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collectParents";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processRootPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

